library(growth)

y <- restovec(read.table("pills.dat",skip=5))
f <- matrix(rep(c(0.9,0.7,0.5,0.3,0.25,0.1),17),nrow=17,byrow=T)
f <- tvctomat(f)
group1 <- cbind(c(rep(0,6),rep(1,4),rep(0,7)),c(rep(0,10),rep(1,4),rep(0,3)),
	c(rep(0,14),rep(1,3)))
colnames(group1) <- c("group2","group3","group4")
group <- tcctomat(group1)
reps <- rmna(y,tvc=f,ccov=group)

elliptic(reps)
mu <- ~b+(1-f^kap)/k
elliptic(reps,model=mu,preg=c(12,0.68,0.04))
mu2 <- ~b+b2*group2+b3*group3+b4*group4+(1-f^kap)/k
elliptic(reps,model=mu2,preg=c(12,0,0,0,0.68,0.04))
mu3 <- ~b+(1-f^kap)/(k+k2*group2+k3*group3+k4*group4)
elliptic(reps,model=mu3,preg=c(11,0.68,0.04,0,0,0))
mu4 <- ~b+b2*group2+b3*group3+b4*group4+(1-f^kap)/
	(k+k2*group2+k3*group3+k4*group4)
elliptic(reps,model=mu4,preg=c(11,0,0,0,0.68,0.04,0,0,0))
mu5 <- ~b+b2*(group2+group3+group4)+(1-f^kap)/
	(k+k2*group2+k3*group3+k4*group4)
elliptic(reps,model=mu5,preg=c(13,-3,0.68,0.04,0,0,0))
mu6 <- ~b+b2*(group2+group3+group4)+(1-f^kap)/(k+k2*(group2+group3+group4))
elliptic(reps,model=mu6,preg=c(13,-3,0.68,0.04,0))
elliptic(reps,model=mu6,preg=c(13,-3,0.68,0.04,0),par=0.9)
elliptic(reps,model=mu6,preg=c(13,-3,0.68,0.04,0),pre=6)
elliptic(reps,model=mu6,preg=c(13,-3,0.68,0.04,0),pre=6,par=0.9)
mu7 <- ~b+b2*(group2+group3+group4)+(1-f^kap)/
	(k+k2*(group2+group4)+k3*group3)
elliptic(reps,model=mu7,preg=c(13,-3,0.68,0.04,0,0))
elliptic(reps,model=mu7,preg=c(13,-3,0.68,0.04,0,0),par=0.9)

elliptic(reps,model=mu6,preg=c(13,-3,0.68,0.04,0),par=0.9,dist="power exp",
	pell=1)
elliptic(reps,model=mu6,preg=c(13,-3,0.68,0.04,0),par=0.9,
	pell=10,dist="Student")

elliptic(reps,model=mu6,preg=c(12.6,-2.6,0.68,0.04,-0.01),
	trans="log",link="exp")
elliptic(reps,model=mu6,preg=c(12.6,-2.6,0.68,0.04,-0.01),par=0.9,
	trans="log",link="exp")
elliptic(reps,model=mu4,preg=c(13,-3,-3,-3,0.68,0.04,0,0,0),par=0.9,
	trans="log",link="exp")
elliptic(reps,model=mu5,preg=c(13,-3,0.68,0.04,0,0,0),par=0.9,
	trans="log",link="exp")
elliptic(reps,model=mu7,preg=c(13,-3,0.68,0.04,0,0),trans="log",link="exp")
print(z <- elliptic(reps,model=mu7,preg=c(13,-3,0.68,0.04,0,0),par=0.9,
	trans="log",link="exp"))

if(interactive()){
postscript("pills1.eps",height=5,width=5)
par(mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(exp(z$pred[covind(reps)==1]),c(0.9,0.7,0.5,0.3,0.25,0.1),xlim=c(10,40),
	ylim=c(0,1),ylab="Fraction remaining",xlab="",type="l")
lines(exp(z$pred[covind(reps)==7]),c(0.9,0.7,0.5,0.3,0.25,0.1),lty=2)
lines(exp(z$pred[covind(reps)==11]),c(0.9,0.7,0.5,0.3,0.25,0.1),lty=3)
legend(25,1,legend=c("Group 1","Groups 2 & 4","Group 3"),lty=1:3,bty="n")
dev.off()
postscript("pills2.eps")
par(mfrow=c(2,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(exp(z$pred[covind(reps)==1]),c(0.9,0.7,0.5,0.3,0.25,0.1),xlim=c(10,40),
	ylim=c(0,1),ylab="Fraction remaining",xlab="",type="l",
	main="Group 1")
lines(exp(z$rpred[covind(reps)==1]),c(0.9,0.7,0.5,0.3,0.25,0.1),lty=3)
points(response(reps)[covind(reps)==1],c(0.9,0.7,0.5,0.3,0.25,0.1))
lines(exp(z$rpred[covind(reps)==2]),c(0.9,0.7,0.5,0.3,0.25,0.1),lty=4)
points(response(reps)[covind(reps)==2],c(0.9,0.7,0.5,0.3,0.25,0.1),pch=2)
plot(exp(z$pred[covind(reps)==7]),c(0.9,0.7,0.5,0.3,0.25,0.1),xlim=c(10,40),
	ylim=c(0,1),ylab="",xlab="",type="l",main="Group 2")
lines(exp(z$rpred[covind(reps)==7]),c(0.9,0.7,0.5,0.3,0.25,0.1),lty=3)
points(response(reps)[covind(reps)==7],c(0.9,0.7,0.5,0.3,0.25,0.1))
lines(exp(z$rpred[covind(reps)==8]),c(0.9,0.7,0.5,0.3,0.25,0.1),lty=4)
points(response(reps)[covind(reps)==8],c(0.9,0.7,0.5,0.3,0.25,0.1),pch=2)
plot(exp(z$pred[covind(reps)==11]),c(0.9,0.7,0.5,0.3,0.25,0.1),xlim=c(10,40),
	ylim=c(0,1),ylab="Fraction remaining",xlab="Time",type="l",
	main="Group 3")
lines(exp(z$rpred[covind(reps)==11]),c(0.9,0.7,0.5,0.3,0.25,0.1),lty=3)
points(response(reps)[covind(reps)==11],c(0.9,0.7,0.5,0.3,0.25,0.1))
lines(exp(z$rpred[covind(reps)==12]),c(0.9,0.7,0.5,0.3,0.25,0.1),lty=4)
points(response(reps)[covind(reps)==12],c(0.9,0.7,0.5,0.3,0.25,0.1),pch=2)
plot(exp(z$pred[covind(reps)==15]),c(0.9,0.7,0.5,0.3,0.25,0.1),xlim=c(10,40),
	ylim=c(0,1),ylab="",xlab="Time",type="l",
	main="Group 4")
lines(exp(z$rpred[covind(reps)==15]),c(0.9,0.7,0.5,0.3,0.25,0.1),lty=3)
points(response(reps)[covind(reps)==15],c(0.9,0.7,0.5,0.3,0.25,0.1))
lines(exp(z$rpred[covind(reps)==16]),c(0.9,0.7,0.5,0.3,0.25,0.1),lty=4)
points(response(reps)[covind(reps)==16],c(0.9,0.7,0.5,0.3,0.25,0.1),pch=2)
dev.off()

mu7p <- ~b+b2*(group2+group3+group4)+(1-f^i)/(j+k2*(group2+group4)+k3*group3)
xx <- seq(0.635,0.785,by=0.01)
yy <- seq(0.04,0.052,by=0.001)
z <- like <- NULL
for(j in yy){
	z$coef <- c(12.59,-2.7,-0.0089,-0.0147,log(0.011))
		for(i in xx){
		reps <- rmna(y,tvc=f,ccov=tcctomat(data.frame(group1,
			i=rep(i,17),j=rep(j,17))))
		like <- c(like,(z <- elliptic(reps,model=mu7p,
			preg=z$coef[1:4],pvar=0.011,
			par=0.968,trans="log",link="exp",iter=50))$maxlike)
		print(c(i,j,like[length(like)],z$code,z$iter))}}
like <- matrix(like,nrow=length(xx))
dimnames(like) <- list(xx,yy)

postscript("pillscon.eps",height=5)
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
contour(xx,yy,exp(-like+min(like)),levels=seq(0.1,0.9,by=0.1),labcex=0.6)
title(xlab=expression(kappa),ylab="k")
par(mar=c(0,1,0,0))
persp(xx,yy,exp(-like+min(like)),phi=25,theta=-45,r=20,
	xlab="kappa",ylab="k",zlab="",tick="detail",cex=0.7)
dev.off()
}

elliptic(reps,model=mu6,preg=c(13,-3,0.68,0.04,0),par=0.9,
	trans="log",link="exp",dist="power exp",pell=1)
elliptic(reps,model=mu6,preg=c(13,-3,0.68,0.04,0),par=0.9,
	trans="log",link="exp",pell=10,dist="Student")
