library(gnlm)
library(growth)

data <- read.table("dnase.dat",skip=5,head=T)
attach(data)
y <- restovec(matrix(y,nrow=11,byrow=T),delta=0.001)
lconc <- matrix(log(conc <- ifelse(conc==0,0.05,conc)),nrow=11,byrow=T)
lconc <- tvctomat(lconc)
reps <- rmna(y,tvc=lconc)

mu <- ~b0+(b1-b0)/(1+exp(b3*(lconc-b2)))
lvar <- ~log(b0+(b1-b0)/(1+exp(b3*(lconc-b2))))
lvar2 <- function(p,mu) p[1]+p[2]*log(mu)

elliptic(reps,model=mu,preg=c(2.3,0.05,1,1.4))
elliptic(reps,model=mu,preg=c(2.3,0.05,1,1.4),pre=0.0001)

elliptic(reps,model=mu,preg=c(2.3,0.05,1,1.4),varfn=mu,
	pvar=c(-3.9,-3.9,1,0))
print(z0 <- elliptic(reps,model=mu,preg=c(2.3,0.05,1,1.4),varfn=lvar,
	pvar=c(0.00008,0.003,-5.6,0.8),iter=200))
elliptic(reps,model=mu,preg=c(2.4,0.026,1,1.5),varfn=lvar2,shfn=T,
	pvar=c(-6,0.63))
elliptic(reps,model=mu,preg=c(2.3,0.05,1,1.4),pre=0.0001,
	varfn=mu,pvar=c(0.05,0.3,-1,1))
print(z1 <- elliptic(reps,model=mu,preg=c(2.3,0.05,1,1.4),pre=0.0001,
	varfn=lvar,pvar=c(0.00008,0.003,-5.6,0.8)))
elliptic(reps,model=mu,preg=c(2.35,0.06,1,1.43),pre=0.0007,
	varfn=lvar2,shfn=T,pvar=c(-6.4,1.4),stepmax=1)

if(interactive()){
postscript("elisa.eps",height=5,width=5)
par(mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(conc[seq(2,16,by=2)],z1$pred[covind(reps)==1][seq(2,16,by=2)],
	type="l",xlab="DNase concentration",ylab="Optical density",ylim=c(0,2))
points(conc[1:16],response(reps,nind=1))
points(conc[1:16],response(reps,nind=2),pch=2)
points(conc[1:16],response(reps,nind=3),pch=0)
dev.off()

mup1 <- ~j+(b1-j)/(1+exp(b3*(lconc-i)))
lvarp <- ~log(exp(b0)+exp(b1)/(1+exp(b3*(lconc-b2))))
xx <- seq(1.47,1.75,by=0.02)
yy <- seq(2.4,2.72,by=0.01)
z <- like <- NULL
for(j in yy){
	z$coef <- c(0.02,0.92,-9.2,-4.9,-2.87,1.6)
	z$tausq <- 0.00057
		for(i in xx){
		reps <- rmna(y,tvc=lconc,ccov=tcctomat(data.frame(i=rep(i,11),
			j=rep(j,11))))
		like <- c(like,(z <- elliptic(reps,model=mup1,preg=z$coef[1:2],
			pre=z$tausq,varfn=lvarp,pvar=z$coef[3:6],stepmax=1,
			iter=100))$maxlike)
		print(c(i,j,like[length(like)],z$code,z$iter))}}
like <- matrix(like,nrow=length(xx))
dimnames(like) <- list(xx,yy)

postscript("dnasecon.eps",height=5)
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
contour(xx,yy,exp(-like+min(like)),levels=seq(0.1,0.9,by=0.1),labcex=0.6)
title(xlab=expression(beta[2]),ylab=expression(mu[infinity]))
par(mar=c(0,1,0,0))
persp(xx,yy,exp(-like+min(like)),phi=25,theta=-45,r=20,
	xlab="B2",ylab="u",zlab="",tick="detail",cex=0.7)
dev.off()
}

elliptic(reps,model=mu,preg=c(2.28,0.05,1.03,1.37),varfn=lvar,
	pvar=c(0.00001,0.0005,-1.43,3.36),iter=200,pell=0.52,
	dist="power exp",stepmax=0.1)
elliptic(reps,model=mu,preg=c(2.28,0.05,1.03,1.37),varfn=lvar,pre=0.0001,
	pvar=c(0.00001,0.0005,-1.43,3.36),iter=200,pell=0.52,
	dist="power exp",stepmax=0.1)

elliptic(reps,model=mu,preg=c(2.3,0.05,1,1.4),trans="log",link="exp")
elliptic(reps,model=mu,preg=c(2.3,0.05,1,1.4),trans="log",link="exp",
	pre=0.0001)

elliptic(reps,model=mu,preg=c(2.3,0.05,1,1.4),trans="log",link="exp",
	varfn=mu,pvar=c(-0.48,-6.2,-3,-5))
elliptic(reps,model=mu,preg=c(2.3,0.05,1,1.4),trans="log",link="exp",
	varfn=lvar,pvar=c(0.0016,0.63,1.45,-3))
elliptic(reps,model=mu,preg=c(1.25,0.06,1,1.1),trans="log",link="exp",
	varfn=lvar2,shfn=T,pvar=c(-2.9,0))
elliptic(reps,model=mu,preg=c(2.3,0.05,1,1.4),trans="log",link="exp",
	pre=0.001,varfn=mu,pvar=c(0.05,0.3,-1,1))
elliptic(reps,model=mu,preg=c(2.33,0.04,1,1.4),trans="log",link="exp",
	pre=0.0011,varfn=lvar,pvar=c(0.00067,0.39,1.72,-3.2))
elliptic(reps,model=mu,preg=c(1.64,0.043,0.96,1.26),trans="log",link="exp",
	pre=0.00001,varfn=lvar2,shfn=T,pvar=c(-2.9,0))
