library(gnlm)

data <- read.table("ames.dat",skip=4,header=T)
attach(data)

# air particles
air <- c(Ct1a,Ct1b)
airdose <- c(Dose1,Dose1)

gnlr(air,dist="Poisson",mu=~(b0+b1*airdose)*exp(-b2*airdose^theta),
	pmu=c(200,100,0,2))
gnlr(air,dist="Poisson",mu=~(b0+b1*airdose)*(2-exp(-b2*airdose^theta)),
	pmu=c(200,70,0,2))
print(z1a <- gnlr(air,dist="Poisson",mu=~b0+b1*airdose,pmu=c(200,100)))
gnlr(air,dist="negative bin",mu=~(b0+b1*airdose)*exp(-b2*airdose^theta),
	pmu=c(200,100,0,2),psh=6)
gnlr(air,dist="negative bin",mu=~(b0+b1*airdose)*(2-exp(-b2*airdose^theta)),
	pmu=c(200,70,0,2),psh=6)
gnlr(air,dist="negative bin",mu=~b0+b1*airdose,pmu=c(200,70),psh=6)
gnlr(air,dist="Consul",mu=~(b0+b1*airdose)*exp(-b2*airdose^theta),
	pmu=c(200,100,0,2),psh=6)
gnlr(air,dist="Consul",mu=~(b0+b1*airdose)*(2-exp(-b2*airdose^theta)),
	pmu=c(200,70,0,2),psh=6)
gnlr(air,dist="Consul",mu=~b0+b1*airdose,pmu=c(200,70),psh=6)

gnlr(air,dist="Poisson",mu=~(b0+b1*airdose)*exp(-b2*airdose),pmu=c(200,100,0))
print(z1b <- gnlr(air,dist="Poisson",mu=~b0*exp(-b2*airdose),pmu=c(200,0)))

if(interactive()){
postscript("Ames.eps")
par(mfrow=c(2,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
dose <- seq(0,2,by=0.02)
plot(dose,finterp(~b0*exp(-b2*dose))(z1b$coef),
	type="l",ylim=c(0,500),xlab="Dose (mg)",ylab="Revertants/plate")
lines(dose,finterp(~b0+b1*dose)(z1a$coef),lty=2)
points(Dose1,Ct1a,pch=20)
points(Dose1,Ct1b,pch=20)
title("Air particles")
}

# diesel particles
diesel <- c(Ct2a,Ct2b)
dieseldose <- c(Dose2,Dose2)

gnlr(diesel,dist="Poisson",pmu=c(50,4500,6,2),
	mu=~(b0+b1*dieseldose)*exp(-b2*dieseldose^theta))
gnlr(diesel,dist="Poisson",pmu=c(50,3500,2,2),
	mu=~(b0+b1*dieseldose)*(2-exp(-b2*dieseldose^theta)))
print(z2a <- gnlr(diesel,dist="negative bin",pmu=c(50,4500,6,2),psh=1.5,
	mu=~(b0+b1*dieseldose)*exp(-b2*dieseldose^theta)))
gnlr(diesel,dist="negative bin",pmu=c(50,4500,6),psh=1.5,
	mu=~(b0+b1*dieseldose)*exp(-b2*dieseldose^2))
print(z2b <- gnlr(diesel,dist="negative bin",pmu=c(50,3500,2,2),psh=6,
	mu=~(b0+b1*dieseldose)*(2-exp(-b2*dieseldose^theta))))
gnlr(diesel,dist="Consul",pmu=c(50,4500,6,2),psh=1,
	mu=~(b0+b1*dieseldose)*exp(-b2*dieseldose^theta))
gnlr(diesel,dist="Consul",pmu=c(50,3500,2,2),psh=1,
	mu=~(b0+b1*dieseldose)*(2-exp(-b2*dieseldose^theta)))

if(interactive()){
dose <- seq(0,0.5,by=0.01)
plot(dose,finterp(~(b0+b1*dose)*exp(-b2*dose^theta))(z2a$coef),
	type="l",ylim=c(0,1000),xlab="Dose (mg)",ylab="")
lines(dose,finterp(~(b0+b1*dose)*(2-exp(-b2*dose^theta)))(z2b$coef),lty=2)
points(Dose2,Ct2a,pch=20)
points(Dose2,Ct2b,pch=20)
title("Diesel particles")
}

# 1-Nitropyrene
nitro <- c(Ct3a,Ct3b)
nitrodose <- c(Dose3,Dose3)

gnlr(nitro,dist="Poisson",pmu=c(150,300,0,2),
	mu=~(b0+b1*nitrodose)*exp(-b2*nitrodose^theta))
gnlr(nitro,dist="Poisson",pmu=c(150,200,0,2),
	mu=~(b0+b1*nitrodose)*(2-exp(-b2*nitrodose^theta)))
print(z3a <- gnlr(nitro,dist="negative bin",pmu=c(150,250,0,2),psh=1.5,
	mu=~(b0+b1*nitrodose)*exp(-b2*nitrodose^theta)))
gnlr(nitro,dist="negative bin",pmu=c(150,250,0),psh=1.5,
	mu=~(b0+b1*nitrodose)*exp(-b2*nitrodose^2))
print(z3b <- gnlr(nitro,dist="negative bin",pmu=c(150,200,0,2),psh=6,
	mu=~(b0+b1*nitrodose)*(2-exp(-b2*nitrodose^theta))))
gnlr(nitro,dist="Consul",pmu=c(150,300,0,2),psh=1,
	mu=~(b0+b1*nitrodose)*exp(-b2*nitrodose^theta))
gnlr(nitro,dist="Consul",pmu=c(150,200,0,2),psh=1,
	mu=~(b0+b1*nitrodose)*(2-exp(-b2*nitrodose^theta)))

if(interactive()){
dose <- seq(0,6,by=0.1)
plot(dose,finterp(~(b0+b1*dose)*exp(-b2*dose^theta))(z3a$coef),
	type="l",ylim=c(0,800),xlab=expression("Dose ("*mu*"g)"),
	ylab="Revertants/plate")
lines(dose,finterp(~(b0+b1*dose)*(2-exp(-b2*dose^theta)))(z3b$coef),lty=2)
points(Dose3,Ct3a,pch=20)
points(Dose3,Ct3b,pch=20)
title("1-Nitropyrene")
}

# 1-Nitropyrene
nitro <- c(Ct4a,Ct4b)
nitrodose <- c(Dose4,Dose4)

gnlr(nitro,dist="Poisson",pmu=c(150,300,0,2),
	mu=~(b0+b1*nitrodose)*exp(-b2*nitrodose^theta))
gnlr(nitro,dist="Poisson",pmu=c(150,200,0,2),
	mu=~(b0+b1*nitrodose)*(2-exp(-b2*nitrodose^theta)))
print(z4a <- gnlr(nitro,dist="negative bin",pmu=c(150,250,0,2),psh=1.5,
	mu=~(b0+b1*nitrodose)*exp(-b2*nitrodose^theta)))
gnlr(nitro,dist="negative bin",pmu=c(150,250,0),psh=1.5,
	mu=~(b0+b1*nitrodose)*exp(-b2*nitrodose^2))
print(z4b <- gnlr(nitro,dist="negative bin",pmu=c(150,200,0,2),psh=6,
	mu=~(b0+b1*nitrodose)*(2-exp(-b2*nitrodose^theta))))
gnlr(nitro,dist="Consul",pmu=c(150,300,0,2),psh=1,
	mu=~(b0+b1*nitrodose)*exp(-b2*nitrodose^theta))
gnlr(nitro,dist="Consul",pmu=c(150,200,0,2),psh=1,
	mu=~(b0+b1*nitrodose)*(2-exp(-b2*nitrodose^theta)))

if(interactive()){
dose <- seq(0,6,by=0.1)
plot(dose,finterp(~(b0+b1*dose)*exp(-b2*dose^theta))(z4a$coef),
	type="l",ylim=c(0,800),xlab=expression("Dose ("*mu*"g)"),ylab="")
lines(dose,finterp(~(b0+b1*dose)*(2-exp(-b2*dose^theta)))(z4b$coef),lty=2)
points(Dose4,Ct4a,pch=20)
points(Dose4,Ct4b,pch=20)
title("1-Nitropyrene")
dev.off()
}
