library(growth)

substrate <- scan("acidphos.dat",skip=5,nlines=1)
data <- read.table("acidphos.dat",skip=6)
day <- as.factor(c(rep(1,8),rep(2,9),rep(3,11),rep(4,10),rep(5,10)))
y <- restovec(data,delta=0.001)
tvc <- tvctomat(matrix(rep(substrate,48),nrow=48,byrow=T),name="substrate")
reps <- rmna(y,ccov=tcctomat(day,dataframe=F),tvc=tvc)

mu <- ~Vmax*substrate/(Km+substrate)
elliptic(reps,model=mu,preg=c(0.24,0.07))
elliptic(reps,model=mu,preg=c(0.24,0.07),pre=0.0001)
elliptic(reps,model=mu,preg=c(0.24,0.07),trans="log",link="exp")
elliptic(reps,model=mu,preg=c(0.24,0.07),pell=1,dist="power exp")
elliptic(reps,model=mu,preg=c(0.24,0.07),pell=10,dist="Student")

mu2 <- ~Vmax*substrate/(Km+k2*day2+k3*day3+k4*day4+k5*day5+substrate)
elliptic(reps,model=mu2,preg=c(0.24,0.07,0,0,0,0))
elliptic(reps,model=mu2,preg=c(0.24,0.07,0,0,0,0),pre=0.0001)

mu3 <- ~(Vmax+v2*day2+v3*day3+v4*day4+v5*day5)*substrate/(Km+substrate)
elliptic(reps,model=mu3,preg=c(0.24,0,0,0,0,0.07))
elliptic(reps,model=mu3,preg=c(0.24,0,0,0,0,0.07),pre=0.0001)

mu4 <- ~(Vmax+v2*day2+v3*day3+v4*day4+v5*day5)*substrate/
	(Km+k2*day2+k3*day3+k4*day4+k5*day5+substrate)
elliptic(reps,model=mu4,preg=c(0.24,0,0,0,0,0.07,0,0,0,0))
elliptic(reps,model=mu4,preg=c(0.24,0,0,0,0,0.07,0,0,0,0),pre=0.0001)
elliptic(reps,model=mu4,preg=c(0.24,0,0,0,0,0.07,0,0,0,0),
	trans="log",link="exp")
elliptic(reps,model=mu4,preg=c(0.24,0,0,0,0,0.07,0,0,0,0),pell=1,
	dist="power exp")
elliptic(reps,model=mu4,preg=c(0.24,0,0,0,0,0.07,0,0,0,0),pell=10,
	dist="Student")

mu4a <- ~(Vmax+v25*(day2+day3+day4+day5))*substrate/
	(Km+k2*day2+k3*day3+k4*day4+k5*day5+substrate)
elliptic(reps,model=mu4a,preg=c(0.24,0,0.07,0,0,0,0))

mu4b <- ~(Vmax+v2*day2+v3*day3+v4*day4+v5*day5)*substrate/
	(Km+k25*(day2+day3+day4+day5)+substrate)
elliptic(reps,model=mu4b,preg=c(0.24,0,0,0,0,0.07,0))

shape <- ~Vmax+log(substrate/(Km+substrate))
elliptic(reps,model=mu,preg=c(0.24,0.07),varfn=shape,pvar=c(-8,0.09))
elliptic(reps,model=mu,preg=c(0.24,0.07),pre=0.00002,
	varfn=shape,pvar=c(-8,0.13),stepmax=0.5)
elliptic(reps,model=mu,preg=c(0.24,0.07),trans="log",link="exp",
	varfn=shape,pvar=c(-5,-0.02),stepmax=0.5)
elliptic(reps,model=mu,preg=c(0.24,0.07),pell=1,dist="power exp",
	varfn=shape,pvar=c(-8,0.09))
elliptic(reps,model=mu,preg=c(0.24,0.07),pell=10,dist="Student",
	varfn=shape,pvar=c(-8,0.09))
elliptic(reps,model=mu,preg=c(0.24,0.07),pell=7,dist="Student",
	pre=0.00002,varfn=shape,pvar=c(-8,0.09))
elliptic(reps,model=mu2,preg=c(0.22,0.06,0,0,0,0),
	varfn=shape,pvar=c(-8.4,0.11))
elliptic(reps,model=mu2,preg=c(0.22,0.06,0,0,0,0),
	pre=0.00001,varfn=shape,pvar=c(-8.4,0.11))
elliptic(reps,model=mu2,preg=c(0.22,0.06,0,0,0,0),pell=9,
	dist="Student",varfn=shape,pvar=c(-8.4,0.11))
elliptic(reps,model=mu2,preg=c(0.22,0.06,0,0,0,0),pell=9,
	pre=0.00001,dist="Student",varfn=shape,pvar=c(-8.4,0.11))
elliptic(reps,model=mu3,preg=c(0.22,0,0,0,0,0.06),
	varfn=shape,pvar=c(-8.4,0.11))
elliptic(reps,model=mu3,preg=c(0.22,0,0,0,0,0.06),
	pre=0.00001,varfn=shape,pvar=c(-8.4,0.11))
elliptic(reps,model=mu3,preg=c(0.22,0,0,0,0,0.06),pell=9,
	dist="Student",varfn=shape,pvar=c(-8.4,0.11))
elliptic(reps,model=mu3,preg=c(0.22,0,0,0,0,0.06),pell=9,
	pre=0.00001,dist="Student",varfn=shape,pvar=c(-8.4,0.11))
elliptic(reps,model=mu4,preg=c(0.22,0,0,0,0,0.06,0,0,0,0),
	varfn=shape,pvar=c(-8.4,0.11))
elliptic(reps,model=mu4,preg=c(0.22,0,0,0,0,0.06,0,0,0,0),
	pre=0.00001,varfn=shape,pvar=c(-8.4,0.11))
elliptic(reps,model=mu4,preg=c(0.22,0,0,0,0,0.06,0,0,0,0),pell=9,
	dist="Student",varfn=shape,pvar=c(-8.4,0.11))
elliptic(reps,model=mu4,preg=c(0.22,0,0,0,0,0.06,0,0,0,0),pell=9,
	pre=0.00001,dist="Student",varfn=shape,pvar=c(-8.4,0.11))

shape2 <- ~Vmax+log(substrate/(Km+k2*day2+k3*day3+k4*day4+k5*day5+substrate))
print(zn1 <- elliptic(reps,model=mu4,preg=c(0.22,0,0,0,0,0.06,0,0,0,0),
	varfn=shape2,pvar=c(-8.4,0.19,0,0,0,0),stepmax=0.5,iter=200))
elliptic(reps,model=mu,preg=c(0.24,0.07),pell=9,dist="Student",
	varfn=shape2,pvar=c(-8.4,0.19,0,0,0,0),stepmax=0.5)
print(zel1 <- elliptic(reps,model=mu4,preg=c(0.22,0,0,0,0,0.06,0,0,0,0),pell=6,
	dist="Student",varfn=shape2,pvar=c(-8.4,0.19,0,0,0,0),stepmax=0.5,
	iter=200))
elliptic(reps,model=mu4,preg=c(0.22,0,0,0,0,0.06,0,0,0,0),pell=6,pre=0.00001,
	dist="Student",varfn=shape2,pvar=c(-8.4,0.19,0,0,0,0),stepmax=0.1)

shape3 <- ~Vmax+v2*day2+v3*day3+v4*day4+v5*day5+log(substrate/(Km+substrate))
print(zn2 <- elliptic(reps,model=mu4,preg=c(0.22,0,0,0,0,0.057,0,0,0,0),
	varfn=shape3,pvar=c(-8.3,0,0,0,0,0.12),stepmax=0.5,iter=200))
elliptic(reps,model=mu,preg=c(0.24,0.07),pell=7,dist="Student",
	varfn=shape3,pvar=c(-8.4,0,0,0,0,0.064),stepmax=0.1)
print(zel2 <- elliptic(reps,model=mu4,preg=c(0.22,0,0,0,0,0.057,0,0,0,0),
	pell=17.5,dist="Student",varfn=shape3,
	pvar=c(-8.3,0,0,0,0,0.12),stepmax=0.5,iter=200))

shape4 <- ~Vmax+v2*day2+v3*day3+v4*day4+v5*day5+log(substrate/
	(Km+k2*day2+k3*day3+k4*day4+k5*day5+substrate))
print(zn3 <- elliptic(reps,model=mu4,preg=c(0.22,0,0,0,0,0.057,0,0,0,0),
	varfn=shape4,pvar=c(-8.3,0,0,0,0,0.12,0,0,0,0),stepmax=0.5,iter=200))
elliptic(reps,model=mu,preg=c(0.24,0.07),pell=7,dist="Student",
	varfn=shape4,pvar=c(-8.4,0,0,0,0,0.064,0,0,0,0),stepmax=0.1)
print(zel3 <- elliptic(reps,model=mu4,preg=c(0.22,0,0,0,0,0.057,0,0,0,0),
	pell=20,dist="Student",varfn=shape4,
	pvar=c(-8.3,0,0,0,0,0.12,0,0,0,0),stepmax=0.5,iter=200))

mu4c <- ~(Vmax+v2*day2+v34*(day3+day4)+v5*day5)*substrate/
	(Km+k2*day2+k45*(day4+day5)+substrate)
shape4c <- ~Vmax+v2*day2+v3*day3+v5*day5+log(substrate/
	(Km+k235*(day2+day3+day5)+k4*day4+substrate))
print(zn3c <- elliptic(reps,model=mu4c,preg=c(0.22,0,0,0,0.057,0,0),
	varfn=shape4c,pvar=c(-8.3,0,0,0,0.12,0,0),stepmax=0.5,iter=200))

if(interactive()){
postscript("acidphos.eps",height=7)
par(mfrow=c(2,3),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(substrate,zn3c$pred[covind(reps)==1],xlim=c(0,0.5),ylim=c(0,0.25),
	xlab="",ylab="Absorbance",main="Day 1",type="l")
for(i in 1:8)points(substrate,response(reps)[covind(reps)==i],pch=20)
plot(substrate,zn3c$pred[covind(reps)==9],xlim=c(0,0.5),ylim=c(0,0.25),
	xlab="",ylab="",type="l",main="Day 2",lty=2)
for(i in 9:17)points(substrate,response(reps)[covind(reps)==i],pch=20)
plot(substrate,zn3c$pred[covind(reps)==18],xlim=c(0,0.5),ylim=c(0,0.25),
	xlab="",ylab="",type="l",main="Day 3",lty=3)
for(i in 18:28)points(substrate,response(reps)[covind(reps)==i],pch=20)
plot(substrate,zn3c$pred[covind(reps)==29],xlim=c(0,0.5),ylim=c(0,0.25),
	xlab="Concentration",ylab="Absorbance",main="Day 4",type="l",lty=4)
for(i in 29:38)points(substrate,response(reps)[covind(reps)==i],pch=20)
plot(substrate,zn3c$pred[covind(reps)==39],xlim=c(0,0.5),ylim=c(0,0.25),
	xlab="Concentration",ylab="",main="Day 5",type="l",lty=5)
for(i in 39:48)points(substrate,response(reps)[covind(reps)==i],pch=20)
plot(substrate,zn3c$pred[covind(reps)==1],xlim=c(0,0.5),ylim=c(0,0.25),
	xlab="Concentration",ylab="",main="All Days",type="l")
lines(substrate,zn3c$pred[covind(reps)==9],lty=2)
lines(substrate,zn3c$pred[covind(reps)==18],lty=3)
lines(substrate,zn3c$pred[covind(reps)==29],lty=4)
lines(substrate,zn3c$pred[covind(reps)==39],lty=5)
legend(0.3,0.15,legend=c("Day 1","Day 2","Day 3","Day 4","Day 5"),
	lty=1:5,bty="n")
dev.off()

mu4cp <- ~(j+v2*day2+v34*(day3+day4)+v5*day5)*substrate/
	(i+k2*day2+k45*(day4+day5)+substrate)
# switch days around in variance function to avoid negative value,
# because days 2, 3, and 5 are smallest
shape4cp <- ~Vmax+v2*day2+v3*day3+v5*day5+log(substrate/
	(exp(Km)+exp(k235)*(1-day2-day3-day4-day5)+exp(k4)*day4+substrate))
xx <- seq(0.054,0.067,by=0.001)
yy <- seq(0.207,0.231,by=0.002)
z <- like <- NULL
for(j in yy){
	z$coef <- c(0.045,0.022,0.008,0.025,0.0075,-7.2,-2.6,-2,-1.15,
		-4,-0.7,-0.5)
	for(i in xx){
		reps <- rmna(y,ccov=tcctomat(data.frame(day,i=rep(i,48),
			j=rep(j,48)),dataframe=F),tvc=tvc)
		like <- c(like,(z <- elliptic(reps,model=mu4cp,
			preg=z$coef[1:5],varfn=shape4cp,pvar=z$coef[6:12],
			stepmax=0.5,iter=20))$maxlike)
		print(c(i,j,like[length(like)],z$code,z$iter))}}
like <- matrix(like,nrow=length(xx))
dimnames(like) <- list(xx,yy)

postscript("acidphc.eps",height=5)
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
contour(xx,yy,exp(-like+min(like)),levels=seq(0.1,0.9,by=0.1),labcex=0.6)
title(xlab=expression(K[m]),ylab=expression(V[max]))
par(mar=c(0,1,0,0))
persp(xx,yy,exp(-like+min(like)),phi=25,theta=-25,r=20,
	xlab="Km",ylab="Vmax",zlab="",tick="detail",cex=0.7)
dev.off()
}

mul <- ~b0+(b1-b0)/(1+exp(b3*(log(substrate)-b2)))
lvar <- ~log(b0+(b1-b0)/(1+exp(b3*(log(substrate)-b2))))
elliptic(reps,model=mul,preg=c(0.25,0,1,-2.8),
	varfn=lvar,pvar=c(0.00008,0.0018,-1.5,0.21))
lvar2 <- ~log(b0+(b1-b0)/(1+exp(b3*(log(substrate)))))
elliptic(reps,model=mul,preg=c(0.25,0,1,-2.8),iter=200,
	varfn=lvar2,pvar=c(0.00008,0.0018,-1.5))
elliptic(reps,model=mul,preg=c(-0.09,0.26,-0.68,-3.3),pell=9.5,
	dist="Student",varfn=lvar2,pvar=c(0.000067,0.001,-1.5))
elliptic(reps,model=mul,preg=c(0.25,0,1,-2.8),pell=9.5,
	dist="Student",varfn=lvar2,pvar=c(0.000067,0.001,-1.5))
