library(gnlm)
library(repeated)
library(growth)

data <- read.table("pH.dat",skip=5,header=T)
data$Period <- as.factor(data$Period)
resp <- restovec(data[,3:9],name="y",times=c(0.01,2,4,6,8,10,12))
tcc <- tcctomat(data[,1:2])
reps <- rmna(resp,ccov=tcc)
reps <- transform(reps,ly=log(y))

mu <- function(p){
	ka <- exp(p[2])
	ke <- exp(p[3])
	1+exp(p[2]-p[1])*Dose/(ka-ke)*(exp(-ke*times)-exp(-ka*times))}
gnlr(y,dist="normal",mu=mu,pmu=c(2.6,1,-0.4),psh=0.01,env=reps)
lsh <- function(p){
	ka <- exp(p[2])
	ke <- exp(p[3])
	p[4]*(p[2]-p[1]+log((Dose+0.001)/(ka-ke)*(exp(-ke*times)-
		exp(-ka*times))))}
gnlr(y,dist="normal",mu=mu,pmu=c(2.6,-1.51,-1.5),shape=lsh,
	psh=c(-1.1,-0.2,-0.21,0.12),env=reps)
mu2 <- function(p){
	ka <- exp(p[2])
	1+ka*Dose*times*exp(-ka*times-p[1])}
lsh2 <- function(p){
	ka <- exp(p[2])
	p[3]*(log(ka*(Dose+0.001)*times)-ka*times-p[1])}
gnlr(y,dist="normal",mu=mu2,pmu=c(2.6,-1.4),shape=lsh2,
	psh=c(-1.1,-0.2,0.12),env=reps)
mu3a <- function(p){
	ka <- exp(p[2]*(Dose==0)+p[3]*(Dose==10)+p[4]*(Dose==20)+
		p[5]*(Dose==40)+p[6]*(Dose==80)+p[7]*(Dose==160))
	1+ka*times*exp(-ka*times-p[1])}
gnlr(y,dist="normal",mu=mu3a,pmu=c(2.6,rep(-1.4,6)),
	shape=lsh2,psh=c(-1.1,-0.2,0.12),env=reps)
gnlr(y,dist="gamma",mu=mu3a,pmu=c(2.6,rep(-1.4,6)),psh=1.7,env=reps)
gnlr(y,dist="gamma",mu=mu3a,pmu=c(2.6,rep(-1.4,6)),
	shape=lsh2,psh=c(3,-0.2,-0.12),env=reps)
gnlr(y,dist="Weibull",mu=mu3a,pmu=c(2.6,rep(-1.4,6)),psh=0.7,env=reps)
gnlr(y,dist="Weibull",mu=mu3a,pmu=c(-2,rep(-1.4,6)),
	shape=lsh2,psh=c(-3,-0.2,0.12),env=reps)
lmu3a <- function(p){
	ka <- exp(p[2]*(Dose==0)+p[3]*(Dose==10)+p[4]*(Dose==20)+
		p[5]*(Dose==40)+p[6]*(Dose==80)+p[7]*(Dose==160))
	log(1+ka*times*exp(-ka*times-p[1]))}
gnlr(ly,dist="normal",mu=lmu3a,pmu=c(2.6,rep(-1.4,6)),
	shape=lsh2,psh=c(-1.1,-0.2,0.12),env=reps)
gnlr(ly,dist="normal",mu=lmu3a,pmu=c(2.6,rep(-1.4,6)),psh=-1.1,env=reps)
gnlr(ly,dist="Cauchy",mu=lmu3a,pmu=c(2.6,rep(-1.4,6)),
	shape=lsh2,psh=c(-1.1,-0.2,0.12),env=reps)
gnlr(ly,dist="Laplace",mu=lmu3a,pmu=c(2.6,rep(-1.4,6)),
	shape=lsh2,psh=c(-1.1,-0.2,0.12),env=reps)
gnlr(ly,dist="Laplace",mu=lmu3a,pmu=c(-2,rep(-1.4,6)),
	shape=lsh2,psh=c(10,0.27,0.04),env=reps)

sh2 <- function(p){
	ka <- exp(p[2])
	(ka*(Dose+0.001)*times*exp(-ka*times-p[1]))^p[3]}
elliptic(ly,model=lmu3a,preg=c(2.6,rep(-1.4,6)),env=reps)
elliptic(ly,model=lmu3a,preg=c(2.6,rep(-1.4,6)),varfn=lsh2,
	pvar=c(-1.1,-0.2,0.12),env=reps)
elliptic(ly,model=lmu3a,preg=c(2.6,rep(-1.4,6)),varfn=lsh2,
	pvar=c(-1.1,-0.2,0.12),dist="power exp",pell=1,env=reps)
elliptic(ly,model=lmu3a,preg=c(-1.4,rep(-1.4,6)),varfn=lsh2,
	pvar=c(25,1,0.04),par=0.5,env=reps)
elliptic(ly,model=lmu3a,preg=c(-1.4,rep(-1.4,6)),varfn=lsh2,
	pvar=c(25,1,0.04),par=0.5,dist="power exp",pell=1,env=reps)
elliptic(ly,model=lmu3a,preg=c(-1.4,rep(-1.4,6)),varfn=lsh2,
	pvar=c(25,1,0.04),pre=0.5,env=reps)
elliptic(ly,model=lmu3a,preg=c(-1.4,rep(-1.4,6)),varfn=lsh2,
	pvar=c(25,1,0.04),par=0.8,pre=0.5,env=reps)
elliptic(ly,model=lmu3a,preg=c(-1.4,rep(-1.4,6)),par=0.8,pre=0.5,env=reps)
elliptic(ly,model=lmu3a,preg=c(-1.4,rep(-1.4,6)),par=0.8,env=reps)

data2 <- matrix(as.vector(t(as.matrix(data[,3:9]))),byrow=T,ncol=42)
resp2 <- restovec(data2,name="y",times=rep(c(0.01,2,4,6,8,10,12),6),
	nest=codes(gl(6,7,42)))
tvc2 <- tvctomat(matrix(rep(data[,1],rep(7,36)),ncol=42,nrow=6,byrow=T),
	name="Dose")
reps2 <- rmna(resp2,tvcov=tvc2)
reps2 <- transform(reps2,ly=log(y))
elliptic(y,model=lmu3a,preg=c(2.6,rep(-1.4,6)),trans="log",env=reps2)
elliptic(y,model=lmu3a,preg=c(-1.4,rep(-1.4,6)),varfn=lsh2,
	pvar=c(25,1,0.04),pre=0.5,trans="log",env=reps2)
elliptic(y,model=lmu3a,preg=c(0.75,rep(-1.4,6)),varfn=lsh2,
	pvar=c(25,0.65,0.03),pre=c(0.5,0.03),iter=200,trans="log",env=reps2)
elliptic(y,model=lmu3a,preg=c(0.75,rep(-1.4,6)),varfn=lsh2,
	pvar=c(25,0.65,0.03),par=0.01,pre=c(0.5,0.05),trans="log",env=reps2)
elliptic(y,model=lmu3a,preg=c(-1.85,0.85,1,-4.6,-1.1,-1.5,-1.4),varfn=lsh2,
	pvar=c(25,0.25,0.05),par=0.44,pre=c(0.054,0.001),trans="log",env=reps2)
elliptic(y,model=lmu3a,preg=c(-1.85,0.85,1,-4.6,-1.1,-1.5,-1.4),varfn=lsh2,
	pvar=c(25,0.25,0.05),par=0.44,pre=0.054,trans="log",env=reps2)
elliptic(y,model=lmu3a,preg=c(-1.85,0.85,1,-4.6,-1.1,-1.5,-1.4),
	par=0.44,pre=0.054,trans="log",env=reps2)
elliptic(y,model=mu3a,preg=c(-1.85,0.85,1,-4.6,-1.1,-1.5,-1.4),
	par=0.44,pre=0.054,env=reps2)
elliptic(y,model=mu3a,preg=c(-1.85,0.85,1,-4.6,-1.1,-1.5,-1.4),
	par=0.44,env=reps2)

elliptic(y,tvcov=~Dose,torder=2,par=0.44,pre=0.054,trans="log",env=reps2)
elliptic(y,tvcov=~Dose,torder=2,preg=c(0.7,0.008,-0.02,0.004),
	pvar=c(0.2,0.1),varfn="square",par=0.6,pre=0.1,trans="log",
	env=reps2)
print(zlns <- elliptic(y,tvcov=~as.factor(Dose)*as.factor(times),
	par=0.44,trans="log",pvar=0.05,env=reps2))


mu3b <- function(p){
	ka <- exp(p[7])
	ka*times*exp(-ka*times-p[1]*(Dose==0)-p[2]*(Dose==10)-
		p[3]*(Dose==20)-p[4]*(Dose==40)-p[5]*(Dose==80)-
		p[6]*(Dose==160))}
mu3c <- function(p){
	ka <- exp(p[7])
	exp(ka*times*exp(-ka*times-p[1]*(Dose==0)-p[2]*(Dose==10)-
		p[3]*(Dose==20)-p[4]*(Dose==40)-p[5]*(Dose==80)-
		p[6]*(Dose==160)))}
lmu3b <- function(p){
	ka <- exp(p[7])
	log(1+ka*times*exp(-ka*times-p[1]*(Dose==0)-p[2]*(Dose==10)-
		p[3]*(Dose==20)-p[4]*(Dose==40)-p[5]*(Dose==80)-
		p[6]*(Dose==160)))}
print(zln <- elliptic(y,model=lmu3b,preg=c(rep(-1.85,6),-1.4),par=0.44,
	pre=0.054,trans="log",env=reps2))
print(zlna <- elliptic(y,model=mu3b,preg=c(1,1,1,-1,-1,-1,-1.5),par=0.44,
	pre=0.054,trans="log",env=reps2))
print(zlna1 <- elliptic(y,model=mu3b,preg=c(1,1,1,-1,-1,-1,-1.5),par=0.44,
	trans="log",env=reps2))
elliptic(y,model=mu3b,preg=c(1,1,1,-1,-1,-1,-1.4),par=0.44,pre=0.054,
	varfn=lsh2,pvar=c(1,0.25,0.05),trans="log",env=reps2)
print(zlna3 <- elliptic(y,model=mu3b,preg=c(1,1,1,-1,-1,-1,-1.4),par=0.44,
	varfn=~times+I(times^2),pvar=c(-0.24,-0.66,0.04),trans="log",
	env=reps2))
print(zlna0 <- elliptic(y,model=mu3b,preg=c(1,1,1,-1,-1,-1,-1.4),
	varfn=~times+I(times^2),pvar=c(-0.24,-0.66,0.04),trans="log",
	env=reps2))
print(zna0 <- elliptic(y,model=mu3c,preg=c(1,1,1,-1,-1,-1,-1.4),
	varfn=~times+I(times^2),pvar=c(-0.24,-0.66,0.04),env=reps2))
elliptic(y,model=mu3b,preg=c(1,1,1,-1,-1,-1,-1.4),par=0.44,
	varfn=~times+I(times^2),pvar=c(-0.24,-0.66,0.04),trans="log",
	dist="power exp",pell=1,env=reps2)
elliptic(y,model=mu3b,preg=c(1,1,1,-1,-1,-1,-1.4),par=0.44,dist="Student",
	varfn=~times+I(times^2),pvar=c(-0.24,-0.66,0.04),trans="log",
	pell=1,env=reps2)

elliptic(y,model=mu3b,preg=c(1,1,1,-1,-1,-1,-1.4),
	varfn=~times+I(times^2),pvar=c(-0.24,-0.66,0.04),link="log",
	env=reps2)

lmu <- function(p){
	ka <- exp(p[2])
	ke <- exp(p[3])
	log(1+exp(p[2]-p[1])*Dose/(ka-ke)*(exp(-ke*times)-exp(-ka*times)))}
elliptic(y,model=lmu,preg=c(2.5,-1.5,-1.4),par=0.44,pre=0.054,
	trans="log",env=reps2)
lmu2 <- function(p){
	ka <- exp(p[2])
	log(1+ka*Dose*times*exp(-ka*times-p[1]))}
elliptic(y,model=lmu2,preg=c(2.5,-1.5),trans="log",env=reps2)
elliptic(y,model=lmu2,preg=c(2.5,-1.5),par=0.44,pre=0.054,
	trans="log",env=reps2)
elliptic(y,model=lmu2,preg=c(2.5,-1.5),par=0.44,pre=c(0.054,0.001),
	trans="log",env=reps2)

if(interactive()){
#postscript("pHprof.eps")
par(mfrow=c(1,1),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
times <- c(0.01,2,4,6,8,10,12)
Dose <- 0
plot(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),
	type="l",ylim=c(0,7),xlab="Hours",ylab="pH")
Dose <- 10
lines(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),lty=2)
Dose <- 20
lines(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),lty=3)
Dose <- 40
lines(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),lty=4)
Dose <- 80
lines(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),lty=5)
Dose <- 160
lines(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),lty=6)
lines(c(0,12),c(3,3))
legend(0,7,lty=1:6,legend=c("Dose 0","Dose 10","Dose 20","Dose 40","Dose 80",
	"Dose 160"),bty="n")
#dev.off()
}

print(zg <- gausscop(y,dist="gamma",mu=lmu3b,pmu=c(1,1,1,-1,-1,-1,-1.8),
	psh=0.74,par=0.07,pre=0.7,env=reps2))
print(zga <- gausscop(y,dist="gamma",mu=mu3b,pmu=c(1,1,1,-1,-1,-1,-1.8),
	psh=0.74,par=0.07,pre=0.7,env=reps2))
print(zga3 <- gausscop(y,dist="gamma",mu=mu3b,
	pmu=c(1,0.35,-0.3,-0.9,-1.3,-1.3,-1.6),shape=~times+I(times^2),
	psh=c(-0.1,0.14,-0.01),par=0.1,pre=0.1,env=reps2))
print(zga2 <- gausscop(y,dist="gamma",mu=mu3b,
	pmu=c(1,0.35,-0.3,-0.9,-1.3,-1.3,-1.6),shape=~times+I(times^2),
	psh=c(-0.1,0.14,-0.01),par=0.1,env=reps2))
print(zga0 <- gausscop(y,dist="gamma",mu=mu3b,
	pmu=c(1,0.35,-0.3,-0.9,-1.3,-1.3,-1.6),shape=~times+I(times^2),
	psh=c(-0.1,0.14,-0.01),env=reps2))
print(zw <- gausscop(y,dist="Weibull",mu=lmu3b,pmu=c(1.85,rep(-1.6,5),-1.4),
	psh=0.3,par=0.8,pre=0.14,env=reps2))
print(zwa <- gausscop(y,dist="Weibull",mu=mu3b,pmu=c(1.85,rep(-1.6,5),-1.4),
	psh=0.3,par=0.8,pre=0.14,env=reps2))
print(zwa3 <- gausscop(y,dist="Weibull",mu=mu3b,pmu=c(1.85,rep(-1.6,5),-1.4),
	shape=~times+I(times^2),psh=c(0.04,0.12,-0.007),par=0.21,pre=0.74,
	env=reps2))
print(zwa0 <- gausscop(y,dist="Weibull",mu=mu3b,pmu=c(1.85,rep(-1.6,5),-1.4),
	shape=~times+I(times^2),psh=c(0.04,0.12,-0.007),
	env=reps2))
print(zlc <- gausscop(ly,dist="Cauchy",mu=lmu3b,pmu=c(rep(-1,6),-1.4),
	psh=-0.8,par=0.01,pre=0.01,env=reps2))
print(zlca <- gausscop(ly,dist="Cauchy",mu=mu3b,pmu=c(rep(-1,6),-1.4),
	psh=-0.8,par=0.01,env=reps2))
print(zlca0 <- gausscop(ly,dist="Cauchy",mu=mu3b,shape=~times+I(times^2),
	psh=c(0.04,0.12,-0.007),
	pmu=c(0.32,-0.04,-0.6,-1,-1.5,-1.5,-1.5),env=reps2))
print(zll1 <- gausscop(ly,dist="Laplace",mu=lmu3b,
	pmu=c(0.2,-0.31,-1,-1.6,-2.3,-2.3,-1.4),
	psh=-0.6,par=0.013,env=reps2))
print(zll0 <- gausscop(ly,dist="Laplace",mu=lmu3b,
	pmu=c(0.2,-0.31,-0.96,-1.6,-2.3,-2.3,-1.44),psh=-0.62,env=reps2))
print(zlla00 <- gausscop(ly,dist="Laplace",mu=mu3b,
	pmu=c(0.32,-0.04,-0.6,-1,-1.5,-1.5,-1.5),psh=-1.35,env=reps2))
print(zlla0 <- gausscop(ly,dist="Laplace",mu=mu3b,
	shape=~times+I(times^2),psh=c(-0.94,-0.19,0.014),
	pmu=c(0.32,-0.04,-0.6,-1,-1.5,-1.5,-1.5),iter=200,env=reps2))
print(zllog1 <- gausscop(ly,dist="logistic",mu=lmu3b,pmu=c(rep(-1,6),-1.4),
	psh=-0.6,par=0.01,env=reps2))
print(zlloga3 <- gausscop(ly,dist="logistic",mu=mu3b,pmu=c(rep(-1,6),-1.4),
	shape=~times+I(times^2),psh=c(-0.1,0.14,-0.01),par=0.01,pre=0.01,
	env=reps2))
print(zlloga1 <- gausscop(ly,dist="logistic",mu=mu3b,pmu=c(rep(-1,6),-1.4),
	shape=~times+I(times^2),psh=c(-0.1,0.14,-0.01),par=0.01,env=reps2))
print(zlloga0 <- gausscop(ly,dist="logistic",mu=mu3b,pmu=c(rep(-1,6),-1.4),
	shape=~times+I(times^2),psh=c(-0.1,0.14,-0.01),env=reps2))
print(zig <- gausscop(y,dist="inverse Gauss",mu=lmu3b,pmu=c(rep(-1,6),-1.5),
	psh=-1.6,par=0.29,pre=0.5,env=reps2))
print(ziga <- gausscop(y,dist="inverse Gauss",mu=mu3b,pmu=c(rep(-1,6),-1.5),
	psh=-1.6,par=0.29,pre=0.5,env=reps2))
print(ziga3 <- gausscop(y,dist="inverse Gauss",mu=mu3b,pmu=c(rep(-1,6),-1.5),
	shape=~times+I(times^2),psh=c(-1.2,-0.33,0.02),par=0.31,pre=0.4,
	env=reps2))
print(ziga0 <- gausscop(y,dist="inverse Gauss",mu=mu3b,pmu=c(rep(-1,6),-1.5),
	shape=~times+I(times^2),psh=c(-1.2,-0.33,0.02),env=reps2))

if(interactive()){
postscript("pHind.eps")
par(mfrow=c(3,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
for(i in 1:6)plot(reps2,name="y",nind=i,nest=1:6,main=paste("Subject ",i),
	ylab=if(i==1||i==3||i==5)"pH" else "",xlab="Hours",ylim=c(0,7))
legend(0,7,lty=1:6,legend=c("Dose 0","Dose 10","Dose 20","Dose 40","Dose 80",
	"Dose 160"),bty="n")
dev.off()
postscript("pHprof.eps",height=5)
par(mfrow=c(1,3),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(mprofile(zlns),ylim=c(0,7),xlab="Hours",ylab="pH")
lines(c(0,12),c(3,3))
legend(0,7,lty=1:3,legend=c("Dose 0","Dose 10","Dose 20"),bty="n")
legend(6,7,lty=4:6,legend=c("Dose 40","Dose 80","Dose 160"),bty="n")
times <- c(0.01,2,4,6,8,10,12)
Dose <- 0
plot(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),
	type="l",ylim=c(0,7),xlab="Hours",ylab="")
Dose <- 10
lines(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),lty=2)
Dose <- 20
lines(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),lty=3)
Dose <- 40
lines(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),lty=4)
Dose <- 80
lines(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),lty=5)
Dose <- 160
lines(times,exp(mu3b(zlna0$coef)+
	exp(zlna0$coef[8]+zlna0$coef[9]*times+zlna0$coef[10]*times^2)/2),lty=6)
lines(c(0,12),c(3,3))
Dose <- 0
plot(times,exp(mu3b(zlloga0$coef)),type="l",ylim=c(0,7),xlab="Hours",ylab="")
Dose <- 10
lines(times,exp(mu3b(zlloga0$coef)),lty=2)
Dose <- 20
lines(times,exp(mu3b(zlloga0$coef)),lty=3)
Dose <- 40
lines(times,exp(mu3b(zlloga0$coef)),lty=4)
Dose <- 80
lines(times,exp(mu3b(zlloga0$coef)),lty=5)
Dose <- 160
lines(times,exp(mu3b(zlloga0$coef)),lty=6)
lines(c(0,12),c(3,3))
dev.off()
}
