library(repeated)

y <- read.table("cough.dat",header=T)
yy <- matrix(as.vector(t(as.matrix(y[,6:9])))[rep(c(seq(1,16,by=4),
	seq(2,16,by=4),seq(3,16,by=4),seq(4,16,by=4)),340)+
	rep(seq(0,5439,by=16),rep(16,340))],ncol=16,byrow=T)

id <- as.vector(tapply(as.matrix(y[,1]),gl(340,4),unique))
per <- as.vector(tapply(as.matrix(y[,3]),gl(340,4),unique))

design <- read.table("design.dat",header=T)
treat <- design[rep(1:170,rep(2,170)),4]

baseline <- as.vector(tapply(read.table("baseline.dat")[,3],gl(24,4),sum)[id])

covar <- read.table("covar.dat",head=T)
attach(covar)

resp <- restovec(yy[seq(2,340,by=2),])
dose <- tvctomat(matrix(rep(rep(c(1,3,10,30),170),rep(4,680)),ncol=16,byrow=T),
	name="dose")
ccov <- tcctomat(data.frame(treat=design[,4],id=id[seq(2,340,by=2)],
	per=as.factor(per[seq(2,340,by=2)]),sex=sex[id[seq(2,340,by=2)]],
	age=age[id[seq(2,340,by=2)]],height=height[id[seq(2,340,by=2)]],
	weight=weight[id[seq(2,340,by=2)]],pulse=pulse[id[seq(2,340,by=2)]],
	systolic=systolic[id[seq(2,340,by=2)]],
	diastolic=diastolic[id[seq(2,340,by=2)]]))
reps <- rmna(resp,ccov=ccov,tvcov=dose)
ccov1 <- tcctomat(data.frame(design[,4,drop=F],per=per[seq(2,340,by=2)],
	baseline=baseline[seq(2,340,by=2)],sex=sex[id[seq(2,340,by=2)]],
	age=age[id[seq(2,340,by=2)]],height=height[id[seq(2,340,by=2)]],
	weight=weight[id[seq(2,340,by=2)]],pulse=pulse[id[seq(2,340,by=2)]],
	systolic=systolic[id[seq(2,340,by=2)]],
	diastolic=diastolic[id[seq(2,340,by=2)]]),dataframe=F)
reps1 <- rmna(resp,ccov=ccov1,tvcov=dose)

print(ze2pbh2 <- kalcount(reps1,depend="serial",update="Markov",
	mu=~(1+a*dose)/(e+b*dose)*exp(f*per+g*baseline+j*height),
	ptvc=c(0.044,-0.66,2.07,0.089,-0.02,0.97),pinit=0.45,pdep=0.88))
print(ze2tpbh2 <- kalcount(reps1,depend="serial",update="Markov",
	mu=~(1+a*dose)/(e+b*dose)*exp(d*times+f*per+g*baseline+j*height),
	ptvc=c(0.044,-0.66,2.07,0.12,0.089,-0.02,0.97),pinit=0.45,pdep=0.88))
print(ze2ttpbh2 <- kalcount(reps1,depend="serial",update="Markov",
	mu=~(1+a*dose)/(e+b*dose)*
	exp(d*times+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tf*TREATMENTF+tg*TREATMENTG+f*per+g*baseline+j*height),
	ptvc=c(0.045,-0.57,1.83,0.12,-0.008,-0.033,-0.1,-0.13,-0.26,-0.055,
	0.09,-0.02,0.95),pinit=0.43,pdep=0.88))

print(zw2pbh2 <- kalcount(reps1,depend="serial",update="Markov",
	int="Weibull",mu=~(1+a*dose)/(e+b*dose)*exp(f*per+g*baseline+j*height),
	ptvc=c(0.044,-0.66,2.07,0.089,-0.02,0.97),
	pinit=0.45,psh=1.35,pdep=0.88))
print(zw2tpbh2 <- kalcount(reps1,depend="serial",update="Markov",
	int="Weibull",mu=~(1+a*dose)/(e+b*dose)*
	exp(d*times+f*per+g*baseline+j*height),
	ptvc=c(0.044,-0.66,2.07,0.12,0.089,-0.02,0.97),
	pinit=0.45,psh=1.35,pdep=0.88))
print(zw2ttpbh2 <- kalcount(reps1,depend="serial",update="Markov",
	int="Weibull",mu=~(1+a*dose)/(e+b*dose)*
	exp(d*times+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tf*TREATMENTF+tg*TREATMENTG+f*per+g*baseline+j*height),
	ptvc=c(0.045,-0.57,1.83,0.12,-0.008,-0.033,-0.1,-0.13,-0.26,-0.055,
	0.09,-0.02,0.95),pinit=0.43,psh=1.35,pdep=0.88))

print(zw2tpbh2k <- kalcount(reps1,depend="serial",update="kalman",
	int="Weibull",mu=~(1+a*dose)/(e+b*dose)*
	exp(d*times+f*per+g*baseline+j*height),
	ptvc=c(0.044,-0.66,2.07,0.12,0.089,-0.02,0.97),
	pinit=0.45,psh=1.35,pdep=0.88))

print(zl2tpbh2 <- kalcount(reps1,depend="serial",update="Markov",
	int="gen logistic",mu=~(1+a*dose)/(e+b*dose)*
	exp(d*times+f*per+g*baseline+j*height),
	ptvc=c(0.044,-0.66,2.07,0.12,0.089,-0.02,0.97),
	pinit=0.45,psh=1.35,pint=1.3,pdep=0.88))

print(zn2tpbh2 <- kalcount(reps1,depend="serial",update="Markov",
	int="log normal",mu=~(1+a*dose)/(e+b*dose)*
	exp(d*times+f*per+g*baseline+j*height),
	ptvc=c(-0.035,0.75,0.8,0.24,-0.0002,-0.0001,0.044),
	pinit=1.8,psh=0.15,pdep=0.74))

print(zc2tpbh2 <- kalcount(reps1,depend="serial",update="Markov",
	int="log Cauchy",mu=~(1+a*dose)/(e+b*dose)*
	exp(d*times+f*per+g*baseline+j*height),
	ptvc=c(0.027,0.66,0.027,0.0247,-0.0002,-0.0001,0.035),
	pinit=8.9,psh=0.019,pdep=0.85))

if(interactive()){
# comparison of treatments A and F, baseline is different for each subject
postscript("cough1b.eps")
#x11()
par(mfrow=c(2,2),font.main=1)
plot(mprofile(zw2ttpbh2),ylim=c(0,5),nind=c(99,100),lty=c(4,1),
	main="F period 1, A period 2",xlab="",ylab="Number of coughs")
plot(iprofile(zw2ttpbh2),add=T,obs=T,nind=c(99,100),lty=3:2)
plot(mprofile(zw2ttpbh2),ylim=c(0,5),nind=c(150,151),lty=c(1,4),
	main="A period 2, F period 3",xlab="",ylab="")
plot(iprofile(zw2ttpbh2),add=T,obs=T,nind=c(150,151),lty=2:3)
plot(mprofile(zw2ttpbh2),ylim=c(0,5),nind=c(41,42),lty=c(4,1),
	main="F period 6, A period 7",xlab="Minutes",ylab="Number of coughs")
plot(iprofile(zw2ttpbh2),add=T,obs=T,nind=c(41,42),lty=3:2)
plot(mprofile(zw2ttpbh2),ylim=c(0,5),nind=c(140,141),lty=c(1,4),
	main="A period 6, F period 7",xlab="Minutes",ylab="")
plot(iprofile(zw2ttpbh2),add=T,obs=T,nind=c(140,141),lty=2:3)
dev.off()
}
