library(repeated)

y <- read.table("cough.dat",header=T)
yy <- matrix(as.vector(t(as.matrix(y[,6:9])))[rep(c(seq(1,16,by=4),
	seq(2,16,by=4),seq(3,16,by=4),seq(4,16,by=4)),340)+
	rep(seq(0,5439,by=16),rep(16,340))],ncol=16,byrow=T)

id <- as.vector(tapply(as.matrix(y[,1]),gl(340,4),unique))
per <- as.vector(tapply(as.matrix(y[,3]),gl(340,4),unique))

design <- read.table("design.dat",header=T)
treat <- as.factor(ifelse(design[,4]=="F","0F",as.character(design[,4]))) 

baseline <- as.vector(tapply(read.table("baseline.dat")[,3],gl(24,4),sum)[id])

covar <- read.table("covar.dat",head=T)
attach(covar)

resp <- restovec(yy[seq(2,340,by=2),])
dose <- tvctomat(matrix(rep(rep(c(1,3,10,30),170),rep(4,680)),ncol=16,byrow=T),
	name="dose")
ccov1 <- tcctomat(data.frame(TREATMENT=treat,per=per[seq(2,340,by=2)],
	baseline=baseline[seq(2,340,by=2)],sex=sex[id[seq(2,340,by=2)]],
	age=age[id[seq(2,340,by=2)]],height=height[id[seq(2,340,by=2)]],
	weight=weight[id[seq(2,340,by=2)]],pulse=pulse[id[seq(2,340,by=2)]],
	systolic=systolic[id[seq(2,340,by=2)]],
	diastolic=diastolic[id[seq(2,340,by=2)]],
	allergen=allergen[id[seq(2,340,by=2)]],
	id=as.factor(id[seq(2,340,by=2)])),dataframe=F)
reps1 <- rmna(resp,ccov=ccov1,tvcov=dose)

# Note: because of a changed parametrization of the shape parameter for
# the negative binomial distribution in gar, the results are somewhat
# different than those in the book

print(zp2ttpbs <- gar(reps1,"Poisson",mu=~e+(a*dose)/(1+b*dose)+d*times+
	ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tg*TREATMENTG+f*per+g*baseline+h*sexM,
	preg=c(0.046,0.73,0.12,-0.1,-0.16,-0.29,-0.11,0.014,-0.017,-0.22,
	-0.074,0.022,-0.18),pdep=0.41))
print(zp2ttpbs2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*exp(d*times+
	ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tg*TREATMENTG+f*per+g*baseline+h*sexM),
	preg=c(-0.69,1,0.022,-0.11,-0.37,-0.32,-0.26,-0.18,-0.086,-0.2,-0.12,
	0.035,-0.18),pdep=0.44))
print(zp2ttpbs3 <- gar(reps1,"Poisson",mu=~a*dose/(1+b*dose)*exp(e+d*times+
	ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tg*TREATMENTG+f*per+g*baseline+h*sexM),
	preg=c(0.6,0.023,-0.1,-0.064,-0.39,-0.34,-0.3,-0.21,-0.12,-0.23,-0.12,
	0.035,-0.17),pdep=0.47))
print(zp2ttpid2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*exp(d*times+
	ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tg*TREATMENTG+f*per+i2*id2+i3*id3+i4*id4+i5*id5+i6*id6
	+i7*id7+i8*id8+i9*id9+i10*id10+i11*id11+i12*id12+i13*id13+i14*id14
	+i15*id15+i16*id16+i17*id17+i18*id18+i19*id19+i20*id20+i21*id21
	+i22*id22+i23*id23+i24*id24),
	preg=c(-1.1,1.59,0.02,-0.11,-0.21,-0.19,-0.11,0.01,-0.05,-0.16,-0.07,
	rep(0,23)),pdep=0.32))
print(zp2ttp2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*exp(d*times+
	ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tg*TREATMENTG+f*per),preg=c(-1.42,2,0.022,-0.11,-0.38,-0.28,-0.22,
	-0.14,-0.09,-0.2,-0.11),pdep=0.32))

print(znb2ttpbs <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)+
	d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+h*sexM,
	preg=c(0.025,0.73,0.12,-0.1,-0.18,-0.31,-0.14,-0.031,-0.021,-0.26,
	-0.073,0.023,-0.17),psh=0.5,pdep=0.2))
print(znb2ttpbs2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+h*sexM),
	preg=c(-0.66,0.97,0.02,-0.11,-0.19,-0.18,-0.09,0.02,-0.02,-0.14,-0.074,
	0.019,-0.065),psh=20,pdep=0.2))
print(znb2ttpbs3 <- gar(reps1,"negative binomial",mu=~a*dose/(1+b*dose)*
	exp(e+d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+h*sexM),
	preg=c(0.6,0.023,-0.1,-0.064,-0.39,-0.34,-0.3,-0.21,-0.12,-0.23,-0.12,
	0.035,-0.17),psh=11,pdep=0.47))
print(znb2ttpid2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+i2*id2+i3*id3+i4*id4+i5*id5+i6*id6
	+i7*id7+i8*id8+i9*id9+i10*id10+i11*id11+i12*id12+i13*id13+i14*id14
	+i15*id15+i16*id16+i17*id17+i18*id18+i19*id19+i20*id20+i21*id21
	+i22*id22+i23*id23+i24*id24),
	preg=c(-1.1,1.59,0.02,-0.11,-0.21,-0.19,-0.11,0.01,-0.05,-0.16,-0.07,
	rep(0,23)),psh=11,pdep=0.36))

print(z2ttpbsh2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+h*sexM+j*height),
	preg=c(-8.78,13.05,0.02,-0.11,-0.17,-0.18,-0.088,0.028,-0.0099,-0.14,
	-0.074,0.013,0.15,-1.53),pdep=0.45))
print(zp2ttpbh2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height),
	preg=c(-3.28,4.88,0.02,-0.11,-0.17,-0.18,-0.084,0.028,-0.01,-0.14,
	-0.074,0.016,-0.94),pdep=0.45))
print(zp2ttpbhw2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight),
	preg=c(-3.44,5.09,0.02,-0.11,-0.17,-0.17,-0.079,0.03,-0.018,-0.14,
	-0.076,0.013,-1.4,0.01),pdep=0.45))
print(zp2ttpbhws2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic),preg=c(-5.2,7.7,0.02,-0.11,-0.19,-0.19,-0.09,-0.0033,
	-0.029,-0.16,-0.075,0.0092,-1.37,0.015,-0.0059),pdep=0.43))
print(zp2ttpbhwsd2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height++k*weight+
	l*systolic+m*diastolic),preg=c(-4.8,7.11,0.02,-0.11,-0.18,-0.2,-0.09,
	-0.0016,-0.041,-0.17,-0.075,0.01,-1.29,0.014,-0.0037,-0.0037),
	pdep=0.43))
print(zp2ttpbhwd2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height++k*weight+
	m*diastolic),preg=c(-4.48,6.63,0.02,-0.11,-0.19,-0.19,-0.096,-0.0016,
	-0.038,-0.16,-0.075,0.012,-1.3,0.012,-0.0069),pdep=0.43))
print(zp2ttpbhwsp2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+n*pulse),preg=c(-4.25,6.28,0.02,-0.11,-0.19,-0.19,-0.097,
	-0.0027,-0.033,-0.16,-0.075,0.0092,-1.33,0.015,-0.006,0.0016),
	pdep=0.43,iter=200))
print(zp2ttpbhwsa2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+n*allergen),preg=c(-4.25,6.28,0.02,-0.11,-0.19,-0.19,-0.097,
	-0.0027,-0.033,-0.16,-0.075,0.0092,-1.33,0.015,-0.006,0),
	pdep=0.43,iter=200))

if(interactive()){
# comparison of treatments A and F, baseline is different for each subject
par(mfrow=c(2,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(mprofile(zp2ttpbhws2),ylim=c(0,6),nind=c(36,43),lty=c(1,4),
	main="Period 1")
plot(iprofile(zp2ttpbhws2),add=T,obs=T,nind=c(36,43),lty=2:3)
plot(mprofile(zp2ttpbhws2),ylim=c(0,6),nind=c(10,17),lty=c(1,4),
	main="Period 3")
plot(iprofile(zp2ttpbhws2),add=T,obs=T,nind=c(10,17),lty=2:3)
plot(mprofile(zp2ttpbhws2),ylim=c(0,6),nind=c(5,12),lty=c(1,4),main="Period 5")
plot(iprofile(zp2ttpbhws2),add=T,obs=T,nind=c(5,12),lty=2:3)
plot(mprofile(zp2ttpbhws2),ylim=c(0,6),nind=c(91,84),lty=c(1,4),
	main="Period 7")
plot(iprofile(zp2ttpbhws2),add=T,obs=T,nind=c(91,84),lty=2:3)
}

print(zp2ttpbhws2i <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+p*dose*times),preg=c(-2.74,5,-0.013,-0.061,-0.19,-0.19,
	-0.094,-0.0032,-0.03,-0.16,-0.075,0.0092,-1.4,0.015,-0.0059,
	-0.0029),pdep=0.43))
print(zp2ttpbhws2i2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+p*dose*times+r*per*times),preg=c(-3.69,6.7,-0.013,-0.088,
	-0.19,-0.19,-0.095,-0.0029,-0.036,-0.16,-0.16,0.009,-1.38,0.015,
	-0.006,-0.0029,0.0075),pdep=0.43))
print(zp2ttpbhws2i3 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+p*dose*times+r*per*times+s*baseline*times),preg=c(-2.57,
	4.65,-0.013,-0.057,-0.19,-0.19,-0.097,-0.0028,-0.039,-0.16,-0.16,
	0.035,-1.38,0.015,-0.006,-0.0029,0.0077,-0.0024),pdep=0.43))
print(zp2ttpbhws2i4 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+p*dose*times+r*per*times+s*baseline*times+u*height*times),
	preg=c(-2.55,4.62,-0.013,-0.056,-0.19,-0.19,-0.096,-0.0028,-0.039,
	-0.17,-0.16,0.035,-1.38,0.015,-0.006,-0.0029,0.0077,-0.0023,-0.0003),
	pdep=0.43))
print(zp2ttpbhws2i5 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+p*dose*times+r*per*times+s*baseline*times+u*weight*times),
	preg=c(-3.31,6.02,-0.013,-0.079,-0.19,-0.19,-0.096,-0.0026,-0.04,
	-0.17,-0.16,0.036,-1.38,0.011,-0.0061,-0.0029,0.0077,-0.0024,0.00032),
	pdep=0.43,iter=200))
print(zp2ttpbhws2i6 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+p*dose*times+r*per*times+s*baseline*times+u*systolic*times),
	preg=c(-0.87,1.58,-0.013,0.038,-0.19,-0.19,-0.093,-0.00095,-0.033,
	-0.16,-0.16,0.039,-1.38,0.015,0.0022,-0.0029,0.0078,-0.0027,-0.00073),
	pdep=0.42,iter=200))

print(zp2ttpbhws2i3t <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+tabg*(TREATMENTA+TREATMENTB+TREATMENTG)+f*per+g*baseline+
	j*height+k*weight+l*systolic+p*dose*times+r*per*times+
	s*baseline*times),preg=c(-2.57,4.65,-0.013,-0.057,-0.19,-0.16,
	0.035,-1.38,0.015,-0.006,-0.0029,0.0077,-0.0024),pdep=0.43))

if(interactive()){
# comparison of treatments A and F, baseline is different for each subject
postscript("cough5a.eps")
par(mfrow=c(2,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(mprofile(zp2ttpbhws2i3t),ylim=c(0,5.5),nind=c(99,100),lty=c(4,1),
	main="F period 1, A period 2",xlab="",ylab="Number of coughs")
plot(iprofile(zp2ttpbhws2i3t),add=T,obs=T,nind=c(99,100),lty=3:2)
plot(mprofile(zp2ttpbhws2i3t),ylim=c(0,5.5),nind=c(150,151),lty=c(1,4),
	main="A period 2, F period 3",xlab="",ylab="")
plot(iprofile(zp2ttpbhws2i3t),add=T,obs=T,nind=c(150,151),lty=2:3)
plot(mprofile(zp2ttpbhws2i3t),ylim=c(0,5.5),nind=c(41,42),lty=c(4,1),
	main="F period 6, A period 7",xlab="Minutes",ylab="Number of coughs")
plot(iprofile(zp2ttpbhws2i3t),add=T,obs=T,nind=c(41,42),lty=3:2)
plot(mprofile(zp2ttpbhws2i3t),ylim=c(0,5.5),nind=c(140,141),lty=c(1,4),
	main="A period 6, F period 7",xlab="Minutes",ylab="")
plot(iprofile(zp2ttpbhws2i3t),add=T,obs=T,nind=c(140,141),lty=2:3)
dev.off()

xx <- seq(0.0075,0.0225,by=0.002)
yy <- c(seq(-1.79,-0.89,by=0.1))
z <- like <- NULL
for(j in yy){
	z$coef <- c(-2.57,4.65,-0.013,-0.057,-0.19,-0.16,0.035,-0.006,
		-0.0029,0.0077,-0.0024)
	for(i in xx){
		reps1 <- rmna(resp,ccov=tcctomat(data.frame(i=rep(i,170),
			j=rep(j,170)),old=ccov1),tvc=dose)
		like <- c(like,(z <- gar(reps1,"Poisson",mu=~(e+a*dose)/
			(1+b*dose)*exp(d*times+tabg*(TREATMENTA+TREATMENTB+
			TREATMENTG)+f*per+g*baseline+j*height+i*weight+
			l*systolic+p*dose*times+r*per*times+s*baseline*times),
			preg=z$coef[1:11],pdep=0.43,iter=10))$maxlike)
		print(c(i,j,like[length(like)],z$code,z$iter))}}
like <- matrix(like,nrow=length(xx))
dimnames(like) <- list(xx,yy)

postscript("coughcon.eps",height=5)
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
contour(xx,yy,exp(-like+min(like)),levels=seq(0.1,0.9,by=0.1),labcex=0.6)
title(xlab="Weight",ylab="Height")
par(mar=c(0,1,0,0))
persp(xx,yy,exp(-like+min(like)),phi=25,theta=-45,r=20,xlab="Weight",
	ylab="Height",zlab="",tick="detail",cex=0.7)
dev.off()
}

print(zp2ttpbhws2i3a <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+p*dose*times+s*baseline*times),preg=c(-1.91,
	3.46,-0.013,-0.029,-0.19,-0.19,-0.097,-0.0028,-0.039,-0.16,-0.075,
	0.034,-1.39,0.015,-0.0058,-0.0029,-0.0022),pdep=0.43))
print(zp2ttpbhws2i3b <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+r*per*times+s*baseline*times),preg=c(-4.81,
	7.08,0.02,-0.11,-0.19,-0.19,-0.096,-0.0028,-0.038,-0.17,-0.17,
	0.034,-1.35,0.015,-0.0058,0.0072,-0.0022),pdep=0.43))
print(zp2ttpbhws2i3c <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-1.56,
	2.83,-0.013,-0.056,-0.19,-0.19,-0.1,-0.0028,-0.04,-0.16,-0.16,
	0.039,-1.37,0.011,-0.0029,0.0075,-0.0024),pdep=0.43))
print(zp2ttpbhws2i3d <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+
	l*systolic+p*dose*times+r*per*times+s*baseline*times),preg=c(-1.42,
	2.61,-0.014,-0.056,-0.19,-0.19,-0.1,-0.0028,-0.04,-0.16,-0.15,
	0.042,-0.96,0.001,-0.003,0.0072,-0.0023),pdep=0.45))
print(zp2ttpbhws2i3e <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+k*weight+
	l*systolic+p*dose*times+r*per*times+s*baseline*times),preg=c(-0.69,
	1,0.022,-0.11,-0.19,-0.19,-0.097,-0.0028,-0.039,-0.16,-0.16,
	0.035,0.015,-0.006,-0.0029,0.0077,-0.0024),pdep=0.43))
print(zp2ttpbhws2i3f <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+f*per+g*baseline+j*height+k*weight+l*systolic+p*dose*times+
	r*per*times+s*baseline*times),preg=c(-2.57,4.65,-0.013,-0.057,-0.16,
	0.035,-1.38,0.015,-0.006,-0.0029,0.0077,-0.0024),pdep=0.43))

print(znb2ttpbhws2i3 <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+p*dose*times+r*per*times+s*baseline*times),preg=c(-2.57,
	4.65,-0.013,-0.057,-0.19,-0.19,-0.097,-0.0028,-0.039,-0.16,-0.16,
	0.035,-1.38,0.015,-0.006,-0.0029,0.0077,-0.0024),psh=10,pdep=0.1))
print(znb2ttpbhws2i2 <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+p*dose*times+r*per*times),preg=c(-3.69,6.7,-0.013,-0.088,
	-0.19,-0.19,-0.095,-0.0029,-0.036,-0.16,-0.16,0.009,-1.38,0.015,
	-0.006,-0.0029,0.0075),psh=10,pdep=0.1,stepmax=1))
print(znb2ttpbhws2i3a <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+p*dose*times+s*baseline*times),preg=c(-1.91,
	3.46,-0.013,-0.029,-0.19,-0.19,-0.097,-0.0028,-0.039,-0.16,-0.075,
	0.034,-1.39,0.015,-0.0058,-0.0029,-0.0022),psh=10,pdep=0.1))
print(znb2ttpbhws2i3b <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	l*systolic+r*per*times+s*baseline*times),preg=c(-4.81,
	7.08,0.02,-0.11,-0.19,-0.19,-0.096,-0.0028,-0.038,-0.17,-0.17,
	0.034,-1.35,0.015,-0.0058,0.0072,-0.0022),psh=100,pdep=0.43))
print(znb2ttpbhws2i3c <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-1.56,
	2.83,-0.013,-0.056,-0.19,-0.19,-0.1,-0.0028,-0.04,-0.16,-0.16,
	0.039,-1.37,0.011,-0.0029,0.0075,-0.0024),psh=10,pdep=0.1))
print(znb2ttpbhws2i3d <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+
	l*systolic+p*dose*times+r*per*times+s*baseline*times),preg=c(-1.42,
	2.61,-0.014,-0.056,-0.19,-0.19,-0.1,-0.0028,-0.04,-0.16,-0.15,
	0.042,-0.96,0.001,-0.003,0.0072,-0.0023),psh=10,pdep=0.1))
print(znb2ttpbhws2i3e <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+k*weight+l*systolic+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-0.31,
	0.54,-0.014,-0.055,-0.21,-0.19,-0.11,-0.0028,-0.038,-0.16,-0.16,0.041,
	0.011,-0.0058,-0.0029,0.0081,-0.0025),psh=100,pdep=0.43,iter=200))
print(znb2ttpbhws2i3f <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+f*per+g*baseline+j*height+k*weight+l*systolic+p*dose*times+
	r*per*times+s*baseline*times),preg=c(-2.57,4.65,-0.013,-0.057,-0.16,
	0.035,-1.38,0.015,-0.006,-0.0029,0.0077,-0.0024),psh=10,pdep=0.1))
