library(repeated)

y <- read.table("cough.dat",header=T)
yy <- matrix(as.vector(t(as.matrix(y[,6:9])))[rep(c(seq(1,16,by=4),
	seq(2,16,by=4),seq(3,16,by=4),seq(4,16,by=4)),340)+
	rep(seq(0,5439,by=16),rep(16,340))],ncol=16,byrow=T)

id <- as.vector(tapply(as.matrix(y[,1]),gl(340,4),unique))
per <- as.vector(tapply(as.matrix(y[,3]),gl(340,4),unique))

design <- read.table("design.dat",header=T)
treat <- as.factor(ifelse(design[,4]=="F","0F",as.character(design[,4]))) 

baseline <- as.vector(tapply(read.table("baseline.dat")[,3],gl(24,4),sum)[id])

covar <- read.table("covar.dat",head=T)
attach(covar)

resp <- restovec(yy[seq(1,340,by=2),])
dose <- tvctomat(matrix(rep(rep(c(1,3,10,30),170),rep(4,680)),ncol=16,byrow=T),
	name="dose")
ccov1 <- tcctomat(data.frame(TREATMENT=treat,per=per[seq(2,340,by=2)],
	baseline=baseline[seq(2,340,by=2)],sex=sex[id[seq(2,340,by=2)]],
	age=age[id[seq(2,340,by=2)]],height=height[id[seq(2,340,by=2)]],
	weight=weight[id[seq(2,340,by=2)]],pulse=pulse[id[seq(2,340,by=2)]],
	systolic=systolic[id[seq(2,340,by=2)]],
	diastolic=diastolic[id[seq(2,340,by=2)]],
	allergen=allergen[id[seq(2,340,by=2)]],
	id=as.factor(id[seq(2,340,by=2)])),dataframe=F)
reps1 <- rmna(resp,ccov=ccov1,tvcov=dose)

# Note: because of a changed parametrization of the shape parameter for
# the negative binomial distribution in gar, the results are somewhat
# different than those in the book

print(zp2ttpbs <- gar(reps1,"Poisson",mu=~e+(a*dose)/(1+b*dose)+d*times+
	ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tg*TREATMENTG+f*per+g*baseline+h*sexM,
	preg=c(0.024,0.79,0.14,-0.11,-0.24,-0.3,-0.14,-0.12,-0.02,-0.2,-0.11,
	0.035,-0.25),pdep=0.41))
print(zp2ttpbs2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*exp(d*times+
	ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tg*TREATMENTG+f*per+g*baseline+h*sexM),
	preg=c(-0.69,1,0.022,-0.11,-0.37,-0.32,-0.26,-0.18,-0.086,-0.2,-0.12,
	0.035,-0.18),pdep=0.44))
print(zp2ttpbs3 <- gar(reps1,"Poisson",mu=~a*dose/(1+b*dose)*exp(e+d*times+
	ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tg*TREATMENTG+f*per+g*baseline+h*sexM),
	preg=c(0.6,0.023,-0.1,-0.064,-0.39,-0.34,-0.3,-0.21,-0.12,-0.23,-0.12,
	0.035,-0.17),pdep=0.47))
print(zp2ttpid2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*exp(d*times+
	ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tg*TREATMENTG+f*per+i2*id2+i3*id3+i4*id4+i5*id5+i6*id6
	+i7*id7+i8*id8+i9*id9+i10*id10+i11*id11+i12*id12+i13*id13+i14*id14
	+i15*id15+i16*id16+i17*id17+i18*id18+i19*id19+i20*id20+i21*id21
	+i22*id22+i23*id23+i24*id24),
	preg=c(-1.42,2,0.022,-0.11,-0.38,-0.28,-0.22,-0.14,-0.09,-0.2,-0.11,
	rep(0,23)),pdep=0.32))
print(zp2ttp2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*exp(d*times+
	ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+te*TREATMENTE+
	tg*TREATMENTG+f*per),preg=c(-1.42,2,0.022,-0.11,-0.38,-0.28,-0.22,
	-0.14,-0.09,-0.2,-0.11),pdep=0.32))

print(znb2ttpid <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)+
	d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+i2*id2+i3*id3+i4*id4+i5*id5+i6*id6
	+i7*id7+i8*id8+i9*id9+i10*id10+i11*id11+i12*id12+i13*id13+i14*id14
	+i15*id15+i16*id16+i17*id17+i18*id18+i19*id19+i20*id20+i21*id21
	+i22*id22+i23*id23+i24*id24,
	preg=c(0.026,1.07,0.17,-0.13,-0.22,-0.33,-0.17,-0.19,-0.019,-0.032,
	-0.11,rep(0,23)),psh=17,pdep=0.32))
print(znb2ttpbs <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)+
	d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+h*sexM,
	preg=c(0.024,0.75,0.13,-0.11,-0.23,-0.3,-0.14,-0.12,-0.02,-0.2,-0.11,
	0.035,-0.25),psh=10.2,pdep=0.42))
print(znb2ttpbs2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+h*sexM),
	preg=c(-0.69,1,0.022,-0.11,-0.37,-0.32,-0.26,-0.18,-0.086,-0.2,-0.12,
	0.035,-0.18),psh=5,pdep=0.4))
print(znb2ttpbs3 <- gar(reps1,"negative binomial",mu=~a*dose/(1+b*dose)*
	exp(e+d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+h*sexM),
	preg=c(0.6,0.023,-0.1,-0.064,-0.39,-0.34,-0.3,-0.21,-0.12,-0.23,-0.12,
	0.035,-0.17),psh=5,pdep=0.4))

print(znb2ttpid2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+i2*id2+i3*id3+i4*id4+i5*id5+i6*id6
	+i7*id7+i8*id8+i9*id9+i10*id10+i11*id11+i12*id12+i13*id13+i14*id14
	+i15*id15+i16*id16+i17*id17+i18*id18+i19*id19+i20*id20+i21*id21
	+i22*id22+i23*id23+i24*id24),
	preg=c(-1.42,2,0.022,-0.11,-0.38,-0.28,-0.22,-0.14,-0.09,-0.2,-0.11,
	rep(0,23)),psh=12.5,pdep=0.32))
print(znb2ttpbsh2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+h*sexM+j*height),
	preg=c(-5.4,7.69,0.022,-0.11,-0.41,-0.34,-0.32,-0.22,-0.15,-0.24,-0.12,
	0.03,-0.003,-1.19),psh=12.5,pdep=0.45))
print(znb2ttpbh2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height),
	preg=c(-5.4,7.69,0.022,-0.11,-0.41,-0.34,-0.32,-0.22,-0.15,-0.24,-0.12,
	0.03,-1.19),psh=5,pdep=0.2))
print(znb2ttpbhw2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+k*weight),
	preg=c(-5.96,8.43,0.023,-0.11,-0.4,-0.34,-0.32,-0.22,-0.15,-0.24,-0.12,
	0.029,-1.32,0.002),psh=12.3,pdep=0.45))
print(znb2ttpbhs2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+l*systolic),
	preg=c(-7.73,10.9,0.022,-0.11,-0.41,-0.34,-0.31,-0.21,-0.15,-0.24,
	-0.12,0.029,-1.19,-0.003),psh=12.5,pdep=0.44))
print(znb2ttpbhd2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic),
	preg=c(-7.46,10.56,0.023,-0.11,-0.41,-0.34,-0.31,-0.21,-0.15,-0.24,
	-0.12,0.03,-1.09,-0.0063),psh=10,pdep=0.2))
print(znb2ttpbhdp2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	n*pulse),preg=c(-9.31,13.15,0.023,-0.11,-0.41,-0.34,-0.31,-0.22,-0.15,
	-0.24,-0.12,0.029,-1.15,-0.0064,-0.0015),psh=12.4,pdep=0.44,iter=200))
print(znb2ttpbhda2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	n*allergen),preg=c(-9.31,13.15,0.023,-0.11,-0.41,-0.34,-0.31,-0.22,
	-0.15,-0.24,-0.12,0.029,-1.15,-0.0064,0.027),psh=12.4,pdep=0.2,
	iter=200))

if(interactive()){
# comparison of treatments A and F, baseline is different for each subject
par(mfrow=c(2,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(mprofile(znb2ttpbhd2),ylim=c(0,6),nind=c(36,43),lty=c(1,4),
	main="Period 1")
plot(iprofile(znb2ttpbhd2),add=T,obs=T,nind=c(36,43),lty=2:3)
plot(mprofile(znb2ttpbhd2),ylim=c(0,6),nind=c(10,17),lty=c(1,4),
	main="Period 3")
plot(iprofile(znb2ttpbhd2),add=T,obs=T,nind=c(10,17),lty=2:3)
plot(mprofile(znb2ttpbhd2),ylim=c(0,6),nind=c(5,12),lty=c(1,4),main="Period 5")
plot(iprofile(znb2ttpbhd2),add=T,obs=T,nind=c(5,12),lty=2:3)
plot(mprofile(znb2ttpbhd2),ylim=c(0,6),nind=c(91,84),lty=c(1,4),
	main="Period 7")
plot(iprofile(znb2ttpbhd2),add=T,obs=T,nind=c(91,84),lty=2:3)
}

print(znb2ttpbhd2i <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times),preg=c(-3.47,6.08,-0.016,-0.047,-0.41,-0.34,-0.3,-0.22,
	-0.15,-0.24,-0.12,0.03,-1.11,-0.0063,-0.0035),psh=12.6,pdep=0.45))
print(znb2ttpbhd2i2 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+r*per*times),preg=c(-4.68,8.24,-0.017,-0.075,-0.41,-0.34,
	-0.3,-0.21,-0.15,-0.24,-0.22,0.03,-1.09,-0.0063,-0.0036,0.0087),
	psh=12.6,pdep=0.2))
print(znb2ttpbhd2i3 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-3.17,5.51,-0.016,
	-0.037,-0.41,-0.34,-0.3,-0.22,-0.15,-0.25,-0.22,0.061,-1.1,
	-0.0064,-0.0035,0.009,-0.0028),psh=12.4,pdep=0.2))
print(znb2ttpbhd2i4 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+r*per*times+s*baseline*times+u*height*times),
	preg=c(-3.24,5.62,-0.016,-0.038,-0.41,-0.34,-0.3,-0.22,-0.15,-0.25,
	-0.22,0.061,-1.1,-0.0064,-0.0035,0.009,-0.0028,-0.0003),
	psh=0.5,pdep=0.1,iter=200))
print(znb2ttpbhd2i5 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+r*per*times+s*baseline*times+u*diastolic*times),
	preg=c(-2.37,4.01,-0.016,-0.0014,-0.41,-0.34,-0.3,-0.21,-0.15,-0.24,
	-0.22,0.056,-1.17,0.0012,-0.0034,0.0095,-0.0024,-0.00065),
	psh=0.5,pdep=0.1,iter=200))
print(znb2ttpbhd2i6 <- gar(reps1,"negative binomial",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+r*per*times+s*baseline*times+t*allergen),
	preg=c(-3.19,5.53,-0.016,-0.037,-0.41,-0.34,-0.3,-0.22,-0.15,-0.25,
	-0.22,0.061,-1.1,-0.0064,-0.0035,0.009,-0.0028,0),psh=0.5,pdep=0.1))

print(znb2ttpbhd2i3a <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+s*baseline*times),preg=c(-2.31,4.02,-0.016,
	-0.0096,-0.41,-0.35,-0.3,-0.22,-0.15,-0.24,-0.12,0.059,-1.11,
	-0.0063,-0.0035,-0.0025),psh=0.5,pdep=0.1))
print(znb2ttpbhd2i3b <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	r*per*times+s*baseline*times),preg=c(-7.17,10.07,0.023,
	-0.1,-0.41,-0.34,-0.31,-0.22,-0.15,-0.25,-0.21,0.058,-1.1,
	-0.0064,0.0084,-0.0025),psh=10,pdep=0.1))
print(znb2ttpbhd2i3c <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-2.56,4.44,-0.016,
	-0.041,-0.41,-0.34,-0.31,-0.22,-0.15,-0.24,-0.22,0.06,-1.24,
	-0.0035,0.009,-0.0027),psh=12.3,pdep=0.1))
print(znb2ttpbhd2i3d <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+m*diastolic+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-0.55,0.95,-0.016,
	-0.038,-0.42,-0.35,-0.31,-0.22,-0.14,-0.25,-0.22,0.064,
	-0.0085,-0.0035,0.0091,-0.0028),psh=10.9,pdep=0.1))
print(znb2ttpbhd2i3e <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+f*per+g*baseline+j*height+m*diastolic+p*dose*times+
	r*per*times+s*baseline*times),preg=c(-3.17,5.51,-0.016,-0.037,-0.22,
	0.061,-1.1,-0.0064,-0.0035,0.009,-0.0028),psh=12.4,pdep=0.44))

print(znb2ttpbhd2i3t <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tbc*(TREATMENTB+TREATMENTC)+tdeg*(TREATMENTD+
	TREATMENTE+TREATMENTG)+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-3.17,5.51,-0.016,
	-0.037,-0.41,-0.32,-0.2,-0.22,0.061,-1.1,
	-0.0064,-0.0035,0.009,-0.0028),psh=12.4,pdep=0.1))
print(znb2ttpbhd2i3t2 <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+tabc*(TREATMENTA+TREATMENTB+TREATMENTC)+tdeg*(TREATMENTD+
	TREATMENTE+TREATMENTG)+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-3.17,5.51,-0.016,
	-0.037,-0.36,-0.2,-0.22,0.061,-1.1,-0.0064,-0.0035,0.009,-0.0028),
	psh=12.4,pdep=0.1))
print(znb2ttpbhd2i3t3 <- gar(reps1,"negative bin",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+tabcd*(TREATMENTA+TREATMENTB+TREATMENTC+TREATMENTD)+
	teg*(TREATMENTE+TREATMENTG)+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-3.17,5.51,-0.016,
	-0.037,-0.36,-0.2,-0.22,0.061,-1.1,-0.0064,-0.0035,0.009,-0.0028),
	psh=12.4,pdep=0.44))

if(interactive()){
# comparison of treatments A and F, baseline is different for each subject
postscript("cough1a.eps")
par(mfrow=c(2,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(mprofile(znb2ttpbhd2i3t2),ylim=c(0,5.5),nind=c(99,100),lty=c(4,1),
	main="F period 1, A period 2",xlab="",ylab="Number of coughs")
plot(iprofile(znb2ttpbhd2i3t2),add=T,obs=T,nind=c(99,100),lty=3:2)
plot(mprofile(znb2ttpbhd2i3t2),ylim=c(0,5.5),nind=c(150,151),lty=c(1,4),
	main="A period 2, F period 3",xlab="",ylab="")
plot(iprofile(znb2ttpbhd2i3t2),add=T,obs=T,nind=c(150,151),lty=2:3)
plot(mprofile(znb2ttpbhd2i3t2),ylim=c(0,5.5),nind=c(41,42),lty=c(4,1),
	main="F period 6, A period 7",xlab="Minutes",ylab="Number of coughs")
plot(iprofile(znb2ttpbhd2i3t2),add=T,obs=T,nind=c(41,42),lty=3:2)
plot(mprofile(znb2ttpbhd2i3t2),ylim=c(0,5.5),nind=c(140,141),lty=c(1,4),
	main="A period 6, F period 7",xlab="Minutes",ylab="")
plot(iprofile(znb2ttpbhd2i3t2),add=T,obs=T,nind=c(140,141),lty=2:3)
dev.off()
}

print(zp2ttpbhd2i3 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-3.42,6.47,-0.016,
	-0.047,-0.4,-0.34,-0.28,-0.21,-0.14,-0.24,-0.21,0.056,-1.16,
	-0.0063,-0.0034,0.0082,-0.0024),pdep=0.43))
print(zp2ttpbhd2i2 <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+r*per*times),preg=c(-4.68,8.24,-0.017,-0.075,-0.41,-0.34,
	-0.3,-0.21,-0.15,-0.24,-0.22,0.03,-1.09,-0.0063,-0.0036,0.0087),
	pdep=0.44))
print(zp2ttpbhd2i3a <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	p*dose*times+s*baseline*times),preg=c(-2.53,4.81,-0.016,
	-0.019,-0.4,-0.34,-0.28,-0.21,-0.14,-0.24,-0.12,0.055,-1.17,
	-0.0062,-0.0034,-0.0023),pdep=0.43))
print(zp2ttpbhd2i3b <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+m*diastolic+
	r*per*times+s*baseline*times),preg=c(-7.7,11.35,0.022,
	-0.11,-0.4,-0.33,-0.28,-0.21,-0.14,-0.24,-0.2,0.054,-1.15,
	-0.0063,0.0077,-0.0022),pdep=0.42))
print(zp2ttpbhd2i3c <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+j*height+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-2.63,5,-0.016,
	-0.047,-0.39,-0.33,-0.29,-0.21,-0.14,-0.23,-0.21,0.056,-1.29,
	-0.0035,0.0081,-0.0023),pdep=0.43))
print(zp2ttpbhd2i3d <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+ta*TREATMENTA+tb*TREATMENTB+tc*TREATMENTC+td*TREATMENTD+
	te*TREATMENTE+tg*TREATMENTG+f*per+g*baseline+m*diastolic+
	p*dose*times+r*per*times+s*baseline*times),preg=c(-0.55,0.95,-0.016,
	-0.038,-0.42,-0.35,-0.31,-0.22,-0.14,-0.25,-0.22,0.064,
	-0.0085,-0.0035,0.0091,-0.0028),pdep=0.44))
print(zp2ttpbhd2i3e <- gar(reps1,"Poisson",mu=~(e+a*dose)/(1+b*dose)*
	exp(d*times+f*per+g*baseline+j*height+m*diastolic+p*dose*times+
	r*per*times+s*baseline*times),preg=c(-3.17,5.51,-0.016,-0.037,-0.22,
	0.061,-1.1,-0.0064,-0.0035,0.009,-0.0028),pdep=0.44))
