library(repeated)

data <- read.list("bloodglu.dat",skip=4,nlines=1)
times <- c(-15, 0, 30, 60, 90, 120, 180, 240, 300, 360, 420)
baseline <- NULL
for(i in 1:length(data))baseline <- c(baseline,data[[i]][1])
for(i in 1:length(data))
	data[[i]] <- cbind(data[[i]][-1],c(0.01,times[3:length(data[[i]])]))
hour <- codes(gl(6,6))
y <- restovec(data,delta=0.01)
reps <- rmna(y,ccov=tcctomat(ccov=~hour+baseline))

if(interactive()){
main <- c("2:00","6:00","10:00","14:00","18:00","22:00")
xlab <- c("","","","","Minutes","Minutes")
ylab <- c("Blood glucose","","Blood glucose","","Blood glucose","")
postscript("bloodglu.eps",width=5,height=7)
par(mfrow=c(3,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
for(i in 1:6){
	plot(reps,nind=((i-1)*6+1):((i-1)*6+6),lty=1,pch=1:6,ylim=c(0,12),
		xlab=xlab[i],ylab=ylab[i],main=main[i],xaxt="n",yaxt="n")
	axis(1,c(0,30,60,90,120,180,240,300,360,420))
	axis(2,c(0,4,8,12))}
dev.off()
}

mu0 <- function(p){
	ka <- exp(p[2])
	ke <- exp(p[3])
	p[4]*(1+exp(p[2]-p[1])*baseline/(ka-ke)*
		(exp(-ke*times)-exp(-ka*times)))}
mu2 <- function(p){
	ka <- exp(p[2])
	ke <- exp(p[3]+p[5]*(hour==2)+p[6]*(hour==3)+
		p[7]*(hour==4)+p[8]*(hour==5)+p[9]*(hour==6))
	p[4]*(1+exp(p[2]-p[1])*baseline/(ka-ke)*
		(exp(-ke*times)-exp(-ka*times)))}
mu2s <- function(p){
	ka <- exp(p[2])
	ke <- exp(p[3]+p[5]*(hour==2)+p[6]*(hour==3)+
		p[7]*(hour==4)+p[7]*(hour==5))
	p[4]*(1+exp(p[2]-p[1])*baseline/(ka-ke)*
		(exp(-ke*times)-exp(-ka*times)))}
mu3 <- function(p){
	ka <- exp(p[2])
	ke <- exp(p[3]+p[5]*(hour==2)+p[6]*(hour==3)+
		p[7]*(hour==4)+p[8]*(hour==5)+p[9]*(hour==6))
	p[4]*(1+exp(p[2]-p[1]-p[10]*(hour==2)-p[11]*(hour==3)-p[12]*(hour==4)-
		p[13]*(hour==5)-p[14]*(hour==6))*baseline/(ka-ke)*
		(exp(-ke*times)-exp(-ka*times)))}
mu3s <- function(p){
	ka <- exp(p[2])
	ke <- exp(p[3]+p[5]*(hour==2)+p[6]*(hour==3)+
		p[7]*(hour==4)+p[7]*(hour==5))
	p[4]*(1+exp(p[2]-p[1]-p[8]*(hour==3))*baseline/(ka-ke)*
		(exp(-ke*times)-exp(-ka*times)))}
mu4 <- function(p){
	ka <- exp(p[2]+p[10]*(hour==2)+p[11]*(hour==3)+p[12]*(hour==4)+
		p[13]*(hour==5)+p[14]*(hour==6))
	ke <- exp(p[3]+p[5]*(hour==2)+p[6]*(hour==3)+
		p[7]*(hour==4)+p[8]*(hour==5)+p[9]*(hour==6))
	p[4]*(1+exp(p[2]-p[1]+p[10]*(hour==2)+p[11]*(hour==3)+p[12]*(hour==4)+
		p[13]*(hour==5)+p[14]*(hour==6))*baseline/(ka-ke)*
		(exp(-ke*times)-exp(-ka*times)))}

print(u0n <- kalseries(reps,intens="normal",mu=mu0,
	ptvc=c(2,-2.6,-4.9,4),dep="Markov",pdep=0.9,psh=1))
print(u0g <- kalseries(reps,intens="gamma",mu=mu0,pinit=0.3,
	ptvc=c(1.6,-3.14,-4.5,0.14),dep="Markov",pdep=0.99,psh=20))
print(u0w <- kalseries(reps,intens="Weibull",mu=mu0,
	ptvc=c(1.6,-2.6,-4,4),dep="Markov",pdep=0.9,psh=2))
print(u0ln <- kalseries(reps,intens="normal",mu=mu0,trans="log",
	link="exp",ptvc=c(1.5,-3,-4.4,1.5),dep="Markov",
	pdep=0.98,psh=0.3,pinit=0.1))
print(u0ll <- kalseries(reps,intens="logistic",mu=mu0,trans="log",
	link="exp",ptvc=c(1.5,-3,-4.4,1.5),dep="Markov",pinit=0.1,
	pdep=0.9,psh=0.1))
print(u0lc <- kalseries(reps,intens="Cauchy",mu=mu0,trans="log",
	link="exp",ptvc=c(1.5,-3,-4.4,1.5),dep="Markov",
	pdep=0.9,psh=0.1,pinit=1))

print(u2n <- kalseries(reps,intens="normal",mu=mu2,
	ptvc=c(1,-4,-4.3,4,0,0,0,0,0),dep="Markov",pdep=0.8,psh=1))
print(u2g <- kalseries(reps,intens="gamma",mu=mu2,
	ptvc=c(1.6,-3.1,-4.5,0.14,0,0,0,0,0),dep="Markov",pinit=0.3,
	pdep=0.999,psh=10,iter=200))
print(u2w <- kalseries(reps,intens="Weibull",mu=mu2,dep="Markov",
	ptvc=c(1,-4,-4.3,4,0,0,0,0,0),pdep=0.8,psh=0.1))
print(u2ln <- kalseries(reps,intens="normal",mu=mu2,trans="log",
	link="exp",ptvc=c(1.5,-3.7,-4.4,1.5,0.6,1.3,0.4,0.4,0),dep="Markov",
	pdep=0.9,psh=1,pinit=2))
print(u2ll <- kalseries(reps,intens="logistic",mu=mu2,trans="log",
	link="exp",ptvc=c(1.5,-3.7,-4.4,1.5,0.6,1.3,0.4,0.4,0),dep="Markov",
	pdep=0.98,psh=0.1))
print(u2lc <- kalseries(reps,intens="Cauchy",mu=mu2,trans="log",
	link="exp",ptvc=c(1.5,-3.7,-4.4,1.5,0.6,1.3,0.4,0.4,0),dep="Markov",
	pdep=0.9,psh=1,pinit=1))

print(u3n <- kalseries(reps,intens="normal",mu=mu3,
	ptvc=c(1.5,-3.7,-4.3,4.5,0,0,0,0,0,0,0,0,0,0),dep="Markov",
	pdep=0.99,psh=0.7,pinit=0.25))
print(u3g <- kalseries(reps,intens="gamma",mu=mu3,pinit=0.08,
	ptvc=c(0.85,-3.8,-4.4,0.09,0.83,6.63,0.32,0.68,0.06,-0.1,-5.5,0.1,
	-0.16,-0.07),dep="Markov",pdep=0.99,psh=10,iter=200))
print(u3w <- kalseries(reps,intens="Weibull",mu=mu3,
	ptvc=c(0.8,-3.9,-4.3,4.7,1,6,0.3,0.75,0.1,-0.2,-5,0.1,-0.18,-0.16),
	dep="Markov",pinit=0.11,pdep=0.8,psh=1))
print(u3ln <- kalseries(reps,intens="normal",mu=mu3,trans="log",
	link="exp",ptvc=c(1.5,-3.7,-4.4,1.5,0.6,7,0.4,0.4,0,0,-6,0,0,0),
	dep="Markov",pdep=0.98,psh=0.03,pinit=0.15,iter=200))
print(u3ll <- kalseries(reps,intens="logistic",mu=mu3,trans="log",
	link="exp",ptvc=c(1.5,-3.7,-4.4,1.5,0.6,1.3,0.4,0.4,0,0,0,0,0,0),
	dep="Markov",pdep=0.9,psh=1,pinit=0.1))
print(u3lc <- kalseries(reps,intens="Cauchy",mu=mu3,trans="log",
	link="exp",ptvc=c(1.7,-3.5,-4.5,1.5,0.8,6.7,0.2,0.5,0.1,-0.1,-5.6,
	0.2,0,-0.1),dep="Markov",pdep=0.99,psh=0.006,pinit=0.1,iter=200))

print(u3ws <- kalseries(reps,intens="Weibull",mu=mu3s,
	ptvc=c(1,-4,-4.3,4,0,0,0,0),dep="Markov",pdep=0.8,psh=1))

if(interactive()){
mu3sp <- function(p,times){
	ka <- exp(p[2])
	ke <- exp(p[3]+p[5]*(hr==2)+p[6]*(hr==3)+
		p[7]*(hr==4)+p[7]*(hr==5))
	p[4]*(1+exp(p[2]-p[1]-p[8]*(hr==3))*4.54/(ka-ke)*
		(exp(-ke*times)-exp(-ka*times)))}
main <- c("2:00","6:00","10:00","14:00","18:00","22:00")
xlab <- c("","","","","Minutes","Minutes")
ylab <- c("Blood glucose","","Blood glucose","","Blood glucose","")
postscript("bldglpr1.eps",width=5,height=7)
par(mfrow=c(3,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
j <- 1
for(i in 1:6){
	plot(iprofile(u3ws),nind=c((i-1)*6+j,(i-1)*6+j+1),lty=c(2,3),
		pch=c(1,2),ylim=c(0,12),xaxt="n",yaxt="n",
		xlab=xlab[i],ylab=ylab[i],main=main[i])
	axis(1,c(0,30,60,90,120,180,240,300,360,420))
	axis(2,c(0,4,8,12))
	hr <- i
	plot(mprofile(u3ws,times=seq(0,420,by=20),mu=mu3sp),add=T)}
dev.off()

mu3sp <- function(p){
	ka <- exp(j)
	ke <- exp(i+p[3]*(hour==2)+p[4]*(hour==3)+p[5]*((hour==4)+(hour==5)))
	p[2]*(1+exp(j-p[1]-p[6]*(hour==3))*baseline/(ka-ke)*
		(exp(-ke*times)-exp(-ka*times)))}
xx <- seq(-4.6,-3.9,by=0.05)
yy <- seq(-4.31,-3.61,by=0.05)
z <- like <- NULL
for(j in yy){
	z$coef <- c(0.642,4.46,0.715,6.5,0.41,-5.52,log(c(0.5464,1,10.1759)))
	for(i in xx){
		reps <- rmna(y,ccov=tcctomat(data.frame(hour=hour,
			baseline=baseline,i=rep(i,36),j=rep(j,36))))
		like <- c(like,(z <- kalseries(reps,intens="Weibull",mu=mu3sp,
			ptvc=z$coef[1:6],dep="Markov",pdep=0.9,
			pinit=exp(z$coef[7]),psh=exp(z$coef[9]),
			iter=100))$maxlike)
		print(c(i,j,like[length(like)],z$code,z$iter))}}
like <- matrix(like,nrow=length(xx))
dimnames(like) <- list(xx,yy)

postscript("bloodglc.eps",height=5)
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
contour(exp(xx),exp(yy)[1:11],exp(-like+min(like))[,1:11],
	levels=seq(0.1,0.9,by=0.1))
title(xlab=expression(k[e]),ylab=expression(k[a]))
par(mar=c(0,0,0,0))
persp(exp(xx),exp(yy)[1:11],box=F,phi=25,exp(-like+min(like))[,1:11])
mtext(expression(k[e]),1,line=-4)
mtext(expression(k[a]),2,at=-0.2,line=-3)
dev.off()
}

print(u4n <- kalseries(reps,intens="normal",mu=mu4,pdep=0.99,psh=0.7,
	ptvc=c(1.5,-3.7,-4.3,4.5,0,0,0,0,0,0,0,0,0,0),dep="Markov",pinit=0.25))
print(u4g <- kalseries(reps,intens="gamma",mu=mu4,pinit=0.3,
	ptvc=c(1.6,-3.1,-4.5,0.14,0.83,6.63,0.32,0.68,0,0,0,0,0,0),
	dep="Markov",pdep=0.99,psh=10,iter=300))
print(u4w <- kalseries(reps,intens="Weibull",mu=mu4,
	ptvc=c(0.8,-3.9,-4.3,4.7,1,6,0.3,0.75,0.1,-0.2,-5,0.1,-0.18,-0.16),
	dep="Markov",pinit=0.11,pdep=0.8,psh=1))
print(u4ln <- kalseries(reps,intens="normal",mu=mu4,trans="log",link="exp",
	ptvc=c(1.4,-3.7,-4.4,1.5,0.76,1.5,0.5,0.6,0,0.5,1.4,0.3,0.5,0.2),
	dep="Markov",pdep=0.98,psh=0.03,pinit=0.15,iter=200))
print(u4ll <- kalseries(reps,intens="logistic",mu=mu4,trans="log",
	link="exp",ptvc=c(1.5,-3.7,-4.4,1.5,0.6,1.3,0.4,0.4,0,0,0,0,0,0),
	dep="Markov",pdep=0.99,psh=0.1,pinit=0.1))
print(u4lc <- kalseries(reps,intens="Cauchy",mu=mu4,trans="log",
	link="exp",ptvc=c(1.5,-3.7,-4.4,1.5,0.6,1.3,0.4,0.4,0,0,0,0,0,0),
	dep="Markov",pdep=0.99,psh=0.02,pinit=0.1,iter=200))

print(z0n <- gar(reps,"normal",mu=mu0,preg=c(1.6,-2.6,-4.9,4.3),
	pdep=0.9,psh=1))
print(z0g <- gar(reps,"gamma",mu=mu0,preg=c(1.6,-2.6,-4.9,4.3),pdep=0.9,
	psh=1))
print(z0w <- gar(reps,"Weibull",mu=mu0,preg=c(1.6,-2.6,-4.9,4.3),
	pdep=0.9,psh=1))
print(z0ln <- gar(reps,"normal",mu=mu0,preg=c(1.6,-2.6,-4.9,4.3),
	trans="log",link="exp",pdep=0.9,psh=1))
print(z0ll <- gar(reps,"logistic",mu=mu0,preg=c(1.6,-2.6,-4.9,4.3),
	trans="log",link="exp",pdep=0.9,psh=1))
print(z0lc <- gar(reps,"Cauchy",mu=mu0,preg=c(1.6,-2.6,-4.9,4.3),
	trans="log",link="exp",pdep=0.9,psh=1))

print(z2n <- gar(reps,mu=mu2,preg=c(1.6,-2.6,-4.9,4.3,0,0,0,0,0),
	pdep=0.9,psh=1))
print(z2g <- gar(reps,"gamma",mu=mu2,
	preg=c(1.6,-2.6,-4.9,4.3,0,0,0,0,0),pdep=0.9,psh=1))
print(z2w <- gar(reps,"Weibull",mu=mu2,iter=200,pdep=0.95,
	preg=c(0.64,-3.8,-4.2,4.6,0.76,1.1,0.4,0.4,0),psh=2))
print(z2ln <- gar(reps,"normal",mu=mu2,trans="log",link="exp",
	preg=c(1.6,-3,-4.9,4.3,0,0,0,0,0),pdep=0.95,psh=0.3))
print(z2ll <- gar(reps,"logistic",mu=mu2,trans="log",link="exp",
	preg=c(1.6,-2.6,-4.9,4.3,0,0,0,0,0),pdep=0.9,psh=1))
print(z2lc <- gar(reps,"Cauchy",mu=mu2,trans="log",link="exp",
	preg=c(1.6,-2.6,-4.9,4.3,0,0,0,0,0),pdep=0.9,psh=1))

print(z2ws <- gar(reps,"Weibull",mu=mu2s,trans="log",link="exp",
	preg=c(1.6,-2.6,-4.9,4.3,0,0,0),pdep=0.9,psh=1))

if(interactive()){
mu2sp <- function(p,times){
	ka <- exp(p[2])
	ke <- exp(p[3]+p[5]*(i==2)+p[6]*(i==3)+p[7]*(i==4)+p[7]*(i==5))
	p[4]*(1+exp(p[2]-p[1])*data[[(i-1)*6+j]][1]/(ka-ke)*
		(exp(-ke*times)-exp(-ka*times)))}
postscript("bldglpr2.eps",width=5,height=7)
par(mfrow=c(3,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
j <- 1
for(i in 1:6){
	plot(iprofile(z2ws),nind=c((i-1)*6+j,(i-1)*6+j+1),lty=c(2,3),xaxt="n",
		yaxt="n",pch=c(1,2),ylim=c(0,12),xlab=xlab[i],ylab=ylab[i],
		main=main[i])
	axis(1,c(0,30,60,90,120,180,240,300,360,420))
	axis(2,c(0,4,8,12))
	plot(mprofile(z2ws,times=seq(0,420,by=20),mu=mu2sp),add=T)}
dev.off()
}

print(z3n <- gar(reps,mu=mu3,preg=c(1.6,-2.6,-4.9,4.3,rep(0,10)),
	pdep=0.9,psh=1))
print(z3g <- gar(reps,"gamma",mu=mu3,
	preg=c(1.6,-2.6,-4.9,4.3,rep(0,10)),pdep=0.9,psh=1))
print(z3w <- gar(reps,"Weibull",mu=mu3,
	preg=c(1.6,-2.6,-4.9,4.3,rep(0,10)),pdep=0.9,psh=1))
print(z3ln <- gar(reps,"normal",mu=mu3,trans="log",link="exp",
	preg=c(1.6,-3,-4.9,4.3,rep(0,10)),pdep=0.95,psh=0.3))
print(z3ll <- gar(reps,"logistic",mu=mu3,trans="log",link="exp",
	preg=c(1.6,-2.6,-4.9,4.3,rep(0,10)),pdep=0.9,psh=1))
print(z3lc <- gar(reps,"Cauchy",mu=mu3,trans="log",link="exp",
	preg=c(1.6,-2.6,-4.9,4.3,rep(0,10)),pdep=0.9,psh=1))

print(z4n <- gar(reps,mu=mu4,preg=c(1.6,-2.6,-4.9,4.3,rep(0,10)),
	pdep=0.9,psh=1))
print(z4g <- gar(reps,"gamma",mu=mu4,
	preg=c(1.6,-2.6,-4.9,4.3,rep(0,10)),pdep=0.9,psh=1))
print(z4w <- gar(reps,"Weibull",mu=mu4,
	preg=c(1.6,-2.6,-4.9,4.3,rep(0,10)),pdep=0.9,psh=1))
print(z4ln <- gar(reps,"normal",mu=mu4,trans="log",link="exp",
	preg=c(1.6,-3,-4.9,4.3,rep(0,10)),pdep=0.95,psh=0.3))
print(z4ll <- gar(reps,"logistic",mu=mu4,trans="log",link="exp",
	preg=c(1.6,-2.6,-4.9,4.3,rep(0,10)),pdep=0.9,psh=1))
print(z4lc <- gar(reps,"Cauchy",mu=mu4,trans="log",link="exp",
	preg=c(1.6,-2.6,-4.9,4.3,rep(0,10)),pdep=0.9,psh=1))
