library(gnlm)
library(repeated)

data <- cbind(rep(0,8),matrix(scan("propox.dat",skip=13),ncol=32,byrow=T))
datac <- ifelse(data>0,data,0.5)
censor <- ifelse(data>0,1,-1)
ctimes <- matrix(rep(c(0.01,c(1/12,0.25,1,2,3,6,9,24),
       c(1/12,0.25,1,2,3,6,9,24)+24,c(1/12,0.25,1,2,3,6,9,24)+
       48,c(1/12,0.25,1,2,3,6,9,24)+72),8),ncol=33,byrow=T)
respc <- restovec(datac,times=ctimes,censor=censor,delta=0.1)

trt <- rbind(c(rep(1,9),rep(2,8),rep(3,8),rep(4,8)),
	c(rep(4,9),rep(3,8),rep(2,8),rep(1,8)),
	c(rep(2,9),rep(4,8),rep(1,8),rep(3,8)),
	c(rep(3,9),rep(1,8),rep(4,8),rep(2,8)),
	c(rep(3,9),rep(1,8),rep(4,8),rep(2,8)),
	c(rep(2,9),rep(4,8),rep(1,8),rep(3,8)),
	c(rep(4,9),rep(3,8),rep(2,8),rep(1,8)),
	c(rep(1,9),rep(2,8),rep(3,8),rep(4,8)))
trtA <- as.vector(t(rbind(c(rep(1,15),rep(0,18)),
	c(rep(0,24),rep(1,9)),
	c(rep(0,16),rep(1,15),rep(0,2)),
	c(rep(0,8),rep(1,15),rep(0,10)),
	c(rep(0,8),rep(1,15),rep(0,10)),
	c(rep(0,16),rep(1,15),rep(0,2)),
	c(rep(0,24),rep(1,9)),
	c(rep(1,15),rep(0,18)))))
timesA <- as.vector(t(rbind(c(ctimes[1,1:15],rep(0,18)),
	c(rep(0,24),ctimes[1,1:9]),
	c(rep(0,16),ctimes[1,1:15],rep(0,2)),
	c(rep(0,8),ctimes[1,1:15],rep(0,10)),
	c(rep(0,8),ctimes[1,1:15],rep(0,10)),
	c(rep(0,16),ctimes[1,1:15],rep(0,2)),
	c(rep(0,24),ctimes[1,1:9]),
	c(ctimes[1,1:15],rep(0,18)))))
trtB <- as.vector(t(rbind(c(rep(0,8),rep(1,15),rep(0,10)),
	c(rep(0,16),rep(1,15),rep(0,2)),
	c(rep(1,15),rep(0,18)),
	c(rep(0,24),rep(1,9)),
	c(rep(0,24),rep(1,9)),
	c(rep(1,15),rep(0,18)),
	c(rep(0,16),rep(1,15),rep(0,2)),
	c(rep(0,8),rep(1,15),rep(0,10)))))
timesB <- as.vector(t(rbind(c(rep(0,8),ctimes[1,1:15],rep(0,10)),
	c(rep(0,16),ctimes[1,1:15],rep(0,2)),
	c(ctimes[1,1:15],rep(0,18)),
	c(rep(0,24),ctimes[1,1:9]),
	c(rep(0,24),ctimes[1,1:9]),
	c(ctimes[1,1:15],rep(0,18)),
	c(rep(0,16),ctimes[1,1:15],rep(0,2)),
	c(rep(0,8),ctimes[1,1:15],rep(0,10)))))
trtC <- as.vector(t(rbind(c(rep(0,16),rep(1,15),rep(0,2)),
	c(rep(0,8),rep(1,15),rep(0,10)),
	c(rep(0,24),rep(1,9)),
	c(rep(1,15),rep(0,18)),
	c(rep(1,15),rep(0,18)),
	c(rep(0,24),rep(1,9)),
	c(rep(0,8),rep(1,15),rep(0,10)),
	c(rep(0,16),rep(1,15),rep(0,2)))))
timesC <- as.vector(t(rbind(c(rep(0,16),ctimes[1,1:15],rep(0,2)),
	c(rep(0,8),ctimes[1,1:15],rep(0,10)),
	c(rep(0,24),ctimes[1,1:9]),
	c(ctimes[1,1:15],rep(0,18)),
	c(ctimes[1,1:15],rep(0,18)),
	c(rep(0,24),ctimes[1,1:9]),
	c(rep(0,8),ctimes[1,1:15],rep(0,10)),
	c(rep(0,16),ctimes[1,1:15],rep(0,2)))))
trtD <- as.vector(t(rbind(c(rep(0,24),rep(1,9)),
	c(rep(1,15),rep(0,18)),
	c(rep(0,8),rep(1,15),rep(0,10)),
	c(rep(0,16),rep(1,15),rep(0,2)),
	c(rep(0,16),rep(1,15),rep(0,2)),
	c(rep(0,8),rep(1,15),rep(0,10)),
	c(rep(1,15),rep(0,18)),
	c(rep(0,24),rep(1,9)))))
timesD <- as.vector(t(rbind(c(rep(0,24),ctimes[1,1:9]),
	c(ctimes[1,1:15],rep(0,18)),
	c(rep(0,8),ctimes[1,1:15],rep(0,10)),
	c(rep(0,16),ctimes[1,1:15],rep(0,2)),
	c(rep(0,16),ctimes[1,1:15],rep(0,2)),
	c(rep(0,8),ctimes[1,1:15],rep(0,10)),
	c(ctimes[1,1:15],rep(0,18)),
	c(rep(0,24),ctimes[1,1:9]))))

if(interactive()){
main <- c("ABCD (Subjects 1 and 4)","BDAC (Subjects 2 and 3)",
	"CADB (Subjects 2 and 3)","DCBA (Subjects 1 and 4)")
ylab <- c(expression(paste("Propoxyphene (",mu,"g/l)")),"",
	expression(paste("Propoxyphene (",mu,"g/l)")),"")
xlab <- c("","","Hours","Hours")
ind <- c(1,3,5,7)
postscript("propoxpr.eps")
par(mfrow=c(2,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(respc,nind=c(1,8),main=main[1],ylim=c(0,260),lty=c(1,4),
	xlab=xlab[1],ylab=ylab[1])
legend(60,250,legend=c("1","4"),lty=c(1,4),bty="n")
plot(respc,nind=c(3,6),main=main[2],ylim=c(0,260),lty=c(2,3),
	xlab=xlab[2],ylab=ylab[2])
legend(60,250,legend=c("2","3"),lty=2:3,bty="n")
plot(respc,nind=c(4,5),main=main[3],ylim=c(0,260),lty=c(2,3),
	xlab=xlab[3],ylab=ylab[3])
plot(respc,nind=c(2,7),main=main[4],ylim=c(0,260),lty=c(1,4),
	xlab=xlab[4],ylab=ylab[4])
dev.off()
}

mua <- function(p){
	kaA <- exp(p[2])
	kaB <- exp(p[4])
	kaC <- exp(p[5])
	kaD <- exp(p[6])
	ke <- exp(p[3])
	trtA*kaA/(exp(p[1])*(kaA-ke))*(exp(-ke*timesA)-exp(-kaA*timesA))+
	trtB*kaB/(exp(p[1])*(kaB-ke))*(exp(-ke*timesB)-exp(-kaB*timesB))+
	trtC*kaC/(exp(p[1])*(kaC-ke))*(exp(-ke*timesC)-exp(-kaC*timesC))+
	trtD*kaD/(exp(p[1])*(kaD-ke))*(exp(-ke*timesD)-exp(-kaD*timesD))}

print(zan <- gar(respc,"normal",mu=mua,preg=c(-5,-1,-1.1,-1,1,-1),
	pdep=0.6,psh=30))
print(zag <- gar(respc,"gamma",mu=mua,
	preg=c(-4.8,-1,-2.3,-1,2.4,1.4),pdep=0.1,psh=2.5))
print(zaw <- gar(respc,"Weibull",mu=mua,
	preg=c(-5.6,-1,-1.1,-1,1,-1),pdep=0.6,psh=0.5))
print(zaln <- gar(respc,"normal",mu=mua,
	trans="log",link="exp",preg=c(-5.6,-1,-1.1,-1,1,-1),pdep=0.6,psh=3.5))
print(zall <- gar(respc,"logistic",mu=mua,
	trans="log",link="exp",preg=c(-5.6,-1,-1.1,-1,1,-1),pdep=0.6,psh=3.5))
print(zalc <- gar(respc,"Cauchy",mu=mua,
	trans="log",link="exp",preg=c(-5.6,-1,-1.1,-1,1,-1),pdep=0.6,psh=3.5))

muai <- function(p){
	kaA <- exp(p[2])
	kaB <- exp(p[4])
	kaD <- exp(p[5])
	keA <- keB <- keC <- keD <- exp(p[3])
	trtA*kaA/(exp(p[1])*(kaA-keA))*(exp(-keA*timesA)-exp(-kaA*timesA))+
	trtB*kaB/(exp(p[1])*(kaB-keB))*(exp(-keB*timesB)-exp(-kaB*timesB))+
	trtC*(((1-exp(-keC*timesC))*(timesC<=(1/12))+(1-exp(-keC/12))*exp(-keC*timesC-1/12)*(timesC>(1/12)))/(exp(p[6])*keC))+
	trtD*kaD/(exp(p[1])*(kaD-keD))*(exp(-keD*timesD)-exp(-kaD*timesD))}

print(zain <- gar(respc,"normal",mu=muai,iter=200,
	preg=c(-4.85,-0.24,-1.74,-0.5,1.37,-1),pdep=0.65,psh=35))
print(zaig <- gar(respc,"gamma",mu=muai,iter=200,
	preg=c(-4.85,-0.24,-1.74,-0.5,1.37,-1),pdep=0.65,psh=2))
print(zaiw <- gar(respc,"Weibull",mu=muai,iter=200,
	preg=c(-4.64,-0.63,-2.26,-1,1.83,-7.13),pdep=0.65,psh=0.5))
print(zailn <- gar(respc,"normal",mu=muai,iter=200,trans="log",link="exp",
	preg=c(-4.64,-0.63,-2.26,-1,1.83,-7.13),pdep=0.65,psh=3.5))
print(zaill <- gar(respc,"logistic",mu=muai,iter=200,trans="log",link="exp",
	preg=c(-4.64,-0.63,-2.26,-1,1.83,-7.13),pdep=0.65,psh=2))
print(zailc <- gar(respc,"Cauchy",mu=muai,iter=200,trans="log",link="exp",
	preg=c(-4.64,-0.63,-2.26,-1,1.83,-7.13),pdep=0.65,psh=2))

muaiv <- function(p){
	kaA <- exp(p[2])
	kaB <- exp(p[4])
	kaD <- exp(p[5])
	keA <- keB <- keC <- keD <- exp(p[3])
	p[7]+
	trtA*kaA/(exp(p[1])*(kaA-keA))*(exp(-keA*timesA)-exp(-kaA*timesA))+
	trtB*kaB/(exp(p[1])*(kaB-keB))*(exp(-keB*timesB)-exp(-kaB*timesB))+
	trtC*(((1-exp(-keC*timesC))*(timesC<=(1/12))+(1-exp(-keC/12))*exp(-keC*timesC-1/12)*(timesC>(1/12)))/(exp(p[6])*keC))+
	trtD*kaD/(exp(p[1])*(kaD-keD))*(exp(-keD*timesD)-exp(-kaD*timesD))}
muaiv2 <- function(p){
	kaA <- exp(p[2])
	kaB <- exp(p[4])
	kaD <- exp(p[5])
	keA <- keB <- keC <- keD <- exp(p[3])
	(p[7]+
	trtA*kaA/(exp(p[1])*(kaA-keA))*(exp(-keA*timesA)-exp(-kaA*timesA))+
	trtB*kaB/(exp(p[1])*(kaB-keB))*(exp(-keB*timesB)-exp(-kaB*timesB))+
	trtC*(((1-exp(-keC*timesC))*(timesC<=(1/12))+(1-exp(-keC/12))*exp(-keC*timesC-1/12)*(timesC>(1/12)))/(exp(p[6])*keC))+
	trtD*kaD/(exp(p[1])*(kaD-keD))*(exp(-keD*timesD)-exp(-kaD*timesD)))^2}

# function of standard deviation as in the book (gar changed afterwards)
print(zaivn <- gar(respc,"normal",
	mu=muai,iter=200,preg=c(-4.56,-0.28,-2.15,-0.5,1.57,-7),shape=muaiv2,
	pdep=0.65,psh=c(-4,0.012,-1,-0.67,2,-6.4,7)))
# function of the variance yields worse fit than in book
print(zaivn2 <- gar(respc,"normal",
	mu=muai,iter=200,preg=c(-4.56,-0.28,-2.15,-0.5,1.57,-7),shape=muaiv,
	pdep=0.65,psh=c(-4,0.012,-1,-0.67,2,-6,7)))
print(zaivg <- gar(respc,"gamma",mu=muai,iter=200,shape=muaiv,
	preg=c(-4.74,-0.73,-1.37,-0.87,1.48,-6.86),pdep=0.8,
	psh=c(-1.94,-2.28,-3.06,-1.38,1.04,-3.82,-0.007)))
print(zaivw <- gar(respc,"Weibull",mu=muai,iter=200,shape=muaiv,
	preg=c(-4.65,-0.58,-1.45,-0.97,1.36,-6.97),pdep=0.8,
	psh=c(-1.1,-2.1,-2.6,-1.5,0.2,-2.6,0.6)))
# function of standard deviation as in the book
print(zaivln <- gar(respc,"normal",
	mu=muai,iter=200,trans="log",link="exp",shape=muaiv2,
	preg=c(3,-0.35,,-2.2,-0.3,1.2,3),pdep=0.8,
	psh=c(-4.5,-0.4,4,-0.6,0.1,-4.8,0.4)))
# function of the variance yields better fit than in book
print(zaivln2 <- gar(respc,"normal",
	mu=muai,iter=200,trans="log",link="exp",shape=muaiv,
	preg=c(3,-0.35,,-2.2,-0.3,1.2,3),pdep=0.8,
	psh=c(-4.5,-0.4,4,-0.6,0.1,-4.8,0.4)))
print(zaivll <- gar(respc,"logistic",
	mu=muai,iter=200,trans="log",link="exp",shape=muaiv,
	preg=c(3,-0.35,,-2.2,-0.3,1.2,3),pdep=0.8,
	psh=c(-3.2,-0.3,3.6,-0.4,0.5,-4,0.2)))
print(zaivlc <- gar(respc,"Cauchy",
	mu=muai,iter=200,trans="log",link="exp",shape=muaiv,
	preg=c(3,-0.35,,-2.2,-0.3,1.2,3),pdep=0.8,
	psh=c(-0.5,0.1,1,-0.26,3,-2.3,0.2)))

muai2a <- function(p){
	kaA <- kaB <- exp(p[2])
	kaD <- exp(p[4])
	keA <- keB <- keC <- keD <- exp(p[3])
	trtA*kaA/(exp(p[1])*(kaA-keA))*(exp(-keA*timesA)-exp(-kaA*timesA))+
	trtB*kaB/(exp(p[1])*(kaB-keB))*(exp(-keB*timesB)-exp(-kaB*timesB))+
	trtC*(((1-exp(-keC*timesC))*(timesC<=(1/12))+(1-exp(-keC/12))*exp(-keC*timesC-1/12)*(timesC>(1/12)))/(exp(p[5])*keC))+
	trtD*kaD/(exp(p[1])*(kaD-keD))*(exp(-keD*timesD)-exp(-kaD*timesD))}

# function of standard deviation as in the book
print(zaiv2n <- gar(respc,"normal",
	mu=muai2a,iter=200,preg=c(-4.56,-0.28,-2.15,1.57,-7),shape=muaiv2,
	pdep=0.65,psh=c(-4,0.012,-1,-0.67,2,-6.4,7)))
# function of the variance yields worse fit than in book
print(zaiv2n2 <- gar(respc,"normal",
	mu=muai2a,iter=200,preg=c(-4.56,-0.28,-2.15,1.57,-7),shape=muaiv,
	pdep=0.65,psh=c(-4,0.012,-1,-0.67,2,-6,7)))
print(zaiv2g <- gar(respc,"gamma",mu=muai2a,iter=200,shape=muaiv,
	preg=c(-4.74,-0.73,-1.37,1.48,-6.86),pdep=0.8,
	psh=c(-1.94,-2.28,-3.06,-1.38,1.04,-3.82,-0.007)))

if(interactive()){
muai2ap <- function(p){
	kaA <- kaB <- exp(p[2])
	kaD <- exp(p[4])
	keA <- keB <- keC <- keD <- exp(p[3])
	trtAp*kaA/(exp(p[1])*(kaA-keA))*(exp(-keA*timesAp)-exp(-kaA*timesAp))+
	trtBp*kaB/(exp(p[1])*(kaB-keB))*(exp(-keB*timesBp)-exp(-kaB*timesBp))+
	trtCp*(((1-exp(-keC*timesCp))*(timesCp<=(1/12))+(1-exp(-keC/12))*exp(-keC*timesCp-1/12)*(timesCp>(1/12)))/(exp(p[5])*keC))+
	trtDp*kaD/(exp(p[1])*(kaD-keD))*(exp(-keD*timesDp)-exp(-kaD*timesDp))}
ptime <- seq(0.01,96,by=1)
trtAp <- as.vector(t(rbind(c(rep(1,30),rep(0,18)),
	c(rep(0,72),rep(1,24)),
	c(rep(0,48),rep(1,30),rep(0,18)),
	c(rep(0,24),rep(1,30),rep(0,42)),
	c(rep(0,24),rep(1,30),rep(0,42)),
	c(rep(0,48),rep(1,30),rep(0,18)),
	c(rep(0,72),rep(1,24)),
	c(rep(1,30),rep(0,18)))))
trtBp <- as.vector(t(rbind(c(rep(0,24),rep(1,30),rep(0,42)),
	c(rep(0,48),rep(1,30),rep(0,18)),
	c(rep(1,30),rep(0,18)),
	c(rep(0,72),rep(1,24)),
	c(rep(0,72),rep(1,24)),
	c(rep(1,30),rep(0,18)),
	c(rep(0,48),rep(1,30),rep(0,18)),
	c(rep(0,24),rep(1,30),rep(0,42)))))
trtCp <- as.vector(t(rbind(c(rep(0,48),rep(1,30),rep(0,18)),
	c(rep(0,24),rep(1,30),rep(0,42)),
	c(rep(0,72),rep(1,24)),
	c(rep(1,30),rep(0,18)),
	c(rep(1,30),rep(0,18)),
	c(rep(0,72),rep(1,24)),
	c(rep(0,24),rep(1,30),rep(0,42)),
	c(rep(0,48),rep(1,30),rep(0,18)))))
trtDp <- as.vector(t(rbind(c(rep(0,72),rep(1,24)),
	c(rep(1,30),rep(0,18)),
	c(rep(0,24),rep(1,30),rep(0,42)),
	c(rep(0,48),rep(1,30),rep(0,18)),
	c(rep(0,48),rep(1,30),rep(0,18)),
	c(rep(0,24),rep(1,30),rep(0,42)),
	c(rep(1,30),rep(0,18)),
	c(rep(0,72),rep(1,24)))))
timesAp <- as.vector(t(rbind(c(ptime[1:30],rep(0,66)),
	c(rep(0,72),ptime[1:24]),
	c(rep(0,48),ptime[1:30],rep(0,18)),
	c(rep(0,24),ptime[1:30],rep(0,42)),
	c(rep(0,24),ptime[1:30],rep(0,42)),
	c(rep(0,48),ptime[1:30],rep(0,18)),
	c(rep(0,72),ptime[1:24]),
	c(ptime[1:30],rep(0,66)))))
timesBp <- as.vector(t(rbind(c(rep(0,24),ptime[1:30],rep(0,42)),
	c(rep(0,48),ptime[1:30],rep(0,18)),
	c(ptime[1:30],rep(0,66)),
	c(rep(0,72),ptime[1:24]),
	c(rep(0,72),ptime[1:24]),
	c(ptime[1:30],rep(0,66)),
	c(rep(0,48),ptime[1:30],rep(0,18)),
	c(rep(0,24),ptime[1:30],rep(0,42)))))
timesCp <- as.vector(t(rbind(c(rep(0,48),ptime[1:30],rep(0,18)),
	c(rep(0,24),ptime[1:30],rep(0,42)),
	c(rep(0,72),ptime[1:24]),
	c(ptime[1:30],rep(0,66)),
	c(ptime[1:30],rep(0,66)),
	c(rep(0,72),ptime[1:24]),
	c(rep(0,24),ptime[1:30],rep(0,42)),
	c(rep(0,48),ptime[1:30],rep(0,18)))))
timesDp <- as.vector(t(rbind(c(rep(0,72),ptime[1:24]),
	c(ptime[1:30],rep(0,66)),
	c(rep(0,24),ptime[1:30],rep(0,42)),
	c(rep(0,48),ptime[1:30],rep(0,18)),
	c(rep(0,48),ptime[1:30],rep(0,18)),
	c(rep(0,24),ptime[1:30],rep(0,42)),
	c(ptime[1:30],rep(0,66)),
	c(rep(0,72),ptime[1:24]))))
main <- c("ABCD (Subject 1)","BDAC (Subject 2)",
	"CADB (Subject 3)","DCBA (Subject 4)")
ylab <- c(expression(paste("Propoxyphene (",mu,"g/l)")),"",
	expression(paste("Propoxyphene (",mu,"g/l)")),"")
xlab <- c("","","Hours","Hours")
ind <- c(1,3,5,7)
postscript("propox.eps")
par(mfrow=c(2,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
for(i in 1:4){
	plot(ptime,muai2ap(zaiv2g$coef)[(1:96)+(ind[i]-1)*96],
		main=main[i],ylim=c(0,260),type="l",xlab=xlab[i],ylab=ylab[i])
	if(i==1){
		legend(10,250,legend=c("Underlying profile",
		"Predicted individual profile"),lty=c(1,2),bty="n")
		legend(13,265,legend="Observed",pch=1,bty="n")}
	plot(iprofile(zaiv2g),nind=ind[i],pch=1,lty=2,add=T)}
dev.off()

muai2ap2 <- function(p){
	kaA <- kaB <- exp(p[1])
	kaD <- exp(p[2])
	keA <- keB <- keC <- keD <- exp(j)
	trtA*kaA/(exp(i)*(kaA-keA))*(exp(-keA*timesA)-exp(-kaA*timesA))+
	trtB*kaB/(exp(i)*(kaB-keB))*(exp(-keB*timesB)-exp(-kaB*timesB))+
	trtC*(((1-exp(-keC*timesC))*(timesC<=(1/12))+(1-exp(-keC/12))*exp(-keC*timesC-1/12)*(timesC>(1/12)))/(exp(p[3])*keC))+
	trtD*kaD/(exp(i)*(kaD-keD))*(exp(-keD*timesD)-exp(-kaD*timesD))}
xx <- seq(-5.1,-4.6,by=0.05)
yy <- seq(-2.55,-2.05,by=0.05)
z <- like <- NULL
for(j in yy){
	for(i in xx){
		z$coef <- c(-0.55,1.55,-7.14,0.11,-2.14,-1.98,-2.81,
			-1.36,0.86,-4.17,-0.012)
		like <- c(like,(z <- gar(respc,"gamma",mu=muai2ap2,
			shape=muaiv,preg=z$coef[1:3],pdep=0.85,
			psh=z$coef[5:11],iter=20))$maxlike)
		print(c(i,j,like[length(like)],z$code,z$iter))}}
like <- matrix(like,nrow=length(xx))
dimnames(like) <- list(xx,yy)

postscript("propoxco.eps",height=5)
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
contour(exp(xx),exp(yy),exp(-like+min(like)),levels=seq(0.1,0.9,by=0.1),
	labcex=0.6)
title(xlab="V",ylab=expression(k[e]))
par(mar=c(0,1,0,0))
persp(exp(xx),exp(yy),exp(-like+min(like)),phi=25,theta=-45,r=20,
	xlab="V",ylab="ke",zlab="",tick="detail",cex=0.7)
dev.off()
}
