options(contrasts = c("contr.sum", "contr.poly"))

library(gnlm)
library(repeated)

# parent drug

fq1 <- read.table("flos.dat",header=T)
attach(fq1)
tconcp <- cbind(matrix(ifelse(conc>0,conc,0.04),ncol=12,byrow=T),
	matrix(NA,ncol=4,nrow=54))
censorp <- ifelse(tconcp==0.04,-1,1)
yp <- restovec(tconcp,censor=censorp,
	times=c(ifelse(time==0,0.01,time)[1:12],36,48,72,96),delta=0.01)

# metabolite

fq2 <- read.table("metaba.dat",header=T)
attach(fq2)
conc[conc==99] <- NA
tconcm <- matrix(conc,ncol=16,byrow=T)
tm <- ifelse(time==0,0.01,time)[1:16]
censorm <- ifelse(tconcm==0.1,-1,1)
ym <- restovec(tconcm,censor=censorm,times=tm,delta=0.01)

y <- restovec(rbind(tconcp,tconcm),censor=rbind(censorp,censorm),
	times=tm,delta=0.01)

# covariates

fq3 <- read.table("floscov.dat",skip=9)[,-c(1:2,6,14:17)]
names(fq3) <- c("sex","age","height","weight","creatinine","bilirubin",
	"alkphos","alt","ast","gammagt")
fq3 <- fq3[seq(3,54,by=3),]
fq3[,1] <- as.numeric(fq3[,1]!="M")
attach(fq3)
cc <- ifelse(sex==0,1.04,1.23)*(140-age)*weight/creatinine
bmi <- weight/height^2
fq3 <- cbind(fq3,cc,bmi)
dose <- rep(c(rep(50,18),rep(100,18),rep(150,18)),2)
ind <- c(rep(1,54),rep(0,54))
subject <- codes(gl(18,1,108))

covarp <- tcctomat(cbind(rbind(fq3,fq3,fq3,fq3,fq3,fq3),dose,subject)[1:54,])
covar <- tcctomat(cbind(rbind(fq3,fq3,fq3,fq3,fq3,fq3),dose,ind))

repsp <- rmna(yp,ccov=covarp)
repsm <- rmna(ym,ccov=covarp)
reps <- rmna(y,ccov=covar)

# Model 1

# independence, fixed effect for volume
mu <- function(p) exp(p[1]-p[3])*dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times))
mul <- function(p,linear) exp(p[1]-linear)*dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times))
shape <- function(p) p[4]*(p[1]-p[3]+log(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times))))
print(zg1fp <- gnlr(repsp,"gamma",pmu=c(1.43,-0.73,4.1,0.34,0.19,0.42,0.66,
	1.02,-0.031,0.53,0.19,-0.35,0.49,-0.44,-1.31,-0.4,0.066,-0.6,-0.35,
	0.35),psh=c(-0.85,-0.84,2.37,1.88),mu=mul,linear=~as.factor(subject),
	shape=shape,iter=200))
print(zg1fm <- gnlr(repsm,"gamma",pmu=c(-0.28,-3.8,3.84,rep(0,17)),
	psh=c(-3.5,-2.97,-1.4,0.68),mu=mul,linear=~as.factor(subject),
	shape=shape))
zg1fp$aic+zg1fm$aic

# tracking
shape2 <- function(p) exp(p[4]*(p[1]-p[3]+log(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times)))))
print(ugg3p <- gar(repsp,dist="gen gamma",mu=mu,shape=shape2,
	preg=c(0.68,-0.79,3.77),pdep=0.4,psh=c(-0.79,-0.6,2.4,1.8,1)))
print(ugg3m <- gar(repsm,dist="gen gamma",mu=mu,shape=shape2,
	preg=c(-0.4,-3.8,3.7),pdep=0.97,psh=c(-1.9,-4.5,1.44,1.2,1.8)))
ugg3p$aic+ugg3m$aic

if(interactive()){
postscript("flosres.eps",horizontal=F,height=5)
par(mfrow=c(1,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(iprofile(ugg3p),nind=c(46,52),ylim=c(0,4.5),pch=c(1,20),lty=2:3,
	xlab="Hours",ylab=expression(paste("Concentration (",mu,"g/ml)")),
	main="Flosequinan")
plot(mprofile(ugg3p),nind=46,add=T)
legend(5,4.5,legend=c("Compartment model","Subject 10","Subject 16"),
	pch=c(30,1,20),lty=c(1:3),bty="n")
plot(iprofile(ugg3m),nind=c(46,52),ylim=c(0,4.5),pch=c(1,20),lty=2:3,
	xlab="Hours",ylab="",main="Metabolite")
plot(mprofile(ugg3m),nind=46,add=T)
dev.off()
}

# Model 3

#independence
muj4cov7ia <- function(p) {
	ka <- exp(p[1]+p[7]*sex+p[8]*bilirubin+p[9]*cc+p[10]*ast)
	kf <- exp(p[5]+p[12]*age+p[13]*sex+p[14]*alt  # = ke
		+p[15]*bilirubin+p[16]*cc+p[17]*gammagt)
	kma <- exp(p[3])
	kme <- exp(p[4]+p[18]*sex+p[19]*alkphos+p[20]*bilirubin+p[21]*gammagt)
	e8 <- exp(p[6]+p[22]*sex)
	dose*exp(-p[2]-p[11]*alt)*
	(ind*ka*(exp(-kf*times)-exp(-ka*times))/(ka-kf)*e8/(1+e8)+
	(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/(kma-kme)/(1+e8)+
	kf*(exp(-ka*times)/(ka-kme)-exp(-kf*times)/(kf-kme)+
	(1/(kf-kme)-1/(ka-kme))*exp(-kme*times))/(ka-kf)*e8/(1+e8)))}
shapej1 <- function(p) {
	ka <- exp(p[1])
	ke <- exp(p[2])
	kme <- exp(p[5])
	p[6]*(p[1]+p[3]+log(dose)+log(ind*(ka*times*exp(-ka*times))+
	(1-ind)*exp(p[4])/(ka-ke)*(exp(-ka*times)/(ka-kme)-
	exp(-ke*times)/(ke-kme)+(1/(ke-kme)-1/(ka-kme))*exp(-kme*times))))}
print(zg4jcov7ia <- gnlr(reps,"gamma",pmu=c(-1.59,3.48,-0.0049,-3.96,-0.62,
	0.12,-1.75,0.048,0.02,0.12,-0.012,0.028,-0.54,-0.0097,0.051,
	-0.0065,-0.03,0.099,0.00068,0.011,-0.0048,0.45),
	psh=c(-0.62,-1.45,-1.2,0.025,-3.94,0.92),
	mu=muj4cov7ia,shape=shapej1,iter=200))

# tracking
shapej1a <- function(p) {
	ka <- exp(p[1])
	ke <- exp(p[2])
	kme <- exp(p[5])
	exp(p[6]*(p[1]+p[3]+log(dose)+log(ind*(ka*times*exp(-ka*times))+
	(1-ind)*exp(p[4])/(ka-ke)*(exp(-ka*times)/(ka-kme)-
	exp(-ke*times)/(ke-kme)+(1/(ke-kme)-1/(ka-kme))*exp(-kme*times)))))}
print(zgar4jcov7ia <- gar(reps,"gamma",preg=c(-0.19,3.42,-0.004,-4.01,-1.37,
	0.16,-1.95,0.035,0.014,0.083,-0.0092,0.017,-0.24,-0.029,-0.0079,
	0.005,-0.026,0.11,0.00039,0.014,-0.0013,0.77),
	psh=c(-1.48,0.0042,0.17,0.19,-3.49,1.07),
	mu=muj4cov7ia,shape=shapej1a,pdep=0.74,iter=200))
print(zgar4jcov7ia2 <- gar(reps,"gamma",preg=c(1.13,3.37,-0.0012,-3.99,-1.06,
	0.07,-1.01,0.0074,-0.0017,0.069,0.00018,0.02,-0.22,-0.0083,0.0011,
	0.0012,-0.028,0.078,0.00059,0.016,-0.0053,0.96),
	psh=c(-1.39,0.0042,0.077,0.11,-4.06,1.1),
	mu=muj4cov7ia,shape=shapej1a,pdep=c(-0.03,-0.38),depend=~ind,iter=200))
muj4cov15ia <- function(p) {
	ka <- exp(p[1]+p[7]*sex+p[8]*ast)
	kf <- exp(p[5]+p[9]*age+p[10]*sex+p[11]*gammagt)  # = ke
	kma <- exp(p[3])
	kme <- exp(p[4]+p[12]*sex+p[13]*bilirubin)
	e8 <- exp(p[6]+p[14]*sex)
	dose*exp(-p[2])*
	(ind*ka*(exp(-kf*times)-exp(-ka*times))/(ka-kf)*e8/(1+e8)+
	(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/(kma-kme)/(1+e8)+
	kf*(exp(-ka*times)/(ka-kme)-exp(-kf*times)/(kf-kme)+
	(1/(kf-kme)-1/(ka-kme))*exp(-kme*times))/(ka-kf)*e8/(1+e8)))}
print(zgar4jcov15iar <- gar(reps,"gamma",preg=c(0.97,3.37,-0.0025,-3.99,-0.94,
	0.055,-1.06,0.064,0.019,-0.21,-0.028,0.081,0.017,0.99),
	psh=c(-1.38,0.0042,0.067,0.12,-4.05,1.1),
	mu=muj4cov15ia,shape=shapej1a,pdep=c(-0.03,-0.39),depend=~ind))

print(zggar4jcov15iar <- gar(reps,"gen gamma",preg=c(1.32,3.3,-0.0022,-3.99,
	-0.96,0.044,-1.08,0.045,0.013,-0.12,-0.024,0.08,0.016,0.84),
	psh=c(-1.58,0.0043,0.024,-0.043,-4.07,1,1.42),mu=muj4cov15ia,
	shape=shapej1a,pdep=c(-0.029,-0.37),depend=~ind,iter=200))

if(interactive()){
postscript("jointdm4.eps",horizontal=F,height=8)
par(mfrow=c(2,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(mprofile(zggar4jcov15iar),nind=c(46,52),ylim=c(0,5),lty=c(1,4),
	xlim=c(0,12),ylab=expression(paste("Concentration (",mu,"g/ml)")),
	xlab="",main="Flosequinan")
plot(iprofile(zggar4jcov15iar),nind=c(46,52),pch=c(1,20),lty=2:3,add=T)
legend(5,5,legend=c("Compartment model","Subject 10","Subject 16","Tracking",
	"Subject 10","Subject 16"),
	pch=c(30,30,30,30,1,20),lty=c(0,1,4,0,2,3),bty="n")
plot(mprofile(zggar4jcov15iar),nind=c(100,106),ylim=c(0,5),lty=c(1,4),
	pch=c(1,20),ylab="",xlab="",main="Metabolite")
plot(iprofile(zggar4jcov15iar),nind=c(100,106),pch=c(1,20),lty=2:3,add=T)

plot(mprofile(zggar4jcov15iar),nind=c(38,44),ylim=c(0,5),lty=c(4,1),
	xlim=c(0,12),ylab=expression(paste("Concentration (",mu,"g/ml)")),
	xlab="Hours")
plot(iprofile(zggar4jcov15iar),nind=c(38,44),pch=c(1,20),lty=c(3,2),add=T)
legend(5,5,legend=c("Compartment model","Subject 2","Subject 8","Tracking",
	"Subject 2","Subject 8"),pch=c(30,30,30,30,1,20),
	lty=c(0,1,4,0,2,3),bty="n")
plot(mprofile(zggar4jcov15iar),nind=c(92,98),ylim=c(0,5),lty=c(4,1),
	pch=c(20,1),ylab="",xlab="Hours")
plot(iprofile(zggar4jcov15iar),nind=c(92,98),pch=c(20,1),lty=c(3,2),add=T)
dev.off()

muj4cov15iap <- function(p) {
	ka <- exp(p[1]+i*sex+p[7]*ast)
	kf <- exp(p[5]+p[8]*age+p[9]*sex+p[10]*gammagt)  # = ke
	kma <- exp(p[3])
	kme <- exp(p[4]+p[11]*sex+p[12]*bilirubin)
	e8 <- exp(p[6]+j*sex)
	dose*exp(-p[2])*
	(ind*ka*(exp(-kf*times)-exp(-ka*times))/(ka-kf)*e8/(1+e8)+
	(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/(kma-kme)/(1+e8)+
	kf*(exp(-ka*times)/(ka-kme)-exp(-kf*times)/(kf-kme)+
	(1/(kf-kme)-1/(ka-kme))*exp(-kme*times))/(ka-kf)*e8/(1+e8)))}
shapej1a <- function(p) {
	ka <- exp(p[1])
	ke <- exp(p[2])
	kme <- exp(p[5])
	exp(p[6]*(p[1]+p[3]))*(dose*(ind*(ka*times*exp(-ka*times))+
	(1-ind)*exp(p[4])/(ka-ke)*(exp(-ka*times)/(ka-kme)-exp(-ke*times)/
	(ke-kme)+(1/(ke-kme)-1/(ka-kme))*exp(-kme*times))))^p[6]}
xx <- seq(-1.7,-0.5,by=0.1)
yy <- seq(0.35,1.35,by=0.1)
z <- like <- NULL
for(j in yy){
	for(i in xx){
		z$coef <- c(1.32,3.3,-0.0022,-3.99,-0.96,0.044,0.045,0.013,
			-0.12,-0.024,0.08,0.016,-0.029,-0.37,-1.58,0.0043,
			0.024,-0.043,-4.07,1,1.42)
		like <- c(like,(z <- gar(reps,"gen gamma",preg=z$coef[1:12],
			psh=z$coef[15:21],mu=muj4cov15iap,shape=shapej1a,
			pdep=z$coef[13:14],depend=~ind,iter=50,
			stepmax=1))$maxlike)
		print(c(i,j,like[length(like)],z$code,z$iter))}}
like <- matrix(like,nrow=length(xx))
dimnames(like) <- list(xx,yy)

postscript("floscon.eps",height=5)
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
contour(exp(xx),exp(yy)[1:11],exp(-like+min(like))[,1:11],
	levels=seq(0.1,0.9,by=0.1))
title(xlab=expression(k[a]),ylab=expression(pi))
par(mar=c(0,0,0,0))
persp(exp(xx),exp(yy)[1:11],box=F,phi=25,exp(-like+min(like))[,1:11])
mtext(expression(k[a]),1,line=-4)
mtext(expression(pi),2,at=-0.2,line=-3)
dev.off()
}

print(zlnar4jcov15iar <- gar(reps,"normal",preg=c(0.7,3.98,-0.0021,-4.14,
	-0.67,0.033,-0.6,0.039,0.018,-0.3,-0.029,0.065,0.019,0.37),
	psh=c(-1.9,-3.99,0.059,-0.97,-0.43,-1.33),mu=muj4cov15ia,
	shape=shapej1a,pdep=c(-0.0091,0.056),depend=~ind,trans="log",
	link="exp",iter=200,stepmax=1))
