library(nlme)
options(contrasts = c("contr.sum", "contr.poly"))

# parent drug
fq1 <- read.table("flos.dat",header=T)
attach(fq1)
tconc <- matrix(conc,ncol=12,byrow=T)
tconc[,8:12] <- ifelse(tconc[,7:11]==0,NA,tconc[,8:12])
tconc <- as.vector(t(tconc))
tconc <-ifelse(tconc>0,tconc,0.02)
logconcp <- log(tconc)
tp <- ifelse(time==0,0.01,time)

# covariates
fqc <- read.table("floscov.dat",skip=9)
names(fqc) <- c("obs","vol","sex","age","height","race","weight","creatini",
        "bilirubin","alkphos","alt","ast","gammagt","period","day","mon","yr")
attach(fqc)

datap <- data.frame(tconc,logconcp,tp,dose,subj=as.factor(subj),
	weight=rep(rep(weight,rep(4,54)),length=648),
	sex=rep(rep(sex,rep(4,54)),length=648),
	age=as.factor(rep(rep(age,rep(4,54)),length=648)),
	bilirubin=rep(rep(bilirubin,rep(4,54)),length=648),
	alt=rep(rep(alt,rep(4,54)),length=648),
	ast=rep(rep(ast,rep(4,54)),length=648))
datap <- datap[!is.na(datap[,1]),]

# metabolite
fq2 <- read.table("metaba.dat",header=T)
attach(fq2)
conc <- ifelse(conc==0.1,0.05,conc)
conc[conc==99] <- NA
logconcm <- log(conc)
tm <- ifelse(time==0,0.01,time)
datam <- data.frame(conc,logconcm,tm,dose,subj=as.factor(subj),
	weight=rep(rep(weight[seq(3,54,by=3)],rep(16,18)),3),
	sex=as.factor(rep(rep(sex[seq(3,54,by=3)],rep(16,18)),3)),
	age=rep(rep(age[seq(3,54,by=3)],rep(16,18)),3),
	bilirubin=rep(rep(bilirubin[seq(3,54,by=3)],rep(16,18)),3),
	alt=rep(rep(alt[seq(3,54,by=3)],rep(16,18)),3),
	ast=rep(rep(ast[seq(3,54,by=3)],rep(16,18)),3))
datam <- datam[!is.na(datam[,1]),]

# Least squares
print(summary(resls <- nls(logconcp~p1-p3+log(dose/(exp(p1)-exp(p2))*
        (exp(-exp(p2)*tp)-exp(-exp(p1)*tp))),
	control=nls.control(minFactor=0.00001),
	data=datap,start=list(p1=1,p2=-1,p3=5),trace=F)))
-logLik(resls)-sum(log(0.01/tconc),na.rm=T)

#res1 <- nlme(logconcp~p2-p3+log(dose/(exp(p1)-exp(p2))*
#	(exp(-exp(p2)*tp)-exp(-exp(p1)*tp))),start=list(fixed=c(5,-2,0.1)),
#	fixed=list(p1+p2+p3~1),control=list(maxIter=100),
#	groups=~subj,data=datap,method="ML")
#res1$log-sum(log(0.01/tconc),na.rm=T)
print(summary(res2 <- nlme(logconcp~p2-p3+log(dose/(exp(p1)-exp(p2))*
	(exp(-exp(p2)*tp)-exp(-exp(p1)*tp))),start=list(fixed=c(5,-2,0.1)),
	fixed=list(p1+p2+p3~1),random=pdDiag(p1+p2+p3~1),
	groups=~subj,data=datap,method="ML")))
-res2$log-sum(log(0.01/tconc),na.rm=T)
print(summary(res2b <- nlme(logconcp~p2-p3+log(dose/(exp(p1)-exp(p2))*
	(exp(-exp(p2)*tp)-exp(-exp(p1)*tp))),start=list(fixed=c(5,-2,0.1)),
	fixed=list(p1+p2+p3~1),random=pdDiag(p3~1),
	groups=~subj,data=datap,method="ML")))
-res2b$log-sum(log(0.01/tconc),na.rm=T)
print(summary(res2f <- nlme(logconcp~p2-p3+log(dose/(exp(p1)-exp(p2))*
	(exp(-exp(p2)*tp)-exp(-exp(p1)*tp))),start=list(fixed=c(5,-2,0.1)),
	fixed=list(p1+p2+p3~1),random=pdDiag(p1+p2+p3~1),weights=varExp(2),
	groups=~subj,data=datap,method="ML")))
-res2f$log-sum(log(0.01/tconc),na.rm=T)
print(summary(res2bf <- nlme(logconcp~p2-p3+log(dose/(exp(p1)-exp(p2))*
	(exp(-exp(p2)*tp)-exp(-exp(p1)*tp))),
	start=list(fixed=c(0.84,-0.8,2.6)),
	fixed=list(p1+p2+p3~1),random=pdDiag(p3~1),weights=varExp(2),
	groups=~subj,data=datap,method="ML")))
-res2bf$log-sum(log(0.01/tconc),na.rm=T)

print(summary(res3 <- nlme(logconcp~p2-p3+log(dose/(exp(p1)-exp(p2))*
	(exp(-exp(p2)*tp)-exp(-exp(p1)*tp))),
	start=list(fixed=c(5,-2,0.1,0)),weights=varExp(2),
	fixed=list(p1+p2~1,p3~sex),random=pdDiag(p1+p2+p3~1),
	groups=~subj,data=datap,method="ML")))
-res3$log-sum(log(0.01/tconc),na.rm=T)
#res3a <- nlme(logconcp~p2+p3+p4*bilirubin+log(dose/(exp(p1)-exp(p2))*
#	(exp(-exp(p2)*tp)-exp(-exp(p1)*tp))),
#	start=list(fixed=c(5,-2,-0.1,0)),
#	fixed=list(p1+p2+p3+p4~1),random=pdDiag(p1+p2+p3~1),
#	groups=~subj,data=datap,method="ML")
#-res3a$log-sum(log(0.01/tconc),na.rm=T)
#res4 <- nlme(logconcp~p2+p3+log(dose/(exp(p1)-exp(p2))*
#	(exp(-exp(p2)*tp)-exp(-exp(p1)*tp))),
#	start=list(fixed=c(5,-2,-0.1,0,0)),weights=varExp(2),
#	fixed=list(p1+p2~1,p3~alt+bilirubin),random=pdDiag(p1+p2+p3~1),
#	groups=~subj,data=datap,method="ML")
#-res4$log-sum(log(0.01/tconc),na.rm=T)

# metabolite
print(summary(resmls <- nls(logconcm~p1-p3+log(dose/(exp(p1)-exp(p2))*
        (exp(-exp(p2)*tm)-exp(-exp(p1)*tm))),
	control=nls.control(minFactor=0.00001),
	data=datam,start=list(p1=0.5,p2=-4,p3=4),trace=F)))
-logLik(resmls)-sum(log(0.01/conc),na.rm=T)
print(summary(resmls <- nls(logconcm~p1-p3+p4*codes(sex)+
	log(dose/(exp(p1)-exp(p2))*(exp(-exp(p2)*tm)-exp(-exp(p1)*tm))),
	control=nls.control(minFactor=0.00001),
	data=datam,start=list(p1=0.5,p2=-4,p3=4,p4=0),trace=F)))

print(summary(resm2 <- nlme(logconcm~p2-p3+log(dose/(exp(p1)-exp(p2))*
	(exp(-exp(p2)*tm)-exp(-exp(p1)*tm))),start=list(fixed=c(0.5,-4,0.4)),
	fixed=list(p1+p2+p3~1),random=pdDiag(p1+p2+p3~1),
	groups=~subj,data=datam,method="ML")))
-resm2$log-sum(log(0.01/conc),na.rm=T)
print(summary(resm2b <- nlme(logconcm~p2-p3+log(dose/(exp(p1)-exp(p2))*
	(exp(-exp(p2)*tm)-exp(-exp(p1)*tm))),start=list(fixed=c(0.5,-4,0.4)),
	fixed=list(p1+p2+p3~1),random=pdDiag(p3~1),
	groups=~subj,data=datam,method="ML")))
-resm2b$log-sum(log(0.01/conc),na.rm=T)
print(summary(resm2f <- nlme(logconcm~p2-p3+log(dose/(exp(p1)-exp(p2))*
	(exp(-exp(p2)*tm)-exp(-exp(p1)*tm))),start=list(fixed=c(0.5,-4,0.4)),
	fixed=list(p1+p2+p3~1),random=pdDiag(p1+p2+p3~1),weights=varExp(2),
	control=list(nlmStepMax=1),groups=~subj,data=datam,method="ML")))
-resm2f$log-sum(log(0.01/conc),na.rm=T)
print(summary(resm2f2 <- nlme(logconcm~p2-p3+log(dose/(exp(p1)-exp(p2))*
	(exp(-exp(p2)*tm)-exp(-exp(p1)*tm))),start=list(fixed=c(0.5,-4,0.4)),
	fixed=list(p1+p2+p3~1),random=pdDiag(p1+p2~1),weights=varExp(2),
	control=list(nlmStepMax=1),groups=~subj,data=datam,method="ML")))
-resm2f2$log-sum(log(0.01/conc),na.rm=T)
print(summary(resm2bf <- nlme(logconcm~p2-p3+log(dose/(exp(p1)-exp(p2))*
	(exp(-exp(p2)*tm)-exp(-exp(p1)*tm))),start=list(fixed=c(-0.3,-5,0)),
	fixed=list(p1+p2+p3~1),random=pdDiag(p3~1),weights=varExp(2),
	groups=~subj,data=datam,method="ML")))
-resm2bf$log-sum(log(0.01/conc),na.rm=T)

print(summary(resm3 <- nlme(logconcm~p2-p3+log(dose/(exp(p1)-exp(p2))*
	(exp(-exp(p2)*tm)-exp(-exp(p1)*tm))),control=list(nlmStepMax=1),
	start=list(fixed=c(-0.3,-4,0.4,0.2)),weights=varExp(2),
	fixed=list(p1+p2~1,p3~sex),random=pdDiag(p1+p2+p3~1),
	groups=~subj,data=datam,method="ML")))
-resm3$log-sum(log(0.01/conc),na.rm=T)
