options(contrasts = c("contr.sum", "contr.poly"))

library(gnlm)
library(repeated)

# parent drug

fq1 <- read.table("flos.dat",header=T)
attach(fq1)
tconcp <- cbind(matrix(ifelse(conc>0,conc,0.04),ncol=12,byrow=T),
	matrix(NA,ncol=4,nrow=54))
censorp <- ifelse(tconcp==0.04,-1,1)
yp <- restovec(tconcp,censor=censorp,name="yp",
	times=c(ifelse(time==0,0.01,time)[1:12],36,48,72,96),delta=0.01)
yp <- transform(yp,lyp=log(yp))

# metabolite

fq2 <- read.table("metaba.dat",header=T)
attach(fq2)
conc[conc==99] <- NA
tconcm <- matrix(conc,ncol=16,byrow=T)
tm <- ifelse(time==0,0.01,time)[1:16]
censorm <- ifelse(tconcm==0.1,-1,1)
ym <- restovec(tconcm,censor=censorm,times=tm,delta=0.01,name="ym")
ym <- transform(ym,lym=log(ym))

y <- restovec(rbind(tconcp,tconcm),censor=rbind(censorp,censorm),
	times=tm,delta=0.01,name="y")
y <- transform(y,ly=log(y))

# covariates

fq3 <- read.table("floscov.dat",skip=9)[,-c(1:2,6,14:17)]
names(fq3) <- c("sex","age","height","weight","creatinine","bilirubin",
	"alkphos","alt","ast","gammagt")
fq3 <- fq3[seq(3,54,by=3),]
fq3[,1] <- as.numeric(fq3[,1]!="M")
attach(fq3)
cc <- ifelse(sex==0,1.04,1.23)*(140-age)*weight/creatinine
bmi <- weight/height^2
fq3 <- cbind(fq3,cc,bmi)
dose <- rep(c(rep(50,18),rep(100,18),rep(150,18)),2)
ind <- c(rep(1,54),rep(0,54))
subject <- rep(1:18,6)

covarp <- tcctomat(cbind(rbind(fq3,fq3,fq3,fq3,fq3,fq3),dose,subject)[1:54,])
covar <- tcctomat(cbind(rbind(fq3,fq3,fq3,fq3,fq3,fq3),dose,ind))

repsp <- rmna(yp,ccov=covarp)
repsm <- rmna(ym,ccov=covarp)
reps <- rmna(y,ccov=covar)

# Model 1

mupar <- ~exp(lka-lV)*dose/(exp(lka)-exp(lke))*
	(exp(-exp(lke)*times)-exp(-exp(lka)*times))
ldisppar <- ~lkav-lVv+log(dose/(exp(lkav)-exp(lkev))*
	(exp(-exp(lkev)*times)-exp(-exp(lkav)*times)))
print(zg1p <- gnlr(yp,distribution="gamma",pmu=list(lka=1,lke=-1,lV=4),
	psh=list(lkav=-0.01,lkev=-0.7,lVv=3),mu=mupar,shape=ldisppar,
	envir=repsp))

mu <- function(p) exp(p[1]-p[3])*dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times))
shapep <- function(p) p[1]-p[3]+log(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times)))
print(zg1p <- gnlr(yp,"gamma",pmu=c(1.04,-0.88,4.09),
	psh=c(-0.013,-0.67,2.67),mu=mu,shape=shapep,envir=repsp))
ka <- exp(zg1p$coef[1])
ke <- exp(zg1p$coef[2])
V <- exp(zg1p$coef[3])
print(tmax <- log(ka/ke)/(ka-ke))
print(cmax <- (exp(-ke*tmax)-exp(-ka*tmax))*ka*150/V/(ka-ke))
mui <- function(t) ka*150/V/(ka-ke)*(exp(-ke*t)-exp(-ka*t))
int(mui,0,Inf)

shapem <- function(p) p[3]*(p[1]+p[2]+log(dose*times)-exp(p[1])*times)
print(zg1m <- gnlr(ym,"gamma",pmu=c(-0.28,-3.8,3.84),psh=c(-3.24,1.14,0.68),
	mu=mu,shape=shapem,envir=repsm))
zg1p$aic+zg1m$aic

muln <- function(p) p[1]-p[3]+log(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times)))
shapelnp <- function(p) p[4]*(p[1]+p[3]+log(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times))))
print(zln1p <- gnlr(lyp,"normal",pmu=c(-0.39,0.14,3.4),
	psh=c(0.7,1,3.7,-0.1),mu=muln,shape=shapelnp,envir=repsp))
print(zln1m <- gnlr(lym,"normal",pmu=c(-3.8,-0.17,-0.22),
	psh=c(-3.8,-0.17,-0.22),mu=muln,shape=shapem,envir=repsm))
zln1p$aic+zln1m$aic

print(zn1m <- gnlr(ym,"normal",pmu=c(-3.8,0.2,0.24),
	psh=c(-3.8,-0.17,-0.2,1),mu=mu,shape=shapelnp,envir=repsm))

if(interactive()){
mug <- function(t,dose) exp(zg1p$coef[1]-zg1p$coef[3])*dose/
	(exp(zg1p$coef[1])-exp(zg1p$coef[2]))*(exp(-exp(zg1p$coef[2])*t)- 
        exp(-exp(zg1p$coef[1])*t))
mugm <- function(t,dose) exp(zg1m$coef[1]-zg1m$coef[3])*dose/
	(exp(zg1m$coef[1])-exp(zg1m$coef[2]))*(exp(-exp(zg1m$coef[2])*t)- 
        exp(-exp(zg1m$coef[1])*t))
postscript("flosmeta.eps",height=5)
par(mfcol=c(1,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
# drug
plot(times(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150],
	response(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150,1],
	ylim=c(0,5),ylab=expression(paste("Concentration (",mu,"g/ml)")),
	xlab="Hours",main="Flosequinan",pch=20)
lines(unique(times(repsp)),mug(unique(times(repsp)),150))
# metabolite
plot(times(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150],
	response(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150,1],
	ylim=c(0,5),ylab="",xlab="Hours",main="Metabolite",pch=20)
lines(unique(times(repsm)),mugm(unique(times(repsm)),150))
dev.off()
tt <- c(seq(0.01,0.09,by=0.01),seq(0.1,12,by=0.1))
muln <- function(t,dose) exp(zln1p$coef[1]-zln1p$coef[3])*dose/
	(exp(zln1p$coef[1])-exp(zln1p$coef[2]))*(exp(-exp(zln1p$coef[2])*t)- 
        exp(-exp(zln1p$coef[1])*t))
mulnv <- function(t,dose) exp(zln1p$coef[1]-zln1p$coef[3])*dose/
	(exp(zln1p$coef[1])-exp(zln1p$coef[2]))*(exp(-exp(zln1p$coef[2])*t)- 
        exp(-exp(zln1p$coef[1])*t)) * exp(exp(zln1p$coef[7]*(zln1p$coef[4]+
	zln1p$coef[6]+log(dose/(exp(zln1p$coef[4])-exp(zln1p$coef[5]))*
	(exp(-exp(zln1p$coef[5])*t)-exp(-exp(zln1p$coef[4])*t)))))/2)
postscript("flos2c.eps",height=5,width=5)
par(mfcol=c(1,1),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(tt,mug(tt,150),ylim=c(0,5),type="l",
	ylab="Concentration (microg/ml)",xlab="Hours")
lines(tt,muln(tt,150),lty=2)
lines(tt,mulnv(tt,150),lty=3)
points(times(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150],
	response(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150,1],
	pch=20)
dev.off()
}

#  Model 2

muj1 <- function(p) {
	ka <- exp(p[1])
	ke <- exp(p[2])
	kme <- exp(p[5])
	ka*exp(-p[3])*dose/(ka-ke)*(ind*(exp(-ke*times)-exp(-ka*times))+
	(1-ind)*exp(p[4])*(exp(-ka*times)/(ka-kme)-exp(-ke*times)/(ke-kme)+
	(1/(ke-kme)-1/(ka-kme))*exp(-kme*times)))}
shapej1 <- function(p) {
	ka <- exp(p[1])
	ke <- exp(p[2])
	kme <- exp(p[5])
	p[6]*(p[1]+p[3]+log(dose)+log(ind*(ka*times*exp(-ka*times))+
	(1-ind)*exp(p[4])/(ka-ke)*(exp(-ka*times)/(ka-kme)-exp(-ke*times)/
	(ke-kme)+(1/(ke-kme)-1/(ka-kme))*exp(-kme*times))))}
print(zg1j <- gnlr(y,"gamma",pmu=c(4,-0.68,3.8,-0.67,-3.74),
	psh=c(-0.36,-0.62,-2.1,0.34,-4.69,0.94),mu=muj1,shape=shapej1,
	envir=reps))
ka <- exp(zg1j$coef[1])
ke <- exp(zg1j$coef[2])
V <- exp(zg1j$coef[3])
print(tmax <- log(ka/ke)/(ka-ke))
print(cmax <- (exp(-ke*tmax)-exp(-ka*tmax))*ka*150/V/(ka-ke))
mui <- function(t) ka*150/V/(ka-ke)*(exp(-ke*t)-exp(-ka*t))
int(mui,0,Inf)

mulnj1 <- function(p) {
	ka <- exp(p[1])
	ke <- exp(p[2])
	kme <- exp(p[5])
	p[1]-p[3]+log(dose/(ka-ke))+log(ind*(exp(-ke*times)-exp(-ka*times))+
	(1-ind)*exp(p[4])*(exp(-ka*times)/(ka-kme)-exp(-ke*times)/(ke-kme)+
	(1/(ke-kme)-1/(ka-kme))*exp(-kme*times)))}
print(zln1j <- gnlr(ly,"normal",pmu=c(1.61,-0.54,4,-0.36,-3.74),
	psh=c(-0.56,-3.69,-2.02,1.46,-2.43,-0.53),
	mu=mulnj1,shape=shapej1,envir=reps,stepmax=1))

if(interactive()){
postscript("jointdm.eps",height=5)
par(mfcol=c(1,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
tt <- c(seq(0.01,0.09,by=0.01),seq(0.1,12,by=0.1))
mug <- function(t,dose) exp(zg1p$coef[1]-zg1p$coef[3])*dose/
	(exp(zg1p$coef[1])-exp(zg1p$coef[2]))*(exp(-exp(zg1p$coef[2])*t)- 
        exp(-exp(zg1p$coef[1])*t))
mugj <- function(t,dose) exp(zg1j$coef[1]-zg1j$coef[3])*dose/
	(exp(zg1j$coef[1])-exp(zg1j$coef[2]))*(exp(-exp(zg1j$coef[2])*t)- 
        exp(-exp(zg1j$coef[1])*t))
mulnvj <- function(t,dose) {
	ka <- exp(zln1j$coef[6])
	ke <- exp(zln1j$coef[7])
	exp(zln1j$coef[1]-zln1j$coef[3])*dose/
	(exp(zln1j$coef[1])-exp(zln1j$coef[2]))*(exp(-exp(zln1j$coef[2])*t)- 
        exp(-exp(zln1j$coef[1])*t))*
	exp(exp(zln1j$coef[11]*(zln1j$coef[6]+zln1j$coef[8]+log(dose/(ka-ke))+
	log((exp(-ke*t)-exp(-ka*t)))))/2)}
plot(times(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150],
	response(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150,1],
	ylim=c(0,5),ylab=expression(paste("Concentration (",mu,"g/ml)")),
	xlab="Hours",main="Flosequinan",pch=20,xlim=c(0,12))
lines(tt,mugj(tt,150),lty=2)
lines(tt[tt>0.04],mulnvj(tt,150)[tt>0.04],lty=3)
lines(tt,mug(tt,150))
tt <- c(0.01,seq(0.1,96,by=0.5))
mugj <- function(t,dose) {
	ka <- exp(zg1j$coef[1])
	ke <- exp(zg1j$coef[2])
	e3 <- exp(zg1j$coef[3])
	kme <- exp(zg1j$coef[5])
	ka*dose/e3/(ka-ke)*exp(zg1j$coef[4])*(exp(-ka*t)/(ka-kme)-exp(-ke*t)/
	(ke-kme)+(1/(ke-kme)-1/(ka-kme))*exp(-kme*t))}
plot(tt,mugm(tt,150),ylim=c(0,5),type="l",
	ylab="",xlab="Hours",main="Metabolite")
lines(tt,mugj(tt,150),lty=2)
points(times(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150],
	response(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150,1],
	pch=20)
dev.off()
}

# various hypotheses for Model 3

# metabolite direct formation = parent absorption
muj2 <- function(p) {
	ka <- exp(p[1])
	ke <- exp(p[2])
	kme <- exp(p[5])
	e7 <- exp(p[6])
	dose*exp(-p[3])*(ind*ka*(exp(-ke*times)-exp(-ka*times))/(ka-ke)*e7/
	(1+e7)+(1-ind)*(ka*(exp(-kme*times)-exp(-ka*times))/(ka-kme)/(1+e7)+
	exp(p[4])*(exp(-ka*times)/(ka-kme)-exp(-ke*times)/(ke-kme)+
	(1/(ke-kme)-1/(ka-kme))*exp(-kme*times))/(ka-ke)*e7/(1+e7)))}
# joint2.r, zg3a
print(zg2j <- gnlr(y,"gamma",pmu=c(0.865,-0.82,3.59,-0.34,-3.773,0.556),
	psh=c(-0.38,-0.39,-2.52,0.79,-4.84,0.97),mu=muj2,shape=shapej1,
	envir=reps))
ka <- exp(zg2j$coef[1])
ke <- exp(zg2j$coef[2])
V <- exp(zg2j$coef[3])
PI <- exp(zg2j$coef[6])/(1+exp(zg2j$coef[6]))
print(tmax <- log(ka/ke)/(ka-ke))
print(cmax <- (exp(-ke*tmax)-exp(-ka*tmax))*ka*150/V/(ka-ke)*PI)
mui <- function(t) ka*150/V/(ka-ke)*(exp(-ke*t)-exp(-ka*t))*PI
int(mui,0,Inf)

# metabolite direct formation = metabolite first pass formation
muj3 <- function(p) {
	ka <- exp(p[1])
	ke <- exp(p[2])
	kma <- exp(p[4])
	kme <- exp(p[5])
	e7 <- exp(p[6])
	dose*exp(-p[3])*(ind*ka*(exp(-ke*times)-exp(-ka*times))/(ka-ke)*e7/
	(1+e7)+(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/(kma-kme)/(1+e7)+
	kma*(exp(-ka*times)/(ka-kme)-exp(-ke*times)/(ke-kme)+
	(1/(ke-kme)-1/(ka-kme))*exp(-kme*times))/(ka-ke)*e7/(1+e7)))}
print(zg3j <- gnlr(y,"gamma",pmu=c(1.65,-0.94,3.55,0.16,-3.77,0.23),
	psh=c(-0.35,-0.39,-2.27,1.03,-4.86,0.84),mu=muj3,shape=shapej1,
	envir=reps,iter=200))
ka <- exp(zg3j$coef[1])
ke <- exp(zg3j$coef[2])
V <- exp(zg3j$coef[3])
PI <- exp(zg3j$coef[6])/(1+exp(zg3j$coef[6]))
print(tmax <- log(ka/ke)/(ka-ke))
print(cmax <- (exp(-ke*tmax)-exp(-ka*tmax))*ka*150/V/(ka-ke)*PI)
mui <- function(t) ka*150/V/(ka-ke)*(exp(-ke*t)-exp(-ka*t))*PI
int(mui,0,Inf)

# final Model 3

# metabolite direct and first pass formation different
muj4 <- function(p) {
	ka <- exp(p[1])
	kf <- exp(p[6])
	ke <- exp(p[2])+kf
	kma <- exp(p[4])
	kme <- exp(p[5])
	e8 <- exp(p[7])
	dose*exp(-p[3])*(ind*ka*(exp(-ke*times)-exp(-ka*times))/(ka-ke)*e8/
	(1+e8)+(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/(kma-kme)/(1+e8)+
	kf*(exp(-ka*times)/(ka-kme)-exp(-ke*times)/(ke-kme)+
	(1/(ke-kme)-1/(ka-kme))*exp(-kme*times))/(ka-ke)*e8/(1+e8)))}
print(zg4j <- gnlr(y,"gamma",pmu=c(0.89,-3.72,3.45,0.075,-3.79,-0.94,0.095),
	psh=c(-0.18,-1.54,-1.71,0.54,-4.15,0.68),mu=muj4,shape=shapej1,
	envir=reps,iter=200))
muj4a <- function(p) {
	ka <- exp(p[1])
	ke <- exp(p[5])  # = kf
	kma <- exp(p[3])
	kme <- exp(p[4])
	e8 <- exp(p[6])
	dose*exp(-p[2])*(ind*ka*(exp(-ke*times)-exp(-ka*times))/(ka-ke)*e8/
	(1+e8)+(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/(kma-kme)/(1+e8)+
	ke*(exp(-ka*times)/(ka-kme)-exp(-ke*times)/(ke-kme)+
	(1/(ke-kme)-1/(ka-kme))*exp(-kme*times))/(ka-ke)*e8/(1+e8)))}
print(zg4ja <- gnlr(y,"gamma",pmu=c(0.89,3.46,0.12,-3.79,-0.88,0.13),
	psh=c(-0.18,-1.55,-1.7,0.54,-4.14,0.68),mu=muj4a,shape=shapej1,
	envir=reps))
ka <- exp(zg4ja$coef[1])
ke <- exp(zg4ja$coef[5])
V <- exp(zg4ja$coef[2])
PI <- exp(zg4ja$coef[6])/(1+exp(zg4ja$coef[6]))
print(tmax <- log(ka/ke)/(ka-ke))
print(cmax <- (exp(-ke*tmax)-exp(-ka*tmax))*ka*150/V/(ka-ke)*PI)
mui <- function(t) ka*150/V/(ka-ke)*(exp(-ke*t)-exp(-ka*t))*PI
int(mui,0,Inf)

if(interactive()){
postscript("jointdm2.eps",height=5)
par(mfcol=c(1,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
tt <- c(seq(0.01,0.09,by=0.01),seq(0.1,12,by=0.1))
mugj2 <- function(t,dose) {
	ka <- exp(zg4ja$coef[1])
	ke <- exp(zg4ja$coef[5])
	e8 <- exp(zg4ja$coef[6])
	dose*exp(-zg4ja$coef[2])*ka*(exp(-ke*t)-exp(-ka*t))/(ka-ke)*e8/(1+e8)}
plot(times(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150],
	response(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150,1],
	ylim=c(0,5),ylab=expression(paste("Concentration (",mu,"/ml)")),
	xlab="Hours",main="Flosequinan",pch=20,xlim=c(0,12))
lines(tt,mugj2(tt,150),lty=3)
lines(tt,mug(tt,150))
tt <- c(0.01,seq(0.1,96,by=0.5))
mugj2a <- function(t,dose) {
	kma <- exp(zg4ja$coef[3])
	kme <- exp(zg4ja$coef[4])
	e8 <- exp(zg4ja$coef[6])
	dose*exp(-zg4ja$coef[2])*(kma*(exp(-kme*t)-exp(-kma*t))/
	(kma-kme)/(1+e8))}
mugj2b <- function(t,dose) {
	ka <- exp(zg4ja$coef[1])
	ke <- exp(zg4ja$coef[5])
	kme <- exp(zg4ja$coef[4])
	e8 <- exp(zg4ja$coef[6])
	dose*exp(-zg4ja$coef[2])*(ke*(exp(-ka*t)/(ka-kme)-
	exp(-ke*t)/(ke-kme)+(1/(ke-kme)-1/(ka-kme))*exp(-kme*t))/
	(ka-ke)*e8/(1+e8))}
plot(tt,mugm(tt,150),ylim=c(0,5),type="l",ylab="",xlab="Hours",
	main="Metabolite")
lines(tt,mugj2a(tt,150),lty=2)
lines(tt,mugj2b(tt,150),lty=3)
lines(tt,mugj2a(tt,150)+mugj2b(tt,150),lty=4)
points(times(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150],
	response(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150,1],
	pch=20)
dev.off()
}

mulnj4a <- function(p) {
	ka <- exp(p[1])
	ke <- exp(p[5])
	kma <- exp(p[3])
	kme <- exp(p[4])
	e8 <- exp(p[6])
	log(dose)-p[2]+log(ind*ka*(exp(-ke*times)-exp(-ka*times))/(ka-ke)*e8/
	(1+e8)+(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/(kma-kme)/(1+e8)+
	ke*(exp(-ka*times)/(ka-kme)-exp(-ke*times)/(ke-kme)+
	(1/(ke-kme)-1/(ka-kme))*exp(-kme*times))/(ka-ke)*e8/(1+e8)))}
print(zln4ja <- gnlr(ly,"normal",pmu=c(0.51,3.59,0.062,-3.78,-0.57,0.37),
	psh=c(-0.37,-3.2,-1.48,2.09,-3.22,-0.42),mu=mulnj4a,shape=shapej1,
	envir=reps,iter=200))

# set parent and metabolite volumes different
muj4a <- function(p) {
	ka <- exp(p[1])
	ke <- exp(p[5])  # = kf
	kma <- exp(p[3])
	kme <- exp(p[4])
	e8 <- exp(p[6])
	dose*(exp(-p[2])*ind*ka*(exp(-ke*times)-exp(-ka*times))/(ka-ke)*e8/
	(1+e8)+exp(-p[7])*(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/
	(kma-kme)/(1+e8)+ke*(exp(-ka*times)/(ka-kme)-exp(-ke*times)/(ke-kme)+
	(1/(ke-kme)-1/(ka-kme))*exp(-kme*times))/(ka-ke)*e8/(1+e8)))}
print(zg4ja <- gnlr(y,"gamma",pmu=c(0.89,3.46,0.12,-3.79,-0.88,0.13,3.46),
	psh=c(-0.18,-1.55,-1.7,0.54,-4.14,0.68),mu=muj4a,shape=shapej1,
	envir=reps,iter=200))

# add covariates

muj4cov7i <- function(p) {
	ka <- exp(p[1]+p[8]*sex+p[9]*bilirubin+p[10]*cc+p[11]*ast)
	kf <- exp(p[6]+p[13]*age+p[14]*sex+p[15]*alt
		+p[16]*bilirubin+p[17]*cc+p[18]*gammagt)
	ke <- exp(p[2])+kf
	kma <- exp(p[4])
	kme <- exp(p[5]+p[19]*sex+p[20]*alkphos+p[21]*bilirubin
		+p[22]*gammagt)
	e8 <- exp(p[7]+p[23]*sex)
	dose*exp(-p[3]-p[12]*alt)*
	(ind*ka*(exp(-ke*times)-exp(-ka*times))/(ka-ke)*e8/(1+e8)+
	(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/(kma-kme)/(1+e8)+
	kf*(exp(-ka*times)/(ka-kme)-exp(-ke*times)/(ke-kme)+
	(1/(ke-kme)-1/(ka-kme))*exp(-kme*times))/(ka-ke)*e8/(1+e8)))}
print(zg4jcov7i <- gnlr(y,"gamma",pmu=c(-1.59,-22,3.47,-0.0096,-3.96,-0.61,
	0.13,-1.74,0.048,0.02,0.12,-0.012,0.028,-0.54,-0.0094,0.05,
	-0.0065,-0.03,0.1,0.00069,0.011,-0.0049,0.44),
	psh=c(-0.62,-1.47,-1.2,0.032,-3.93,0.91),
	mu=muj4cov7i,shape=shapej1,envir=reps,iter=200))
muj4cov7ia <- function(p) {
	ka <- exp(p[1]+p[7]*sex+p[8]*bilirubin+p[9]*cc+p[10]*ast)
	kf <- exp(p[5]+p[12]*age+p[13]*sex+p[14]*alt  # = ke
		+p[15]*bilirubin+p[16]*cc+p[17]*gammagt)
	kma <- exp(p[3])
	kme <- exp(p[4]+p[18]*sex+p[19]*alkphos+p[20]*bilirubin
		+p[21]*gammagt)
	e8 <- exp(p[6]+p[22]*sex)
	dose*exp(-p[2]-p[11]*alt)*
	(ind*ka*(exp(-kf*times)-exp(-ka*times))/(ka-kf)*e8/(1+e8)+
	(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/(kma-kme)/(1+e8)+
	kf*(exp(-ka*times)/(ka-kme)-exp(-kf*times)/(kf-kme)+
	(1/(kf-kme)-1/(ka-kme))*exp(-kme*times))/(ka-kf)*e8/(1+e8)))}
print(zg4jcov7ia <- gnlr(y,"gamma",pmu=c(-1.6,3.47,-0.0063,-3.96,-0.61,
	0.12,-1.75,0.048,0.021,0.12,-0.012,0.028,-0.54,-0.0085,0.05,
	-0.0066,-0.03,0.098,0.00074,0.011,-0.0052,0.45),
	psh=c(-0.62,-1.45,-1.21,0.036,-3.94,0.91),
	mu=muj4cov7ia,shape=shapej1,envir=reps,iter=200))

if(interactive()){
postscript("jointdm3.eps",height=8)
par(mfrow=c(2,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
mugj3 <- function(p,t,dose,ind,i) {
	ka <- exp(p[1]+p[7]*sex+p[8]*bilirubin+p[9]*cc+p[10]*ast)[i]
	kf <- exp(p[5]+p[12]*age+p[13]*sex+p[14]*alt  # = ke
		+p[15]*bilirubin+p[16]*cc+p[17]*gammagt)[i]
	kma <- exp(p[3])
	kme <- exp(p[4]+p[18]*sex+p[19]*alkphos+p[20]*bilirubin
		+p[21]*gammagt)[i]
	e8 <- exp(p[6]+p[22]*sex)[i]
	dose*exp(-p[2]-p[11]*alt[i])*
	(ind*ka*(exp(-kf*t)-exp(-ka*t))/(ka-kf)*e8/(1+e8)+
	(1-ind)*(kma*(exp(-kme*t)-exp(-kma*t))/(kma-kme)/(1+e8)+
	kf*(exp(-ka*t)/(ka-kme)-exp(-kf*t)/(kf-kme)+
	(1/(kf-kme)-1/(ka-kme))*exp(-kme*t))/(ka-kf)*e8/(1+e8)))}
tt <- c(seq(0.01,0.09,by=0.01),seq(0.1,12,by=0.1))
plot(times(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150&
	covariates(repsp,name="subject")[covind(repsp)]==16],
	response(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150&
	covariates(repsp,name="subject")[covind(repsp)]==16,1],
	ylim=c(0,5),xlim=c(0,12),main="Flosequinan",pch=20,
	ylab=expression(paste("Concentration (",mu,"g/ml)")),xlab="")
lines(tt,mugj3(zg4jcov7ia$coef,tt,150,1,16),lty=3)
points(times(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150&
	covariates(repsp,name="subject")[covind(repsp)]==10],
	response(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150&
	covariates(repsp,name="subject")[covind(repsp)]==10,1],pch=1)
lines(tt,mugj3(zg4jcov7ia$coef,tt,150,1,10),lty=2)
legend(5,4.5,legend=c("Subject 10","Subject 16"),pch=c(1,20),
	lty=c(2,3),bty="n")
tt <- c(0.01,seq(0.1,96,by=0.5))
plot(times(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150&
	covariates(repsm,name="subject")[covind(repsm)]==16],
	response(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150&
	covariates(repsm,name="subject")[covind(repsm)]==16,1],
	ylim=c(0,5),xlim=c(0,96),ylab="",xlab="",main="Metabolite",pch=20)
lines(tt,mugj3(zg4jcov7ia$coef,tt,150,0,16),lty=3)
points(times(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150&
	covariates(repsm,name="subject")[covind(repsm)]==10],
	response(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150&
	covariates(repsm,name="subject")[covind(repsm)]==10,1],pch=1)
lines(tt,mugj3(zg4jcov7ia$coef,tt,150,0,10),lty=2)

tt <- c(seq(0.01,0.09,by=0.01),seq(0.1,12,by=0.1))
plot(times(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150&
	covariates(repsp,name="subject")[covind(repsp)]==8],
	response(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150&
	covariates(repsp,name="subject")[covind(repsp)]==8,1],
	ylim=c(0,5),xlim=c(0,12),xlab="Hours",
	ylab=expression(paste("Concentration (",mu,"g/ml)")),pch=20)
lines(tt,mugj3(zg4jcov7ia$coef,tt,150,1,8),lty=3)
points(times(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150&
	covariates(repsp,name="subject")[covind(repsp)]==2],
	response(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150&
	covariates(repsp,name="subject")[covind(repsp)]==2,1],pch=1)
lines(tt,mugj3(zg4jcov7ia$coef,tt,150,1,2),lty=2)
legend(5,4.5,legend=c("Subject 2","Subject 8"),pch=c(1,20),
	lty=c(2,3),bty="n")
tt <- c(0.01,seq(0.1,96,by=0.5))
plot(times(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150&
	covariates(repsm,name="subject")[covind(repsm)]==8],
	response(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150&
	covariates(repsm,name="subject")[covind(repsm)]==8,1],
	ylim=c(0,5),xlim=c(0,96),ylab="",xlab="Hours",pch=20)
lines(tt,mugj3(zg4jcov7ia$coef,tt,150,0,8),lty=3)
points(times(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150&
	covariates(repsm,name="subject")[covind(repsm)]==2],
	response(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150&
	covariates(repsm,name="subject")[covind(repsm)]==2,1],pch=1)
lines(tt,mugj3(zg4jcov7ia$coef,tt,150,0,2),lty=2)
dev.off()
}

# set kma=0
muj4cov7ib <- function(p) {
	ka <- exp(p[1]+p[5]*sex+p[6]*bilirubin+p[7]*cc+p[8]*ast)
	kf <- exp(p[4]+p[10]*age+p[11]*sex+p[12]*alt  # = ke
		+p[13]*bilirubin+p[14]*cc+p[15]*gammagt)
	kme <- exp(p[3]+p[16]*sex+p[17]*alkphos+p[18]*bilirubin
		+p[19]*gammagt)
	dose*exp(-p[2]-p[9]*alt)*(ind*ka*(exp(-kf*times)-exp(-ka*times))/
	(ka-kf)+(1-ind)*(kf*(exp(-ka*times)/(ka-kme)-exp(-kf*times)/(kf-kme)+
	(1/(kf-kme)-1/(ka-kme))*exp(-kme*times))/(ka-kf)))}
print(zg4jcov7ib <- gnlr(y,"gamma",pmu=c(-0.17,3.45,-3.95,0.32,
	-0.29,0.01,0.0046,0.0065,0.000034,0.023,-0.56,-0.0094,0.031,
	-0.0067,-0.031,0.097,0.000046,0.011,0.002),
	psh=c(-0.47,-1.75,-1.78,-0.61,-3.98,1.1),
	mu=muj4cov7ib,shape=shapej1,envir=reps,iter=200))

mulj4cov7ia <- function(p) {
	ka <- exp(p[1]+p[7]*sex+p[8]*bilirubin+p[9]*cc+p[10]*ast)
	kf <- exp(p[5]+p[12]*age+p[13]*sex+p[14]*alt  # = ke
		+p[15]*bilirubin+p[16]*cc+p[17]*gammagt)
	kma <- exp(p[3])
	kme <- exp(p[4]+p[18]*sex+p[19]*alkphos+p[20]*bilirubin
		+p[21]*gammagt)
	e8 <- exp(p[6]+p[22]*sex)
	log(dose*exp(-p[2]-p[11]*alt)*
	(ind*ka*(exp(-kf*times)-exp(-ka*times))/(ka-kf)*e8/(1+e8)+
	(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/(kma-kme)/(1+e8)+
	kf*(exp(-ka*times)/(ka-kme)-exp(-kf*times)/(kf-kme)+
	(1/(kf-kme)-1/(ka-kme))*exp(-kme*times))/(ka-kf)*e8/(1+e8))))}
print(zln4jcov7ia <- gnlr(ly,"normal",pmu=c(-1.13,3.61,-0.009,-3.96,-0.27,
	0.037,-1.35,0.034,0.015,0.085,-0.012,0.027,-0.37,-0.009,0.032,
	-0.0075,-0.031,0.1,0.00059,0.013,-0.005,0.87),
	psh=c(-0.83,-3.45,-0.97,0.66,-2.33,-0.68),
	mu=mulj4cov7ia,shape=shapej1,envir=reps,iter=200))

# set metabolite direct formation = parent absorption in final covariate model
muj4cov7ib <- function(p) {
	ka <- exp(p[1]+p[6]*sex+p[7]*bilirubin+p[8]*cc+p[9]*ast)
	kf <- exp(p[4]+p[11]*age+p[12]*sex+p[13]*alt  # = ke
		+p[14]*bilirubin+p[15]*cc+p[16]*gammagt)
	kme <- exp(p[3]+p[17]*sex+p[18]*alkphos+p[19]*bilirubin
		+p[20]*gammagt)
	e8 <- exp(p[5]+p[21]*sex)
	dose*exp(-p[2]-p[10]*alt)*
	(ind*ka*(exp(-kf*times)-exp(-ka*times))/(ka-kf)*e8/(1+e8)+
	(1-ind)*(ka*(exp(-kme*times)-exp(-ka*times))/(ka-kme)/(1+e8)+
	kf*(exp(-ka*times)/(ka-kme)-exp(-kf*times)/(kf-kme)+
	(1/(kf-kme)-1/(ka-kme))*exp(-kme*times))/(ka-kf)*e8/(1+e8)))}
print(zg4jcov7ib <- gnlr(y,"gamma",pmu=c(-1.08,3.51,-3.98,-0.55,
	0.18,-1.44,0.037,0.016,0.092,-0.011,0.028,-0.48,-0.009,0.048,
	-0.0068,-0.03,0.12,0.00063,0.011,-0.0046,0.7),
	psh=c(-0.61,-1.68,-1.2,-0.2,-3.89,0.92),
	mu=muj4cov7ib,shape=shapej1,envir=reps,iter=200))

# set metabolite direct formation = parent absorption and parent
# volume different from metabolite volume in final covariate model
muj4cov7ic <- function(p) {
	ka <- exp(p[1]+p[7]*sex+p[8]*bilirubin+p[9]*cc+p[10]*ast)
	kf <- exp(p[5]+p[12]*age+p[13]*sex+p[14]*alt  # = ke
		+p[15]*bilirubin+p[16]*cc+p[17]*gammagt)
	kme <- exp(p[4]+p[18]*sex+p[19]*alkphos+p[20]*bilirubin
		+p[21]*gammagt)
	e8 <- exp(p[6]+p[22]*sex)
	dose*(exp(-p[2]-p[11]*alt)*
	ind*ka*(exp(-kf*times)-exp(-ka*times))/(ka-kf)*e8/(1+e8)+exp(-p[3])*
	(1-ind)*(ka*(exp(-kme*times)-exp(-ka*times))/(ka-kme)/(1+e8)+
	kf*(exp(-ka*times)/(ka-kme)-exp(-kf*times)/(kf-kme)+
	(1/(kf-kme)-1/(ka-kme))*exp(-kme*times))/(ka-kf)*e8/(1+e8)))}
print(zg4jcov7ic <- gnlr(y,"gamma",pmu=c(0.11,3.68,2.98,-4,-0.57,
	1.02,-1.27,0.031,0.011,0.049,0.0096,0.027,-0.56,-0.015,0.044,
	-0.006,-0.031,0.15,0.000052,0.012,0.00048,0.78),
	psh=c(-0.64,-1.49,-1.19,0.0037,-3.89,0.9),
	mu=muj4cov7ic,shape=shapej1,envir=reps,iter=200))
muj4cov7id <- function(p) {
	ka <- exp(p[1]+p[7]*sex+p[8]*bilirubin+p[9]*cc+p[10]*ast)
	kf <- exp(p[5]+p[12]*age+p[13]*sex+p[14]*alt  # = ke
		+p[15]*bilirubin+p[16]*cc+p[17]*gammagt)
	kme <- exp(p[4]+p[18]*sex+p[19]*alkphos+p[20]*bilirubin
		+p[21]*gammagt)
	e8 <- exp(p[6]+p[22]*sex)
	dose*(exp(-p[2])*ind*ka*(exp(-kf*times)-exp(-ka*times))/
	(ka-kf)*e8/(1+e8)+exp(-p[3]-p[11]*alt)*
	(1-ind)*(ka*(exp(-kme*times)-exp(-ka*times))/(ka-kme)/(1+e8)+
	kf*(exp(-ka*times)/(ka-kme)-exp(-kf*times)/(kf-kme)+
	(1/(kf-kme)-1/(ka-kme))*exp(-kme*times))/(ka-kf)*e8/(1+e8)))}
print(zg4jcov7id <- gnlr(y,"gamma",pmu=c(-0.19,3.74,3.06,-3.97,-0.59,
	1,-1.44,0.034,0.013,0.077,-0.012,0.027,-0.55,-0.0098,0.044,
	-0.006,-0.031,0.14,0.0006,0.0091,-0.0041,0.82),
	psh=c(-0.64,-1.47,-1.2,-0.0003,-3.95,0.91),
	mu=muj4cov7id,shape=shapej1,envir=reps,iter=200))

# set parent volume different from metabolite volume in final covariate model
muj4cov7ie <- function(p) {
	ka <- exp(p[1]+p[7]*sex+p[8]*bilirubin+p[9]*cc+p[10]*ast)
	kf <- exp(p[5]+p[12]*age+p[13]*sex+p[14]*alt  # = ke
		+p[15]*bilirubin+p[16]*cc+p[17]*gammagt)
	kma <- exp(p[3])
	kme <- exp(p[4]+p[18]*sex+p[19]*alkphos+p[20]*bilirubin
		+p[21]*gammagt)
	e8 <- exp(p[6]+p[22]*sex)
	dose*(exp(-p[2])*ind*ka*(exp(-kf*times)-exp(-ka*times))/
	(ka-kf)*e8/(1+e8)+exp(-p[23]-p[11]*alt)*
	(1-ind)*(kma*(exp(-kme*times)-exp(-kma*times))/(kma-kme)/(1+e8)+
	kf*(exp(-ka*times)/(ka-kme)-exp(-kf*times)/(kf-kme)+
	(1/(kf-kme)-1/(ka-kme))*exp(-kme*times))/(ka-kf)*e8/(1+e8)))}
print(zg4jcov7ie <- gnlr(y,"gamma",pmu=c(-0.94,3.63,-0.0053,-3.95,-0.63,
	0.68,-1.74,0.046,0.019,0.11,-0.013,0.027,-0.59,-0.011,0.048,
	-0.0061,-0.03,0.11,0.00074,0.0096,-0.0051,0.45,3.17),
	psh=c(-0.64,-1.36,-1.19,0.026,-3.97,0.93),
	mu=muj4cov7ie,shape=shapej1,envir=reps,iter=200))
