options(contrasts = c("contr.sum", "contr.poly"))

library(gnlm)

# parent drug

fq1 <- read.table("flos.dat",header=T)
attach(fq1)
tconcp <- cbind(matrix(ifelse(conc>0,conc,0.04),ncol=12,byrow=T),
	matrix(NA,ncol=4,nrow=54))
censorp <- ifelse(tconcp==0.04,-1,1)
yp <- restovec(tconcp,censor=censorp,name="yp",
	times=c(ifelse(time==0,0.01,time)[1:12],36,48,72,96),delta=0.01)
yp <- transform(yp,lyp=log(yp))

# for models without censoring
tconcp12 <-cbind(matrix(ifelse(conc>0,conc,0.02),ncol=12,byrow=T))[,1:11]
ycp12 <- restovec(tconcp12,times=c(ifelse(time==0,0.01,time)[1:11]),
      delta=0.01,name="yp")
ycp12 <- transform(ycp12,lyp=log(yp))
tconcp24 <-cbind(matrix(ifelse(conc>0,conc,0.02),ncol=12,byrow=T))
ycp24 <- restovec(tconcp24,times=c(ifelse(time==0,0.01,time)[1:12]),
      delta=0.01,name="yp")
ycp24 <- transform(ycp24,lyp=log(yp))

# metabolite

fq2 <- read.table("metaba.dat",header=T)
attach(fq2)
conc[conc==99] <- NA
tconcm <- matrix(conc,ncol=16,byrow=T)
censorm <- ifelse(tconcm==0.1,-1,1)
ym <- restovec(tconcm,censor=censorm,times=ifelse(time==0,0.01,time)[1:16],
	delta=0.01,name="ym")
ym <- transform(ym,lym=log(ym))

# covariates

fq3 <- read.table("floscov.dat",skip=9)[,-c(1:2,6,14:17)]
names(fq3) <- c("sex","age","height","weight","creatinine","bilirubin",
	"alkphos","alt","ast","gammagt")
fq3 <- fq3[seq(3,54,by=3),]
attach(fq3)
cc <- ifelse(sex=="M",1.04,1.23)*(140-age)*weight/creatinine
bmi <- weight/height^2
fq3 <- cbind(fq3,cc,bmi)
dose <- c(rep(50,18),rep(100,18),rep(150,18))
subject <- gl(18,1,54)

covar <- tcctomat(cbind(rbind(fq3,fq3,fq3),dose,subject))

repsp <- rmna(yp,ccov=covar)
repscp12 <- rmna(ycp12,ccov=covar)
repscp24 <- rmna(ycp24,ccov=covar)
repsm <- rmna(ym,ccov=covar)

# parent
# constant shape
mu <- function(p) exp(p[1]-p[3])*dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times))
mul <- function(p) p[1]-p[3]+log(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times)))
print(zn <- gnlr(yp,"normal",pmu=c(1,-1,3),psh=5,mu=mu,envir=repsp))
print(zln <- gnlr(lyp,"normal",pmu=c(0.69,-1.12,4),psh=1,mu=mul,
	envir=repsp))
print(zlc <- gnlr(lyp,"Cauchy",pmu=c(0.69,-1.12,4),psh=1,mu=mul,
	envir=repsp))
print(zll <- gnlr(lyp,"Laplace",pmu=c(0.69,-1.12,4),psh=0.085,mu=mul,
	envir=repsp))
print(zw <- gnlr(yp,"Weibull",pmu=c(1,-1,3),psh=0,mu=mu,envir=repsp))
print(zg <- gnlr(yp,"gamma",pmu=c(1,-1,3),psh=0,mu=mu,envir=repsp))

# shape function
shape <- function(p) p[4]*(p[1]+p[3]+log(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times))))
shape2 <- function(p) p[3]*(p[1]+p[2]+log(dose*times)-exp(p[1])*times)
print(znv <- gnlr(yp,"normal",pmu=c(0.1,-0.2,4),
	psh=c(3.73,-0.64,-6.1,0.54),mu=mu,shape=shape,envir=repsp))
print(zlnv <- gnlr(lyp,"normal",pmu=c(0.1,-0.2,4),psh=c(-0.8,0.5,0.8,0),
	mu=mul,shape=shape,envir=repsp))
print(zlcv <- gnlr(lyp,"Cauchy",pmu=c(0.1,-0.2,4),psh=c(2.4,-2,-2,0),
	mu=mul,shape=shape,envir=repsp,iter=200))
print(zllv <- gnlr(lyp,"Laplace",pmu=c(0.36,-0.46,4.1),psh=c(0.4,4,8,0),
	mu=mul,shape=shape,envir=repsp))
print(zwv <- gnlr(yp,"Weibull",pmu=c(0.1,-0.2,4),
	psh=c(0.7,-0.56,-1.1,0.1),mu=mu,shape=shape,envir=repsp))
print(zgv <- gnlr(yp,"gamma",pmu=c(0.1,-0.2,4),
	psh=c(0.7,-0.56,-1.1,0.3),mu=mu,shape=shape,envir=repsp))

# fixed effects
mufe <- function(p,linear) exp(p[1]-linear)*dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times))
mulfe <- function(p,linear) p[1]-linear+log(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times)))
print(znvfe <- gnlr(yp,"normal",mu=mufe,
	pmu=c(1.4,-0.7,4,rep(0,17)),psh=c(7,-0.56,-1.1,0.3),
	shape=shape,linear=~subject,envir=repsp))
print(zlnvfe <- gnlr(lyp,"normal",pmu=c(1.4,-0.7,3,rep(0,17)),
	psh=c(0.68,1.03,3.64,-0.11),mu=mulfe,shape=shape,linear=~subject,
	envir=repsp))
print(zlcvfe <- gnlr(lyp,"Cauchy",pmu=c(1.4,-0.7,3,rep(0,17)),
	psh=c(-0.94,-0.68,0.94,-0.78),mu=mulfe,shape=shape,linear=~subject,
	envir=repsp,iter=200))
print(zllvfe <- gnlr(lyp,"Laplace",pmu=c(1.4,-0.7,3,rep(0,17)),
	mu=mulfe,psh=c(-0.019,-1.7,-2.35,-0.69),shape=shape,linear=~subject,
	envir=repsp))
print(zwvfe <- gnlr(yp,"Weibull",mu=mufe,
	pmu=c(1.4,-0.7,3,rep(0,17)),psh=c(0.2,-1.4,-2.6,0.86),
	shape=shape,linear=~subject,envir=repsp,iter=200))
print(zgvfe <- gnlr(yp,"gamma",mu=mufe,
	pmu=c(1.4,-0.7,3,rep(0,17)),psh=c(0.7,-0.56,-1.1,0.3),
	shape=shape,linear=~subject,envir=repsp))

if(interactive()){
d <- density(c(zgvfe$coefficients[4:20],-sum(zgvfe$coefficients[4:20])))
postscript("floskd.eps",height=5,width=5)
plot(d$x,d$y,type="l",xlab="Fixed effect for volume",ylab="Density",
	ylim=c(0,0.8))
lines(seq(-3,3,by=0.1),dnorm(seq(-3,3,by=0.1),0,
	sd(-c(zgvfe$coefficients[4:20],-sum(zgvfe$coefficients[4:20])))),lty=3)
dev.off()
}

# without censoring
shapel12 <- function(p) p[1]+p[3]+p[4]*log(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*times)-exp(-exp(p[1])*times)))
print(zlnv12 <- gnlr(lyp,"normal",pmu=c(0.82,-0.92,4.42),
	psh=c(5.76,2.36,-6.5,-0.1),mu=mul,shape=shapel12,envir=repscp12,
	iter=200))
print(zlnv24 <- gnlr(lyp,"normal",pmu=c(1,-1,4.5),
	psh=c(0.8,0.5,0.8,-0.1),mu=mul,shape=shape,envir=repscp24))
shape24 <- function(p) p[2]+p[3]*log(dose/exp(p[1])*(1-exp(-exp(p[1])*times)))
print(zgv12 <- gnlr(yp,"gamma",pmu=c(0.8,-1,4.24),
	psh=c(-0.17,-1,-2,2),mu=mu,shape=shape,envir=repscp12))
print(zgv24 <- gnlr(yp,"gamma",pmu=c(1.1,-1.7,4.6),
	psh=c(-0.07,1.5,-0.3),mu=mu,shape=shape24,envir=repscp24))

#covariates
print(zgcov <- gnlr(yp,"gamma",pmu=c(-0.78,1.26,1.7,-0.47,0.03,0.05,
	-0.038,-0.005),psh=c(-0.14,-1,-2.75,1.43),mu=mufe,shape=shape,
	linear=~sex+age+bilirubin+gammagt+cc,envir=repsp))

# metabolite
# constant shape
print(zmn <- gnlr(ym,"normal",pmu=c(-0.17,-3.8,4),psh=0,mu=mu,envir=repsm))
print(zmln <- gnlr(lym,"normal",pmu=c(-0.17,-3.8,4),psh=1,mu=mul,
	envir=repsm))
print(zmlc <- gnlr(lym,"Cauchy",pmu=c(-0.17,-3.8,4),psh=1,mu=mul,
	envir=repsm))
print(zmll <- gnlr(lym,"Laplace",pmu=c(-0.24,-3.8,3.8),psh=1,mu=mul,
	envir=repsm))
print(zmw <- gnlr(ym,"Weibull",pmu=c(-0.17,-3.8,4),psh=0,mu=mu,
	envir=repsm))
print(zmg <- gnlr(ym,"gamma",pmu=c(-0.17,-3.8,4),psh=0,mu=mu,
	envir=repsm))

# shape function
print(zmnv <- gnlr(ym,"normal",pmu=c(-0.17,-3.8,4),
	psh=c(-3.8,-0.17,-0.2,1),mu=mu,shape=shape,envir=repsm))
print(zmlnv <- gnlr(lym,"normal",pmu=c(-0.17,-3.8,4),mu=mul,
	psh=c(-3.8,-0.17,-0.22,0),shape=shape,envir=repsm))
print(zmlnv2 <- gnlr(lym,"normal",pmu=c(-0.17,-3.8,4),mu=mul,
	psh=c(-3.3,,-0.22,0),shape=shape2,envir=repsm))
print(zmlcv <- gnlr(lym,"Cauchy",pmu=c(-0.17,-3.8,4),mu=mul,
	psh=c(-3.8,-0.17,-0.22,0),shape=shape,envir=repsm))
print(zmlcv2 <- gnlr(lym,"Cauchy",pmu=c(-0.17,-3.8,4),mu=mul,
	psh=c(-3.3,,-0.22,0),shape=shape2,envir=repsm))
print(zmllv <- gnlr(lym,"Laplace",pmu=c(-0.17,-3.8,4),mu=mul,
	psh=c(-3.29,-3.3,2.51,-0.29),shape=shape,envir=repsm))
print(zmllv2 <- gnlr(lym,"Laplace",pmu=c(-0.26,-3.8,4),mu=mul,
	psh=c(-3.3,2.51,-0.29),shape=shape2,envir=repsm))
print(zmwv <- gnlr(ym,"Weibull",pmu=c(-0.17,-3.8,4),
	psh=c(-3.8,-0.17,-0.2,1),mu=mu,shape=shape,envir=repsm))
print(zmgv <- gnlr(ym,"gamma",pmu=c(-0.17,-3.8,4),
	psh=c(-3.8,-0.17,-0.2,1),mu=mu,shape=shape,envir=repsm))

# fixed effects
print(zmnvfe <- gnlr(ym,"normal",pmu=c(-0.17,-3.8,4,0.0064,0.178,
	0.0092,0.143,0.151,0.255,0.071,-0.197,0.234,-0.11,0.118,0.072,
	-0.176,-0.384,0.1,-0.262,-0.0038),psh=c(-2.88,0.23,-1),
	mu=mufe,shape=shape2,linear=~subject,envir=repsm,iter=300))
print(zmlnvfe <- gnlr(lym,"normal",pmu=c(-0.17,-3.8,4,rep(0,17)),
	mu=mulfe,psh=c(-3.8,-0.17,-0.22),shape=shape2,linear=~subject,
	envir=repsm))
print(zmlcvfe <- gnlr(lym,"Cauchy",pmu=c(-0.17,-3.8,4,0.037,0.22,
	0.0062,0.17,0.029,0.29,0.11,-0.18,0.25,-0.15,0.099,0.11,
	-0.16,-0.35,0.12,-0.24,-0.085),psh=c(-2.8,2.78,-0.93),
	mu=mulfe,shape=shape2,linear=~subject,envir=repsm,iter=200))
print(zmllvfe <- gnlr(lym,"Laplace",pmu=c(-0.17,-3.8,4,0.026,0.21,
	0.0075,0.15,0.057,0.266,0.087,-0.184,0.242,-0.122,0.105,0.116,
	-0.163,-0.36,0.118,-0.245,-0.07),psh=c(-3.045,1.01,-0.54),
	mu=mulfe,shape=shape2,linear=~subject,envir=repsm))
print(zmwvfe <- gnlr(ym,"Weibull",pmu=c(-0.17,-3.8,4,0.032,0.21,
	0.0064,0.154,0.073,0.26,0.1,-0.18,0.24,-0.12,0.087,0.0057,
	-0.153,-0.35,0.11,-0.235,-0.025),psh=c(-3.10,0.83,0.537),
	mu=mufe,shape=shape2,linear=~subject,envir=repsm,iter=200))
print(zmgvfe <- gnlr(ym,"gamma",pmu=c(-0.33,-3.8,3.8,0.0023,0.18,
	0.0075,0.14,0.15,0.26,0.073,-0.2,0.23,-0.11,0.12,0.075,
	-0.18,-0.38,0.098,-0.26,-0.00065),psh=c(-3.17,0.26,1.15),
	mu=mufe,shape=shape2,linear=~subject,envir=repsm,iter=200))

#covariates
print(zmgcov <- gnlr(ym,"gamma",pmu=c(-3.8,-0.31,-0.33,-0.11,0.016,-0.0009,
	0.0087,0.0046),psh=c(-3.15,0.43,1),mu=mufe,shape=shape2,
	linear=~sex+bilirubin+alkphos+gammagt+cc,envir=repsm,iter=200))

if(interactive()){
mug <- function(t,dose) exp(zgv$coef[1]-zgv$coef[3]) * dose/
	(exp(zgv$coef[1]) - exp(zgv$coef[2])) * (exp(-exp(zgv$coef[2]) * t) - 
        exp(-exp(zgv$coef[1]) * t))
muln1 <- function(t,dose) exp(zlnv$coef[1]-zlnv$coef[3])*dose/
	(exp(zlnv$coef[1])-exp(zlnv$coef[2]))*(exp(-exp(zlnv$coef[2])*t)-
        exp(-exp(zlnv$coef[1])*t))
mulnv1 <- function(t,dose) exp(zlnv$coef[1]-zlnv$coef[3]+
	log(dose/(exp(zlnv$coef[1])-exp(zlnv$coef[2]))*(exp(-exp(zlnv$coef[2])
	*t)-exp(-exp(zlnv$coef[1])*t)))+exp(zlnv$coef[7]*(zlnv$coef[4]+3.6812+
	log(dose/(exp(zlnv$coef[4])-exp(zlnv$coef[5]))*(exp(-exp(zlnv$coef[5])
 	*t)-exp(-exp(zlnv$coef[4]) * t)))))/2)
mun <- function(t,dose) exp(zmnv$coef[1]-zmnv$coef[3])*dose/(exp(zmnv$coef[1])
	-exp(zmnv$coef[2]))*(exp(-exp(zmnv$coef[2])*t)-
	exp(-exp(zmnv$coef[1])*t))
muln2 <- function(t,dose) exp(zmlnv$coef[1]-zmlnv$coef[3])*dose/
	(exp(zmlnv$coef[1])-exp(zmlnv$coef[2]))*
	(exp(-exp(zmlnv$coef[2])*t)-exp(-exp(zmlnv$coef[1])*t))
mulnv2 <- function(t,dose) exp(zmlnv$coef[1]-zmlnv$coef[3]+log(dose/
	(exp(zmlnv$coef[1])-exp(zmlnv$coef[2]))*(exp(-exp(zmlnv$coef[2])*t)-
	exp(-exp(zmlnv$coef[1])*t)))+exp(zmlnv$coef[4]+zmlnv$coef[6]+
	log(dose*t)-exp(zmlnv$coef[4])*t)^zmlnv$coef[7]/2)
postscript("flos2d.eps",height=5)
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
tt <- c(seq(0.01,0.09,by=0.01),seq(0.1,12,by=0.1))
plot(tt,mug(tt,150),ylim=c(0,5),type="l",
	ylab=expression(paste("Concentration (",mu,"g/ml)")),xlab="Hours")
lines(tt,muln1(tt,150),lty=2)
lines(tt,mulnv1(tt,150),lty=3)
points(times(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150],
	response(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150,1],
	pch=20)
tt <- c(0.01,seq(0.1,96,by=0.5))
plot(tt,mun(tt,150),ylim=c(0,5),type="l",
	ylab="",xlab="Hours")
lines(tt,muln2(tt,150),lty=2)
lines(tt,mulnv2(tt,150),lty=3)
points(times(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150],
	response(repsm)[covariates(repsm,name="dose")[covind(repsm)]==150,1],
	pch=20)
dev.off()

mugnc <- function(t,dose) exp(zgv12$coef[1]-zgv12$coef[3]) * dose/
	(exp(zgv12$coef[1]) - exp(zgv12$coef[2])) * (exp(-exp(zgv12$coef[2])
         * t) - exp(-exp(zgv12$coef[1]) * t))
mugnc2 <- function(t,dose) exp(zgv24$coef[1]-zgv24$coef[3]) * dose/
	(exp(zgv24$coef[1]) - exp(zgv24$coef[2])) * (exp(-exp(zgv24$coef[2])
         * t) - exp(-exp(zgv24$coef[1]) * t))
postscript("flosncc.eps",width=5,height=5)
par(mfrow=c(1,1),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
tt <- c(seq(0.01,0.09,by=0.01),seq(0.1,12,by=0.1))
plot(tt,mug(tt,150),ylim=c(0,5),type="l",
	ylab=expression(paste("Concentration (",mu,"g/ml)")),xlab="Hours")
lines(tt,mugnc(tt,150),lty=2)
lines(tt,mugnc2(tt,150),lty=3)
points(times(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150],
	response(repsp)[covariates(repsp,name="dose")[covind(repsp)]==150,1],
	pch=20)
dev.off()
}
