library(gnlm)
library(repeated)

data <- as.matrix(read.table("ulcer.dat",skip=5)-1)
resp <- restovec(data,times=c(0,2,4,5,8),name="symptom") 
tcc <- tcctomat(c(rep(0,30),rep(1,29)),name="treatment")
reps <- rmna(resp,ccov=tcc)

### multinomial
hidden(reps,dist="multi",pgamma=1,mu=~1,pmu=rep(1,5))
hidden(reps,dist="multi",pgamma=1,mu=~treatment,pmu=rep(1,10))
hidden(reps,dist="multi",pgamma=1,mu=~times,pmu=rep(1,10))
hidden(reps,dist="multi",pgamma=1,mu=~times+treatment,pmu=rep(1,15))
hidden(reps,dist="multi",pgamma=1,mu=~times*treatment,pmu=rep(1,20),iter=200)

### ordinal
nordr(reps,mu=~treatment,pint=(1:4)/4,pmu=c(1,0))
nordr(reps,mu=~times,pint=(1:4)/4,pmu=c(1,0))
nordr(reps,mu=~times+treatment,pint=(1:4)/4,pmu=c(1,0,0))
nordr(reps,mu=~times*treatment,pint=(1:4)/4,pmu=c(1,0,0,0))
nordr(reps,dist="cont",mu=~treatment,pint=(1:4)/4,pmu=c(1,0))
nordr(reps,dist="cont",mu=~times,pint=(1:4)/4,pmu=c(1,0))
nordr(reps,dist="cont",mu=~times+treatment,pint=(1:4)/4,pmu=c(1,0,0))
nordr(reps,dist="cont",mu=~times*treatment,pint=(1:4)/4,pmu=c(1,0,0,0))
nordr(reps,dist="adj",mu=~treatment,pint=(1:4)/4,pmu=c(1,0))
nordr(reps,dist="adj",mu=~times,pint=(1:4)/4,pmu=c(1,0))
nordr(reps,dist="adj",mu=~times+treatment,pint=(1:4)/4,pmu=c(1,0,0))
nordr(reps,dist="adj",mu=~times*treatment,pint=(1:4)/4,pmu=c(1,0,0,0))
# or
#hidden(reps,dist="prop",pgamma=1,mu=~treatment,pint=(1:5)-3,pmu=1)
#hidden(reps,dist="cont",pgamma=1,mu=~treatment,pint=(1:5)-3,pmu=1)

### random walk Markov chain
# likelihood without marginal initial state
pp <- rep(1,2)
mc <- function(p){
	pp[1] <- exp(p[1])/(1+exp(p[1])+exp(p[2]))
	pp[2] <- exp(p[2])/(1+exp(p[1])+exp(p[2]))
	like <- 0
	for(i in 1:4)like <- like-sum((data[num,i]>data[num,i+1])*log(pp[1])+
		(data[num,i]==data[num,i+1])*
		log(1-(data[num,i]>0)*pp[1]-(data[num,i]<5)*pp[2])
		+(data[num,i]<data[num,i+1])*log(pp[2]))
	like}

# no treatment difference
num <- 1:59
print(z <- nlm(mc,c(1,1),hess=T))
sqrt(diag(solve(z$hess)))
print(p <- c(exp(z$est[1])/(1+exp(z$est[1])+exp(z$est[2])),
	1/(1+exp(z$est[1])+exp(z$est[2])),
	exp(z$est[2])/(1+exp(z$est[1])+exp(z$est[2]))))
#transition matrix
mat <- matrix(0,ncol=6,nrow=6)
diag(mat) <- 1-p[1]-p[3]
mat[1,1] <- 1-p[3]
mat[6,6] <- 1-p[1]
mat[cbind(1:5,2:6)] <- p[3]
mat[cbind(2:6,1:5)] <- p[1]
mat
# stationary state margin
gmod <- t(mat)
diag(gmod) <- diag(gmod)-1
gmod[1,] <- 1
print(marg <- solve(gmod,c(1,rep(0,5))))
marg%*%mat
# observed margin
c(0,table(data[,1])/59)
# total log likelihood and AIC
-sum(log((table(data[,1])/59)[data[,1]]))+z$min
-sum(log((table(data[,1])/59)[data[,1]]))+z$min+7
# if stationary
-sum(log(marg[data[,1]+1]))+z$min
-sum(log(marg[data[,1]+1]))+z$min+2

# treatment difference
# control group
num <- 1:30
print(z1 <- nlm(mc,c(1,1),hess=T))
sqrt(diag(solve(z1$hess)))
print(p1 <- c(exp(z1$est[1])/(1+exp(z1$est[1])+exp(z1$est[2])),
	1/(1+exp(z1$est[1])+exp(z1$est[2])),
	exp(z1$est[2])/(1+exp(z1$est[1])+exp(z1$est[2]))))
mat1 <- matrix(0,ncol=6,nrow=6)
diag(mat1) <- 1-p1[1]-p1[3]
mat1[1,1] <- 1-p1[3]
mat1[6,6] <- 1-p1[1]
mat1[cbind(1:5,2:6)] <- p1[3]
mat1[cbind(2:6,1:5)] <- p1[1]
mat1
# stationary state margin
gmod <- t(mat1)
diag(gmod) <- diag(gmod)-1
gmod[1,] <- 1
print(marg1 <- solve(gmod,c(1,rep(0,5))))
marg1%*%mat1
# observed margin
c(0,table(data[1:30,1])/30)

# treatment group
num <- 31:59
print(z2 <- nlm(mc,c(1,1),hess=T))
sqrt(diag(solve(z2$hess)))
print(p2 <- c(exp(z2$est[1])/(1+exp(z2$est[1])+exp(z2$est[2])),
	1/(1+exp(z2$est[1])+exp(z2$est[2])),
	exp(z2$est[2])/(1+exp(z2$est[1])+exp(z2$est[2]))))
mat2 <- matrix(0,ncol=6,nrow=6)
diag(mat2) <- 1-p2[1]-p2[3]
mat2[1,1] <- 1-p2[3]
mat2[6,6] <- 1-p2[1]
mat2[cbind(1:5,2:6)] <- p2[3]
mat2[cbind(2:6,1:5)] <- p2[1]
mat2
# stationary state margin
gmod <- t(mat2)
diag(gmod) <- diag(gmod)-1
gmod[1,] <- 1
print(marg2 <- solve(gmod,c(1,rep(0,5))))
marg2%*%mat2
# observed margin
c(0,table(data[31:59,1])/29)

# total log likelihood and AIC
-sum(log(c((table(data[1:30,1])/30)[data[1:30,1]],
	table(data[31:59,1])/29)[data[31:59,1]]))+z1$min+z2$min
-sum(log(c((table(data[1:30,1])/30)[data[1:30,1]],
	table(data[31:59,1])/29)[data[31:59,1]]))+z1$min+z2$min+14
-sum(log((table(data[,1])/59)[data[,1]]))+z1$min+z2$min
-sum(log((table(data[,1])/59)[data[,1]]))+z1$min+z2$min+9
# if stationary
-sum(log(c(marg1,marg2)[data[,1]+1]))+z1$min+z2$min
-sum(log(c(marg1,marg2)[data[,1]+1]))+z1$min+z2$min+4

### hidden Markov
hidden(reps,dist="multi",pgamma=matrix(c(0.5,0.4,0.5,0.6),ncol=2),
	mu=~1,pmu=rep(1,10))
hidden(reps,dist="multi",pgamma=matrix(c(0.5,0.4,0.5,0.6),ncol=2),
	mu=~treatment,pmu=rep(1,20))
hidden(reps,dist="prop",pgamma=matrix(c(0.5,0.4,0.5,0.6),ncol=2),
	mu=~treatment,pint=c(10,-10,0,10,10,-10,10,-10,-1,1),pmu=c(-0.3,-1))
hidden(reps,dist="prop",pgamma=matrix(c(0.5,0.4,0.5,0.6),ncol=2),
	mu=~times,pint=c(10,-10,0,10,10,-10,10,-10,-1,1),pmu=c(-0.3,0))
hidden(reps,dist="prop",pgamma=matrix(c(0.5,0.4,0.5,0.6),ncol=2),
	mu=~times+treatment,pint=c(10,-10,0,10,10,-10,10,-10,-1,1),
	pmu=c(0,-0.3,0,-1))
hidden(reps,dist="cont",pgamma=matrix(c(0.5,0.4,0.5,0.6),ncol=2),
	mu=~treatment,pint=rep((1:5)-3,2),pmu=c(1,0))
