library(gnlm)
library(event)

surv <- read.surv("cancer.dat",skip=5,nline=1,cum=F,all=F)
# lagged times, observation numbers, and weights
y1 <- sh <- nr <- wt <- list()
for(i in surv[[1]]){
	nr <- c(nr,list(1:length(i)))
	wt <- c(wt,list(as.numeric((1:length(i))>1)))
	y1 <- c(y1,list(if(length(i)==1) 1
		else c(1,i[1:(length(i)-1)])))
	sh <- c(sh,list(log(y1[[length(y1)]])))}
treat <- as.factor(c(rep(1,47),rep(2,31),rep(3,38)))
tvc <- tvctomat(y1,name="y1")
tvc <- tvctomat(sh,name="sh",old=tvc)
tvc <- tvctomat(nr,name="nr",old=tvc)
repsw <- rmna(restovec(surv[[1]],censor=surv[[2]],weight=wt),
	ccov=tcctomat(treat),tvcov=tvc)
reps <- rmna(restovec(surv[[1]],censor=surv[[2]],name="surv"),
	ccov=tcctomat(treat),tvcov=tvc)
reps2 <- rmna(restovec(surv[[1]],censor=surv[[2]],name="surv"),
	ccov=tcctomat(treat,dataframe=F),tvcov=tvc)
reps2 <- transform(reps2,lsurv=log(surv))

if(interactive()){
postscript("cancer.eps",height=5)
nr <- sequence(nobs(reps))
tr <- treat[covind(reps)]
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(km(response(reps)[nr==1,1],group=tr[nr==1],
	censor=response(reps)[nr==1,2]),main="",xlab="Months",
	ylab="Nonrecurrence probability",xaxt="n")
axis(1,c(0,20,40,60))
plot(km(response(reps)[nr>1,1],group=tr[nr>1],
	censor=response(reps)[nr>1,2]),xlim=c(0,60),main="",
	xlab="Months",ylab="",xaxt="n")
axis(1,c(0,20,40,60))
legend(20,1,legend=c("Placebo","Pyridoxine","Thiotepa"),lty=1:3,bty="n")
dev.off()
}

mu <- function(p,linear) exp(linear)
shape <- function(p) sh
# independence
gnlr(repsw,"gamma",mu=~exp(a),pmu=2,pshape=0.2)
gnlr(repsw,"gamma",mu=mu,pmu=c(2.4,0,0),pshape=0.2,linear=~treat)
gnlr(repsw,"gamma",mu=mu,pmu=c(2.4,-0.4),pshape=0.2,linear=~treat==2)
gnlr(repsw,"gamma",mu=mu,pmu=c(2.4,-0.4,0),pshape=0.2,
	linear=~(treat==2)+I(nr-1))

# conditional exponential family
gnlr(repsw,"gamma",mu=~sh,pmu=c(10,0.5),shape=shape)
gnlr(repsw,"gamma",mu=~sh+treat,pmu=c(10,0,-4,-1),shape=shape)
gnlr(repsw,"gamma",mu=~sh+I(nr-1),pmu=c(10,0,-0.5),shape=shape)

# autoregression
gnlr(repsw,"gamma",mu=~y1,pmu=c(11,0.2),psh=0.2)
gnlr(repsw,"gamma",mu=~y1+treat,psh=0.2,pmu=c(11.6,0.6,-4.5,0))
gnlr(repsw,"gamma",mu=~y1+(treat==2),psh=0.2,pmu=c(11.6,0.6,-4.5))
gnlr(repsw,"gamma",mu=~y1+(treat==2)+I(nr-1),psh=0.1,pmu=c(10,2,-0.1,-1))

# autoregression on log
gnlr(repsw,"gamma",mu=mu,linear=~sh,pmu=c(2.4,0.02),psh=0.2)
gnlr(repsw,"gamma",mu=mu,linear=~sh+treat,psh=0.2,pmu=c(2.5,0.04,-0.4,0))
gnlr(repsw,"gamma",mu=mu,linear=~sh+(treat==2),psh=0.2,pmu=c(2.4,0.04,-0.4))
gnlr(repsw,"gamma",mu=mu,linear=~sh+(treat==2)+I(nr-1),psh=0.1,
	pmu=c(2.5,0.03,-0.4,0))

# conditional model with scale proportional to y_t-1
shape <- function(p) sh*p[1]
gnlr(repsw,"gamma",mu=~sh,pmu=c(11,0.2),shape=shape,psh=0.1)
gnlr(repsw,"gamma",mu=~sh+treat,pmu=c(12,0.5,-4.5,0.7),shape=shape,,psh=0.1)
gnlr(repsw,"gamma",mu=~sh+(treat==2),pmu=c(12,0.5,-4.5),shape=shape,,psh=0.1)
gnlr(repsw,"gamma",mu=~sh+(treat==2)+I(nr-1),pmu=c(12.2,0.5,-4.8,-0.09),
	shape=shape,psh=0.1)

# full model
# independence
gnlr(reps,"gamma",mu=~exp(a),pmu=3,psh=c(-0.2))
gnlr(reps,"gamma",mu=mu,linear=~treat,pmu=c(3,0,0),psh=c(-0.2))
gnlr(reps,"gamma",mu=mu,linear=~(treat==3),pmu=c(3,0),psh=c(-0.2))
gnlr(reps,"gamma",mu=mu,linear=~(treat==3)+I(nr-1),pmu=c(3,0,0),psh=c(-0.2))

# exponential dispersion model
mu <- function(p) exp(p[1]*(nr==1)+(p[2]+p[3]*y1)*(nr>1))
shape <- function(p) p[1]*(nr==1)+sh*p[2]*(nr>1)
gnlr(reps,"gamma",mu=mu,pmu=c(3.6,2.4,0.2),shape=shape,psh=c(-0.4,0.1))
mu <- function(p) exp(p[1]*(nr==1)+(p[2]+p[3]*y1)*(nr>1)+
	p[4]*treat2+p[5]*treat3)
gnlr(surv,"gamma",mu=mu,pmu=c(3.6,2.4,0.2,0.4,0),shape=shape,psh=c(-0.4,0.1),
	env=reps2)
mu <- function(p) exp(p[1]*(nr==1)+(p[2]+p[3]*y1)*(nr>1)+p[4]*treat2)
gnlr(surv,"gamma",mu=mu,pmu=c(3.6,2.4,0.2,0.4),shape=shape,psh=c(-0.4,0.1),
	env=reps2)
mu <- function(p) exp(p[1]*(nr==1)+(p[2]+p[3]*y1)*(nr>1)+
	p[4]*treat2+p[5]*(nr-1))
gnlr(surv,"gamma",mu=mu,pmu=c(3.6,2.4,0.2,0.4,0),shape=shape,psh=c(-0.4,0.1),
	env=reps2)
mu <- function(p) exp(p[1]*(nr==1)+p[2]*(nr>1)+p[3]*treat2+p[4]*(nr-1))
gnlr(surv,"gamma",mu=mu,pmu=c(3.6,2.4,0.4,0),shape=shape,psh=c(-0.4,0.1),
	env=reps2)
mu <- function(p) exp(p[1]*(nr==1)+p[2]*(nr>1)+p[3]*treat2*(nr>1)
	+p[4]*(treat2==0)*(treat3==0)*(nr==1)+p[5]*(nr-1))
gnlr(surv,"gamma",mu=mu,pmu=c(3.7,2.8,-0.4,0.7,-0.1),shape=shape,
	psh=c(-0.4,0.1),env=reps2)
mu <- function(p) exp(p[1]+p[2]*treat2+p[3]*(nr-1))
gnlr(surv,"gamma",mu=mu,pmu=c(3,0.4,0),shape=shape,psh=c(-0.4,0.1),env=reps2)

print(ze <- kalsurv(reps,pinit=1.5,preg=1,dep="frailty"))
print(zeb <- kalsurv(reps,pinit=1.5,preg=1,pbirth=0,dep="frailty"))
print(zet <- kalsurv(reps,pinit=1.5,preg=c(1,0,0),ccov=~treat,dep="frailty"))
print(zetb <- kalsurv(reps,pinit=1.5,preg=c(1,0,0),ccov=~treat,pbirth=0,
	dep="frailty"))
print(zw <- kalsurv(reps,pinit=0.1,preg=1,psh=1,intensity="Weibull",
	dep="frailty"))
print(zwb <- kalsurv(reps,pinit=1.5,preg=1,psh=1,pbirth=0,intensity="Weibull",
	dep="frailty"))
print(zwt <- kalsurv(reps,pinit=1.5,psh=1,preg=c(1,0,0),
	ccov=~treat,intensity="Weibull",dep="frailty"))
print(zwtb <- kalsurv(reps,pinit=0.1,psh=1,preg=c(1,0,0),
	ccov=~treat,pbirth=0,intensity="Weibull",dep="frailty"))
print(zln <- kalsurv(reps,pinit=0.1,preg=1,psh=1,
	intensity="log normal",dep="frailty"))
print(zlnb <- kalsurv(reps,pinit=1.5,preg=1,psh=1,
	pbirth=0,intensity="log normal",dep="frailty"))
print(zlnt <- kalsurv(reps,pinit=1.5,psh=1,preg=c(1,0,0),
	ccov=~treat,intensity="log normal",dep="frailty"))
print(zlntb <- kalsurv(reps,pinit=0.1,psh=1,preg=c(1,0,0),
	ccov=~treat,pbirth=0,intensity="log normal",dep="frailty"))

print(zei <- kalsurv(reps,pinit=1.5,preg=1,dep="independence"))
print(zeib <- kalsurv(reps,pinit=1.5,preg=1,dep="independence",pbirth=0))
print(zee <- kalsurv(reps,pinit=1.5,pdep=0.1,preg=1,dep="serial",upd="event"))
print(zeeb <- kalsurv(reps,pinit=1.5,pdep=0.5,preg=1,
	pbirth=0,dep="serial",upd="event"))
print(zes <- kalsurv(reps,pinit=1.5,pdep=0.1,preg=1,dep="serial",upd="Markov"))
print(zesb <- kalsurv(reps,pinit=1.5,pdep=0.5,preg=1,
	pbirth=0,dep="serial",upd="Markov"))
print(zec <- kalsurv(reps,pinit=1.5,pdep=0.5,preg=1,dep="serial",upd="count"))
#print(zeh <- kalsurv(reps,pinit=1.5,pdep=0.1,preg=1,
#	dep="serial",upd="cumulated"))
#print(zek <- kalsurv(reps,pinit=1.5,pdep=0.01,preg=1,dep="serial",upd="kalman"))

print(zeit <- kalsurv(reps,pinit=1.5,dep="independence",preg=c(1,0,0),
	ccov=~treat))
print(zeitb <- kalsurv(reps,pinit=1.5,dep="independence",
	pbirth=0,preg=c(1,0,0),ccov=~treat))
print(zeet <- kalsurv(reps,pinit=1.5,pdep=0.5,upd="event",
	dep="serial",preg=c(1,0,0),ccov=~treat))
print(zeetb <- kalsurv(reps,pinit=0.5,pdep=0.5,
	pbirth=0,dep="serial",upd="event",preg=c(1,0,0),ccov=~treat))
print(zest <- kalsurv(reps,pinit=0.5,pdep=0.5,upd="Markov",
	dep="serial",preg=c(1,0,0),ccov=~treat))
print(zestb <- kalsurv(reps,pinit=0.8,pdep=0.5,
	pbirth=0,dep="serial",upd="Markov",preg=c(1,0,0),ccov=~treat))
print(zect <- kalsurv(reps,pinit=0.8,pdep=0.5,upd="count",
	dep="serial",preg=c(1,0,0),ccov=~treat))
print(zectb <- kalsurv(reps,pinit=0.8,pdep=0.5,upd="count",
	dep="serial",pbirth=0,preg=c(1,0,0),ccov=~treat))
print(zeht <- kalsurv(reps,pinit=1.5,pdep=0.5,
	dep="serial",upd="cumulated",preg=c(2,1,3),ccov=~treat))
print(zekt <- kalsurv(reps,pinit=0.8,pdep=0.5,upd="kalman",
	dep="serial",preg=c(1,0,0),ccov=~treat))

print(zwi <- kalsurv(reps,pinit=0.8,preg=1,psh=1,
	dep="independence",intensity="Weibull"))
print(zwe <- kalsurv(reps,pinit=0.7,pdep=0.5,preg=3,psh=4.5,
	dep="serial",upd="event",intensity="Weibull"))
print(zwm <- kalsurv(reps,pinit=0.93,pdep=0.4,preg=2.8,psh=1.2,
	dep="serial",upd="Markov",intensity="Weibull",stepmax=5))
print(zwc <- kalsurv(reps,pinit=0.8,pdep=0.5,preg=1,psh=1,
	dep="serial",upd="count",intensity="Weibull"))
print(zwh <- kalsurv(reps,pinit=0.8,pdep=0.5,preg=1,psh=1,
	dep="serial",upd="cumulated",intensity="Weibull"))
#print(zwk <- kalsurv(reps,pinit=0.8,pdep=0.5,preg=1,psh=1,
#	dep="serial",upd="kalman",intensity="Weibull"))

print(zwit <- kalsurv(reps,pinit=0.8,psh=1,
	dep="independence",intensity="Weibull",preg=c(1,0,0),ccov=~treat))
print(zwitb <- kalsurv(reps,pinit=0.8,psh=1,pbirth=0,
	dep="independence",intensity="Weibull",preg=c(1,0,0),ccov=~treat))
print(zwet <- kalsurv(reps,pinit=0.6,pdep=0.6,psh=4.5,dep="serial",
	upd="event",intensity="Weibull",preg=c(3,0,0),ccov=~treat))
print(zwetb <- kalsurv(reps,pinit=0.8,pdep=0.01,psh=4.5,dep="serial",
	pbirth=0,upd="event",intensity="Weibull",preg=c(3,0.5,0.7),
	ccov=~treat))
print(zwmt <- kalsurv(reps,pinit=0.8,pdep=0.01,psh=4.5,dep="serial",
	upd="Markov",intensity="Weibull",preg=c(3,0,0),ccov=~treat))
print(zwmtb <- kalsurv(reps,pinit=0.8,pdep=0.01,psh=4.5,dep="serial",
	pbirth=0,upd="Markov",intensity="Weibull",preg=c(3,0.5,0.7),
	ccov=~treat))
print(zwct <- kalsurv(reps,pinit=0.8,pdep=0.5,psh=1, dep="serial",
	upd="count",intensity="Weibull",preg=c(1,0,0),ccov=~treat))
print(zwctb <- kalsurv(reps,pinit=0.8,pdep=0.5,psh=1, dep="serial",
	pbirth=0,upd="count",intensity="Weibull",preg=c(1,0,0),ccov=~treat))
print(zwht <- kalsurv(reps,pinit=0.8,pdep=0.6,psh=1,dep="serial",
	upd="cumulated",intensity="Weibull",preg=c(1,0,0),ccov=~treat))
print(zwkt <- kalsurv(reps,pinit=0.1,pdep=0.9,psh=0.8,dep="serial",
	upd="kalman",intensity="Weibull",preg=c(1,0.5,0.7),ccov=~treat))

print(zgit <- kalsurv(reps,pinit=1,psh=4,dep="independence",
	intensity="gamma",preg=c(0.5,-0.156,-0.186),ccov=~treat))
print(zgitb <- kalsurv(reps,pinit=2.94,psh=3.73,pbirth=-0.1,
	dep="independence",intensity="gamma",preg=c(0.6,-0.24,-0.34),
	ccov=~treat))

print(zlni <- kalsurv(reps,pinit=0.8,psh=1,
	dep="independence",intensity="log normal",preg=1))
print(zlnit <- kalsurv(reps,pinit=0.8,psh=1,
	dep="independence",intensity="log normal",preg=c(1,0,0),ccov=~treat))
print(zlnitb <- kalsurv(reps,pinit=0.8,psh=1,
	pbirth=0,dep="independence",intensity="log normal",preg=c(1,0,0),
	ccov=~treat))
print(zlnm <- kalsurv(reps,pinit=0.8,psh=0.5,pdep=0.1,dep="serial",
	upd="Markov",intensity="log normal",preg=4))
print(zlnmb <- kalsurv(reps,pinit=0.8,psh=0.5,pdep=0.1,dep="serial",
	pbirth=0,upd="Markov",intensity="log normal",preg=4))
print(zlnmt <- kalsurv(reps,pinit=0.8,psh=0.5,pdep=0.1,dep="serial",
	upd="Markov",intensity="log normal",preg=c(4,0.1,0.2),ccov=~treat))
print(zlnmtb <- kalsurv(reps,pinit=0.8,psh=0.5,pdep=0.1,dep="serial",
	pbirth=0,upd="Markov",intensity="log normal",preg=c(4,0.1,0.2),
	ccov=~treat))
print(zlnc <- kalsurv(reps,pinit=0.8,psh=0.5,pdep=0.1,dep="serial",
	upd="count",intensity="log normal",preg=4))
print(zlncb <- kalsurv(reps,pinit=0.8,psh=0.5,pdep=0.99,dep="serial",
	pbirth=0,upd="count",intensity="log normal",preg=4))
print(zlnct <- kalsurv(reps,pinit=0.8,psh=0.5,pdep=0.99,dep="serial",
	upd="count",intensity="log normal",preg=c(4,0.1,0.2),ccov=~treat))
print(zlnctb <- kalsurv(reps,pinit=0.8,psh=0.5,pdep=0.99,dep="serial",
	pbirth=0,upd="count",intensity="log normal",preg=c(4,0.1,0.2),
	ccov=~treat))
print(zpvflnctb <- kalsurv(reps,pinit=0.8,psh=0.5,pdep=0.99,dep="serial",
	pbirth=0,upd="count",intensity="log normal",preg=c(4,0.1,0.2),
	ccov=~treat,pfam=0.1))
if(interactive()){
postscript("cancerprof.eps",height=8,width=8)
par(mfrow=c(2,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(iprofile(zlncb),nind=45,lty=2,pch=20,xlab="")
plot(mprofile(zlnmb),nind=45,add=T)
plot(iprofile(zlnmb),nind=45,add=T,lty=3,obs=F)
plot(iprofile(zlncb),nind=63,lty=2,pch=20,xlab="",ylab="")
plot(mprofile(zlnmb),nind=63,add=T)
plot(iprofile(zlnmb),nind=63,add=T,lty=3,obs=F)
legend(10,60,legend=c("Marginal profile","Markov update","Count update"),
	lty=1:3,bty="n")
plot(iprofile(zlncb),nind=76,lty=2,pch=20)
plot(mprofile(zlnmb),nind=76,add=T)
plot(iprofile(zlnmb),nind=76,add=T,lty=3,obs=F)
plot(iprofile(zlncb),nind=101,lty=2,pch=20,ylab="")
plot(mprofile(zlnmb),nind=101,add=T)
plot(iprofile(zlnmb),nind=101,add=T,lty=3,obs=F)
dev.off()
}

print(zllit <- kalsurv(reps,pinit=0.8,psh=1,
	dep="independence",intensity="log logistic",preg=c(1,0,0),ccov=~treat))
print(zllitb <- kalsurv(reps,pinit=0.8,psh=1,
	pbirth=0,dep="independence",intensity="log logistic",preg=c(1,0,0),
	ccov=~treat))

print(zlcit <- kalsurv(reps,pinit=0.8,psh=0.72,dep="independence",
	intensity="log Cauchy",preg=c(1,0.1,0.4),ccov=~treat))
print(zlcitb <- kalsurv(reps,pinit=0.8,psh=0.72,pbirth=-0.1,
	dep="independence",intensity="log Cauchy",preg=c(1.8,-0.1,-0.4),
	ccov=~treat))

mu <- function(p) exp(p[1])
gnlr(surv,"exponential",pmu=3,mu=mu,env=reps2)
gnlr(surv,"Weibull",pmu=3,pshape=0,mu=mu,env=reps2)
gnlr(surv,"gamma",pmu=3,pshape=0,mu=mu,env=reps2)
gnlr(lsurv,"normal",pmu=2,pshape=0.5,env=reps2)
gnlr3(surv,"Burr",pmu=2,pshape=0.6,pfam=-0.3,mu=mu,env=reps2)
mu <- function(p) exp(p[1]+p[2]*treat2+p[3]*treat3)
gnlr(surv,"exponential",pmu=c(8,-1,-1),mu=mu,env=reps2)
gnlr(surv,"Weibull",pmu=c(8,-1,-1),pshape=0,mu=mu,env=reps2)
gnlr(lsurv,"normal",pmu=c(2,0,0),pshape=0.11,mu=~treat2+treat3,env=reps2)
gnlr3(surv,"Burr",pmu=c(5,0,0),pshape=0.6,pfam=-0.3,mu=mu,env=reps2)
mu <- function(p) exp(p[1]+p[2]*treat2+p[3]*treat3+p[4]*log(nr))
gnlr(surv,"exponential",pmu=c(8,-1,0,0),mu=mu,env=reps2)
gnlr(surv,"Weibull",pmu=c(8,-1,0,0),pshape=0,mu=mu,env=reps2)
gnlr(lsurv,"normal",pmu=c(2,0,0,0),pshape=0.11,mu=~treat2+treat3+log(nr),
	env=reps2)
gnlr3(surv,"Burr",pmu=c(5,0,0,0),pshape=0.6,pfam=-0.3,mu=mu,env=reps2)
