library(gnlm)
library(repeated)

y <- read.table("polyp.dat",skip=5)
treatment <- y[[1]]
sex <- y[[2]]
base1 <- y[[3]]
base2 <- y[[4]]
base <- ifelse(is.na(base2),base1,(base1+base2)/2)
y <- y[5:20]
resp <- restovec(y)
cov <- tcctomat(data.frame(treatment=as.factor(treatment),sex,base,base1))
reps <- rmna(resp,ccov=cov)
yy <- ifelse(response(reps)==0,1,response(reps))
dev <- function(z)
	2*sum(z$fit-response(reps)-response(reps)*(log(z$fit)-log(yy)))

mu <- function(p,linear) exp(linear)
gnlr(reps,"Poisson",mu=~exp(a),pmu=1)
gnlr(reps,"Poisson",mu=mu,linear=~times,pmu=c(1.9,0))
gnlr(reps,"Poisson",mu=mu,linear=~times+base,pmu=c(1.9,-0.016,0))
gnlr(reps,"Poisson",mu=mu,linear=~times+base1,pmu=c(1.9,-0.016,0))
gnlr(reps,"Poisson",mu=mu,linear=~times+base+sex,pmu=c(1.4,-0.018,0.06,0))
print(z0 <- gnlr(reps,"Poisson",mu=mu,linear=~times+base+sex+treatment,
	pmu=c(1.7,-0.019,0.055,-0.38,0,0)))
dev(z0)
gnlr(reps,"negative bin",mu=mu,linear=~times+base+sex+treatment,
	pmu=c(1.7,-0.019,0.055,-0.38,0,0),psh=0.5)
gnlr(reps,"negative bin",mu=mu,linear=~times+base+sex+treatment+I(times^2),
	pmu=c(1.48,-0.015,0.084,-0.23,-0.64,-0.64,0.064),psh=0.5)
print(z <- gnlr(reps,"negative bin",mu=mu,
	linear=~times+base+sex+treatment*base,
	pmu=c(1.32,-0.015,0.11,-0.24,-0.16,-0.41,0,0),psh=0.5))
gnlr(reps,"negative bin",mu=mu,linear=~times+base+sex+treatment*(base+times),
	pmu=c(1.48,-0.015,0.084,-0.23,-0.64,-0.64,0.064,0.03,0,0),psh=0.5)
gnlr(reps,"negative bin",mu=mu,linear=~times+base+sex+treatment*(base+sex),
	pmu=c(1.48,-0.015,0.084,-0.23,-0.64,-0.64,0.064,0.03,0,0),psh=0.5)
gnlr(reps,"negative bin",mu=mu,linear=~times+base+sex+treatment*(base+sex)
	+sex:base,psh=0.5,
	pmu=c(1.8,-0.017,0.079,-0.92,-1.36,-1.37,0.075,0.037,1.18,1.26,0))

mulog <- function(p,linear) p[1]/(1+exp(-(linear)))
gnlr(reps,"Poisson",mu=mulog,linear=~times+base+sex+treatment,
	pmu=c(100,-1.7,-0.019,0.078,-0.38,0,-0.68))
gnlr(reps,"Poisson",mu=mulog,linear=~times+base1+sex+treatment,
	pmu=c(100,-1.7,-0.019,0.078,-0.38,0,-0.68))
gnlr(reps,"negative bin",mu=mulog,linear=~times+base+sex+treatment,
	pmu=c(62,-2.3,-0.019,0.078,-0.38,0,-0.68),psh=0.25)
mull <- function(p,linear) p[1]*exp(-exp(linear))
gnlr(reps,"Poisson",mu=mull,linear=~times+base+sex+treatment,
	pmu=c(100,1.7,-0.019,0.055,-0.38,0,0))
mucll <- function(p,linear) p[1]*(1-exp(-exp(linear)))
gnlr(reps,"Poisson",mu=mucll,linear=~times+base+sex+treatment,
	pmu=c(45,-2,-0.018,0.075,-0.36,-0.01,-0.67))
gnlr(reps,"negative bin",mu=mucll,linear=~times+base+sex+treatment,
	pmu=c(45,-2,-0.018,0.075,-0.36,-0.01,-0.67),psh=1)

cov1 <- tcctomat(data.frame(treatment=as.factor(treatment),sex,base,base1),
	datafr=F)
reps1 <- rmna(resp,ccov=cov1)
muexp0 <- ~exp(b0+b1*times+b2*base+b3*sex+b4*treatment1+b5*treatment2)
gar(reps1,"negative bin",mu=muexp0,pdep=0.9,
	preg=c(1.65,0.02,0.16,-0.19,0,-0.68),psh=0.53)
muexp0a <-  ~exp(b0+b1*times+b2*base+b3*sex+b4*treatment1+b5*treatment2
	+(b6*treatment1+b7*treatment2)*times)
gar(reps1,"negative bin",mu=muexp0a,pdep=0.76,
	preg=c(-1.65,0.02,0.16,-0.19,0,-0.68,0,0),psh=0.53)
muexp0b <-  ~exp(b0+b1*times+b2*base+b3*sex+b4*treatment1+b5*treatment2
	+(b6*treatment1+b7*treatment2)*base)
gar(reps1,"negative bin",mu=muexp0b,pdep=0.76,
	preg=c(-1.65,0.02,0.16,-0.19,0,-0.68,0,0),psh=0.53)
muexp0c <-  ~exp(b0+b1*times+b2*base+b3*sex+b4*treatment1+b5*treatment2
	+(b6*treatment1+b7*treatment2)*sex)
gar(reps1,"negative bin",mu=muexp0c,pdep=0.76,
	preg=c(-1.65,0.02,0.16,-0.19,0,-0.68,0,0),psh=0.53)
muexp0d <-  ~exp(b0+b1*times+b2*base+b3*sex+b4*treatment1+b5*treatment2
	+(b6*treatment1+b7*treatment2)*base+(b8*treatment1+b9*treatment2)*sex)
print(zar <- gar(reps1,"negative bin",mu=muexp0d,pdep=0.68,psh=0.58,
	preg=c(1.72,-0.006,0.067,-0.59,-1.12,-0.76,0.059,0.01,0.93,0.61)))
muexp0e <-  ~exp(b0+b2*base+b3*sex+b4*treatment1+b5*treatment2
	+(b6*treatment1+b7*treatment2)*base+(b8*treatment1+b9*treatment2)*sex)
print(zar2 <- gar(reps1,"negative bin",mu=muexp0e,pdep=0.68,psh=0.58,
	preg=c(1.72,0.067,-0.59,-1.12,-0.76,0.059,0.01,0.93,0.61)))
muexp0f <-  ~exp(b0+b2*base+b3*sex+b4*treatment1+b5*treatment2
	+b6*treatment1*base+(b8*treatment1+b9*treatment2)*sex)
print(zar3 <- gar(reps1,"negative bin",mu=muexp0f,pdep=0.68,psh=0.58,
	preg=c(1.72,0.067,-0.59,-1.12,-0.76,0.059,0.93,0.61)))
print(zar3a <- gar(reps1,"Poisson",mu=muexp0f,pdep=0.68,
	preg=c(1.72,0.067,-0.59,-1.12,-0.76,0.059,0.93,0.61)))
muexp0g <-  ~exp(b0+b2*base+b3*sex+b4*treatment1+b5*treatment2
	+b6*treatment1*base+(b8*treatment1+b9*treatment2)*sex
	+b1*times+b10*sex*times+(b11*treatment1+b12*treatment2)*times
	+(b13*treatment1+b14*treatment2)*times*sex)
print(zar3b <- gar(reps1,"negative bin",mu=muexp0g,pdep=0.68,psh=0.58,
	preg=c(1.72,0.067,-0.59,-1.12,-0.76,0.059,0.93,0.61,0,0,0,0,0,0)))

mulog1 <- ~exp(asymptote)/(1+exp(-(b0+b1*times+b2*base+b3*sex+
	b4*treatment1+b5*treatment2)))
gar(reps1,"negative bin",mu=mulog1,pdep=0.5,
	preg=c(3,-2.2,-0.017,0.17,-0.23,-0.38,-0.62),psh=0.53)
mulog1a <- ~exp(asymptote)/(1+exp(-(b0+b1*times+b2*base+b3*sex+
	b4*treatment1+b5*treatment2+(b6*treatment1+b7*treatment2)*times)))
gar(reps1,"negative bin",mu=mulog1a,pdep=0.8,
	preg=c(3,-1.5,0.02,0.26,0.15,-0.093,-0.56,0,0),psh=0.52)
mulog1b <- ~exp(asymptote)/(1+exp(-(b0+b1*times+b2*base+b3*sex+
	b4*treatment1+b5*treatment2+(b6*treatment1+b7*treatment2)*base)))
gar(reps1,"negative bin",mu=mulog1b,pdep=0.76,
	preg=c(3,-1.92,0,0.13,-0.22,-0.33,-0.047,0.074,-0.079),psh=0.54)
mulog1f <- ~exp(asymptote)/(1+exp(-(b0+b2*base+b3*sex+b4*treatment1+
	b5*treatment2+b6*treatment1*base+(b8*treatment1+b9*treatment2)*sex)))
print(zarlog <- gar(reps1,"negative bin",mu=mulog1f,pdep=0.76,
	preg=c(3,1.72,0.067,-0.59,-1.12,-0.76,0.059,0.93,0.61),psh=0.54))
mulog1h <- ~exp(asymptote)/(1+exp(-(b0+b1*times+b2*base+b3*sex+b4*treatment1
	+b5*treatment2+b6*treatment1*base+(b8*treatment1+b9*treatment2)*sex)))
gar(reps1,"negative bin",mu=mulog1h,pdep=0.67,
	preg=c(3.75,-2,0,0.11,-0.79,-1.17,-0.96,0.073,0.91,0.84),psh=0.59)

mucll1 <- ~exp(asymptote)*(1-exp(-exp(b0+b1*times+b2*base+b3*sex+
	b4*treatment1+b5*treatment2)))
gar(reps1,"negative bin",mu=mucll1,pdep=0.76,
	preg=c(4,-2,-0.019,0.078,-0.38,0,-0.68),psh=0.54)
mucll1f <- ~exp(asymptote)*(1-exp(-exp(b0+b2*base+b3*sex+b4*treatment1+
	b5*treatment2+b6*treatment1*base+(b8*treatment1+b9*treatment2)*sex)))
print(zarcll <- gar(reps1,"negative bin",mu=mucll1f,pdep=0.76,
	preg=c(4,-2,0.067,-0.59,-1.12,-0.76,0.059,0.93,0.61),psh=0.54))

print(zar4 <- kalcount(reps1,mu=muexp0f,pdep=0.68,
	preg=-c(1.72,0.067,-0.59,-1.12,-0.76,0.059,0.93,0.61),dep="serial"))
kalcount(reps1,int="Weibull",mu=muexp0f,pdep=0.68,psh=0.58,dep="serial",
	preg=-c(1.72,0.067,-0.59,-1.12,-0.76,0.059,0.93,0.61))
kalcount(reps1,int="gen log",mu=muexp0f,pdep=0.46,psh=10,pinter=-2.8,pinit=1.9,
	preg=-c(12,0.067,-0.59,-1.12,-0.76,0.059,0.93,0.61),dep="serial")
kalcount(reps1,mu=muexp0e,pdep=0.4,dep="serial",
	preg=-c(1.43,0.1,-0.94,-1.94,-1.14,0.18,0.01,1.22,1.3))
muexp0f1 <-  ~exp(b0+b1*times+b2*base+b3*sex+b4*treatment1+b5*treatment2
	+b6*treatment1*base+(b8*treatment1+b9*treatment2)*sex)
kalcount(reps1,mu=muexp0f1,pdep=0.4,
	ptvc=-c(1.72,0,0.067,-0.59,-1.12,-0.76,0.059,0.93,0.61),dep="serial")
kalcount(reps1,mu=muexp0g,pdep=0.42,dep="serial",ptvc=-c(1.58,0.11,-0.82,-2.1,
	-1.15,0.18,1.46,1.11,-0.014,-0.016,0.012,-0.0015,-0.023,0.026))

kalcount(reps1,mu=mulog1f,pdep=0.4,
	ptvc=-c(5,-2,0.11,-0.79,-1.17,-0.96,0.073,0.91,0.84),dep="serial")
kalcount(reps1,mu=mulog1f,pdep=0.4,
	ptvc=-c(5,-5,0.11,-0.93,-1.94,-1.13,0.18,1.21,1.3),dep="serial")
kalcount(reps1,mu=mulog1h,pdep=0.4,
	ptvc=-c(5,-5,0,0.11,-0.93,-1.94,-1.13,0.18,1.21,1.3),dep="serial")
mulog1h1 <- ~1/(1+exp(-(b0+b1*times+b2*base+b3*sex+b4*treatment1
	+b5*treatment2+b6*treatment1*base+(b8*treatment1+b9*treatment2)*sex)))
kalcount(reps1,mu=mulog1h1,pdep=0.4,
	ptvc=-c(-5,0,0.11,-0.93,-1.94,-1.13,0.18,1.21,1.3),dep="serial")
mulog1h2 <- ~exp(asymptote)/(1+exp(-(b1*times+b2*base+b3*sex+b4*treatment1
	+b5*treatment2+b6*treatment1*base+(b8*treatment1+b9*treatment2)*sex)))
kalcount(reps1,mu=mulog1h2,pdep=0.4,
	ptvc=-c(5,0,0.11,-0.93,-1.94,-1.13,0.18,1.21,1.3),dep="serial")

kalcount(reps1,mu=mucll1f,pdep=0.4,
	ptvc=-c(5,-5,0.11,-0.93,-1.94,-1.13,0.18,1.21,1.3),dep="serial")
