library(repeated)
library(growth)
library(gnlm)

y <- read.list("azams.dat",order=2:1)
dose <- read.list("azadose.dat",order=2:1)
treat <- cbind(c(rep(0,17),rep(1,15),rep(0,16)),c(rep(0,32),rep(1,16)))
colnames(treat) <- c("AZP","AZMP")
resp <- restovec(y)

tvc <- gettvc(y,tvcov=dose,ties=F)
reps <- rmna(resp,tvcov=tvc,ccov=tcctomat(treat))

if(interactive()){
postscript(file="azamsr.eps",height=7,width=5)
par(mfrow=c(3,1),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(resp,nind=1:17,xlim=c(-200,1400),ylim=c(0,1200),xlab="",ylab="AFCR level",
	lty=1,main="P + P",yaxt="n")
axis(2,at=c(0,400,800,1200))
plot(resp,nind=18:32,xlim=c(-200,1400),ylim=c(0,1200),xlab="",
	ylab="AFCR level",lty=1,main="AZ + P",yaxt="n")
axis(2,at=c(0,400,800,1200))
plot(resp,nind=33:48,xlim=c(-200,1400),ylim=c(0,1200),ylab="AFCR level",
	xlab="Days from start of treatment",lty=1,main="AZ + MP",yaxt="n")
axis(2,at=c(0,400,800,1200))
dev.off()
postscript(file="azamsd.eps",height=7,width=5)
par(mfrow=c(3,1),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
dx <- as.vector(matrix(rep(dose[[1]][,2],2),nrow=2,byrow=T))
dy <- c(0,as.vector(matrix(rep(dose[[1]][,1],2),nrow=2,byrow=T)))
dy <- dy[1:(length(dy)-1)]
plot(dx,dy,type="l",xlim=c(-200,1400),ylim=c(0,3),xlab="",ylab="Dose",
	main="P + P",yaxt="n")
axis(2,at=c(0,1,2,3))
for(i in 2:17){
	dx <- as.vector(matrix(rep(dose[[i]][,2],2),nrow=2,byrow=T))
	dy <- c(0,as.vector(matrix(rep(dose[[i]][,1],2),nrow=2,byrow=T)))
	dy <- dy[1:(length(dy)-1)]
	lines(dx,dy)}
dx <- as.vector(matrix(rep(dose[[18]][,2],2),nrow=2,byrow=T))
dy <- c(0,as.vector(matrix(rep(dose[[18]][,1],2),nrow=2,byrow=T)))
dy <- dy[1:(length(dy)-1)]
plot(dx,dy,type="l",xlim=c(-200,1400),ylim=c(0,3),xlab="",ylab="Dose",
	main="AZ + P",yaxt="n")
axis(2,at=c(0,1,2,3))
for(i in 19:32){
	dx <- as.vector(matrix(rep(dose[[i]][,2],2),nrow=2,byrow=T))
	dy <- c(0,as.vector(matrix(rep(dose[[i]][,1],2),nrow=2,byrow=T)))
	dy <- dy[1:(length(dy)-1)]
	lines(dx,dy)}
dx <- as.vector(matrix(rep(dose[[33]][,2],2),nrow=2,byrow=T))
dy <- c(0,as.vector(matrix(rep(dose[[33]][,1],2),nrow=2,byrow=T)))
dy <- dy[1:(length(dy)-1)]
plot(dx,dy,type="l",xlim=c(-200,1400),ylim=c(0,3),yaxt="n",
	xlab="Days from start of treatment",ylab="Dose",main="AZ + MP")
axis(2,at=c(0,1,2,3))
for(i in 34:48){
	dx <- as.vector(matrix(rep(dose[[i]][,2],2),nrow=2,byrow=T))
	dy <- c(0,as.vector(matrix(rep(dose[[i]][,1],2),nrow=2,byrow=T)))
	dy <- dy[1:(length(dy)-1)]
	lines(dx,dy)}
dev.off()
}

# note that the parametrization of the dispersion parameter of the
#  negative binomial distribution in gar has changed since the book
# was published so that the results are somewhat different

# generalized logistic model
mulog <- ~alpha*(1+((alpha/iota)^kappa-1)*exp(-gamma*(times-501)*alpha^kappa))^
	(-1/kappa)
gnlr(reps,mu=mulog,dist="Poisson",pmu=c(130,145,-1.8,45))
gnlr(reps,mu=mulog,dist="negative bin",pmu=c(132,146,-1.2,2),
	psh=0.054)
mulog2 <- ~alpha*(1+((alpha/iota)^kappa-1)*exp(-(times-501)*alpha^kappa))^
	(-1/kappa)
gnlr(reps,mu=mulog2,dist="negative bin",pmu=c(131,147,-1.3),
	psh=0.047)
#gar(reps,mu=mulog,dist="negative bin",preg=c(138,164,-2,3.6),
#	psh=0.013,pdep=0.99,stepmax=1)
gar(reps,mu=mulog,dist="negative bin",preg=c(138,164,-2,3.6),
	psh=1,pdep=0.3,stepmax=1,iter=200)
#gar(reps,mu=mulog2,dist="negative bin",preg=c(135,167,-1.15),
#	psh=0.013,pdep=0.99,stepmax=1)
gar(reps,mu=mulog2,dist="negative bin",preg=c(135,167,-1.15),
	psh=1,pdep=0.2,stepmax=1)
mulog3 <- ~exp(b0+b1*AZP+b2*AZMP)*(1+((exp(b0+b1*AZP+b2*AZMP)/iota)^kappa-1)*
	exp(-(times-501)*exp(b0+b1*AZP+b2*AZMP)^kappa))^(-1/kappa)
#gar(reps,mu=mulog3,dist="negative bin",preg=c(5,-0.16,-0.14,173.5,
#	-1.18),psh=0.013,pdep=0.995,stepmax=1)
gar(reps,mu=mulog3,dist="negative bin",preg=c(5,-0.16,-0.14,173.5,
	-1.18),psh=2,pdep=0.3,stepmax=1,iter=200)
mulog3a <- ~exp(b0+b1*(AZP+AZMP))*(1+((exp(b0+b1*(AZP+AZMP))/iota)^kappa-1)*
	exp(-(times-501)*exp(b0+b1*(AZP+AZMP))^kappa))^(-1/kappa)
#print(u1 <- gar(reps,mu=mulog3a,dist="negative bin",preg=c(5,-0.16,173.5,
#	-1.18),psh=0.013,pdep=0.995,stepmax=1))
print(u1 <- gar(reps,mu=mulog3a,dist="negative bin",preg=c(5,-0.16,173.5,
	-1.18),psh=1,pdep=0.995,stepmax=1,iter=200))
mulog3b <- ~exp(b0+b1*AZP+b2*AZMP)*(1+((exp(b0+b1*AZP+b2*AZMP)/iota)^kappa-1)*
	exp(-gamma*(times-501)*exp(b0+b1*AZP+b2*AZMP)^kappa))^(-1/kappa)
#gar(reps,mu=mulog3b,dist="negative bin",preg=c(5,-0.16,-0.14,173.5,
#	-1.2,1.1),psh=0.013,pdep=0.995,stepmax=1)
gar(reps,mu=mulog3b,dist="negative bin",preg=c(5,-0.16,-0.14,173.5,
	-1.2,1.1),psh=1,pdep=0.995,stepmax=1)
mulog4 <- ~exp(b0+b1*AZP+b2*AZMP+(c1*AZP+c2*AZMP)*dose)*
	(1+((exp(b0+b1*AZP+b2*AZMP+(c1*AZP+c2*AZMP)*dose)/iota)^kappa-1)*
	exp(-(times-501)*exp(b0+b1*AZP+b2*AZMP+(c1*AZP+c2*AZMP)*dose)^kappa))^
	(-1/kappa)
#gar(reps,mu=mulog4,dist="negative bin",preg=c(5,-0.16,-0.14,
#	0,0,173,-1.18),psh=0.013,pdep=0.99,stepmax=1)
gar(reps,mu=mulog4,dist="negative bin",preg=c(5,-0.16,-0.14,
	0,0,173,-1.18),psh=1,pdep=0.99,stepmax=1)
mulog5 <- ~alpha*(1+((alpha/exp(b0+b1*AZP+b2*AZMP))^
	kappa-1)*exp(-(times-501)*alpha^kappa))^(-1/kappa)
#gar(reps,mu=mulog5,dist="negative bin",preg=c(8.81,5.56,-0.62,-0.46,
#	-2.88),psh=0.013,pdep=0.99,stepmax=0.1)
gar(reps,mu=mulog5,dist="negative bin",preg=c(8.81,5.56,-0.62,-0.46,
	-2.88),psh=1,pdep=0.3,stepmax=0.5)
mulog5a <- ~alpha*(1+((alpha/exp(b0+b1*(AZP+AZMP)))^
	kappa-1)*exp(-(times-501)*alpha^kappa))^(-1/kappa)
#gar(reps,mu=mulog5a,dist="negative bin",preg=c(8.82,5.57,-0.56,
#	-2.89),psh=0.013,pdep=0.99,stepmax=0.5)
gar(reps,mu=mulog5a,dist="negative bin",preg=c(8.82,5.57,-0.56,
	-2.89),psh=1,pdep=0.99,stepmax=0.5)
mulog5b <- ~alpha*(1+((alpha/exp(b0+b1*(AZP+AZMP)+c1*(AZP+AZMP)*dose))^
	kappa-1)*exp(-(times-501)*alpha^kappa))^(-1/kappa)
#print(u2 <- gar(reps,mu=mulog5b,dist="negative bin",preg=c(8.85,5.55,-0.33,
#	-0.28,-2.92),psh=0.013,pdep=0.99,stepmax=0.1))
print(u2 <- gar(reps,mu=mulog5b,dist="negative bin",preg=c(8.85,5.55,-0.33,
	-0.28,-2.92),psh=1,pdep=0.6,stepmax=0.5))
gar(reps,mu=mulog5b,dist="Consul",preg=c(8.88,5.57,-0.38,-0.29,-2.95),
	psh=10,pdep=0.99,stepmax=0.1)

#gar(reps,mu=mulog5b,dist="negative bin",preg=c(8.81,5.56,-0.38,-0.27,
#	-2.89),shape=mulog,psh=c(63.8,0.013,-0.067,0.000038),
#	pdep=0.3,stepmax=0.1)
gar(reps,mu=mulog5b,dist="negative bin",preg=c(8.81,5.56,-0.38,-0.27,
	-2.89),shape=mulog,psh=c(9,5,-0.067,0.000038),
	pdep=0.3,stepmax=0.5)
#print(u3 <- gar(reps,mu=mulog5b,dist="negative bin",preg=c(9.14,5.56,-0.44,
#	-0.32,-2.85),shape=~exp(b0+b1*(times-501)/100+b2*(times-501)^2/10000+
#	(c1*AZP+c2*AZMP)*(times-501)/100+d1*dose*AZP+d2*dose*AZMP),
#	psh=c(-4.16,0.04,-0.0079,-0.0019,0.035,0.28,-0.027),
#	pdep=0.99,stepmax=0.1))
print(u3 <- gar(reps,mu=mulog5b,dist="negative bin",preg=c(9.14,5.56,-0.44,
	-0.32,-2.85),shape=~exp(b0+b1*(times-501)/100+b2*(times-501)^2/10000+
	(c1*AZP+c2*AZMP)*(times-501)/100+d1*dose*AZP+d2*dose*AZMP),
	psh=c(2,0.4,-0.0079,-0.0019,0.035,0.28,-0.027),
	pdep=0.7,stepmax=0.5,iter=200))

if(interactive()){
postscript(file="azamspr3.eps",width=5,height=7)
par(mfrow=c(3,1),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(mprofile(u3),ylim=c(0,1200),main="P + P: Subject 1",
	xlab="",ylab="AFCR level",yaxt="n")
axis(2,at=c(0,400,800,1200))
plot(iprofile(u3),add=T,lty=2)
plot(mprofile(u3),nind=18,ylim=c(0,1200),main="AZ + P: Subject 18",
	xlab="",ylab="AFCR level",yaxt="n")
axis(2,at=c(0,400,800,1200))
plot(iprofile(u3),nind=18,add=T,lty=2)
plot(mprofile(u3),nind=35,ylim=c(0,1200),main="AZ + MP: Subject 35",
	xlab="Days from start of treatment",ylab="AFCR level",yaxt="n")
axis(2,at=c(0,400,800,1200))
plot(iprofile(u3),nind=35,add=T,lty=2)
dev.off()
}

# quadratic polynomial model
gnlr(reps,mu=~b0+b1*times+b2*times^2,dist="Poisson",pmu=c(300,-0.42,0.001))
gnlr(reps,mu=~exp(b0+b1*times+b2*times^2),dist="negative bin",
	pmu=c(5.7,-0.002,0.000001),psh=0.4)
gnlr(reps,mu=~exp(b0+b1*times+b2*times^2),dist="Consul",
	pmu=c(5.7,-0.002,0.000001),psh=2.6)
#gar(reps,mu=~exp(b0+b1*times+b2*times^2),dist="negative bin",
#	preg=c(5.74,-0.002,0.000001),psh=0.013,pdep=0.95)
gar(reps,mu=~exp(b0+b1*times+b2*times^2),dist="negative bin",
	preg=c(5.74,-0.002,0.000001),psh=1,pdep=0.95)
gar(reps,mu=~exp(b0+b1*times+b2*times^2),dist="Consul",
	preg=c(5.74,-0.002,0.000001),psh=12,pdep=0.95)
#gar(reps,mu=~exp(b0+b1*times+b2*times^2+a1*AZP+a2*AZMP),dist="negative bin",
#	preg=c(5.74,-0.002,0.000001,0,0),psh=0.013,pdep=0.95)
gar(reps,mu=~exp(b0+b1*times+b2*times^2+a1*AZP+a2*AZMP),dist="negative bin",
	preg=c(5.74,-0.002,0.000001,0,0),psh=1,pdep=0.95)
#gar(reps,mu=~exp(b0+b1*times+b2*times^2+a1*AZP+a2*AZMP+d1*dose*AZP+
#	d2*dose*AZMP),dist="negative bin",preg=c(5.74,-0.002,0.000001,
#	-0.6,-0.5,0,0),psh=0.013,pdep=0.95)
gar(reps,mu=~exp(b0+b1*times+b2*times^2+a1*AZP+a2*AZMP+d1*dose*AZP+
	d2*dose*AZMP),dist="negative bin",preg=c(5.74,-0.002,0.000001,
	-0.6,-0.5,0,0),psh=1,pdep=0.95)
#print(z1 <- gar(reps,mu=~exp(b0+b1*times+b2*times^2+(c1*AZP+c2*AZMP)*times
#	+d1*dose*AZP+d2*dose*AZMP),dist="negative bin",
#	preg=c(5.8,-0.0014,0.000001,-0.0006,-0.0006,-0.21,-0.15),
#	psh=0.014,pdep=0.99))
print(z1 <- gar(reps,mu=~exp(b0+b1*times+b2*times^2+(c1*AZP+c2*AZMP)*times
	+d1*dose*AZP+d2*dose*AZMP),dist="negative bin",
	preg=c(5.8,-0.0014,0.000001,-0.0006,-0.0006,-0.21,-0.15),
	psh=1,pdep=0.99))

#gar(reps,mu=~exp(b0+b1*times+b2*times^2+(c1*AZP+c2*AZMP)*times
#	+d1*dose*AZP+d2*dose*AZMP),dist="negative bin",
#	preg=c(5.81,-0.0016,0.0000012,-0.00095,-0.00077,-0.19,-0.15),
#	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2),
#	psh=c(-4,0.00052,-0.0000011),pdep=0.99)
gar(reps,mu=~exp(b0+b1*times+b2*times^2+(c1*AZP+c2*AZMP)*times
	+d1*dose*AZP+d2*dose*AZMP),dist="negative bin",
	preg=c(5.81,-0.0016,0.0000012,-0.00095,-0.00077,-0.19,-0.15),
	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2),
	psh=c(4,0.00052,-0.0000011),pdep=0.99)
#gar(reps,mu=~exp(b0+b1*times+b2*times^2+(c1*AZP+c2*AZMP)*times
#	+d1*dose*AZP+d2*dose*AZMP),dist="negative bin",
#	preg=c(5.81,-0.0017,0.0000012,-0.0011,-0.00069,-0.27,-0.13),
#	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+d1*dose*AZP+
#	d2*dose*AZMP),psh=c(-4.1,0.0005,-0.0000011,0.35,-0.11),pdep=0.99,
#	stepmax=1)
gar(reps,mu=~exp(b0+b1*times+b2*times^2+(c1*AZP+c2*AZMP)*times
	+d1*dose*AZP+d2*dose*AZMP),dist="negative bin",
	preg=c(5.81,-0.0017,0.0000012,-0.0011,-0.00069,-0.27,-0.13),
	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+d1*dose*AZP+
	d2*dose*AZMP),psh=c(4.1,0.0005,-0.0000011,0.35,-0.11),pdep=0.99,
	iter=200)
#gar(reps,mu=~exp(b0+b1*times+b2*times^2+(c1*AZP+c2*AZMP)*times
#	+d1*dose*AZP+d2*dose*AZMP),dist="negative bin",
#	preg=c(5.81,-0.0016,0.0000012,-0.001,-0.00071,-0.27,-0.11),
#	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+
#	(c1*AZP+c2*AZMP)*(times-501)+d1*dose*AZP+d2*dose*AZMP),
#	psh=c(-4,0.00048,-0.000001,-0.000026,0.00023,0.35,-0.14),pdep=0.99)
gar(reps,mu=~exp(b0+b1*times+b2*times^2+(c1*AZP+c2*AZMP)*times
	+d1*dose*AZP+d2*dose*AZMP),dist="negative bin",
	preg=c(5.81,-0.0016,0.0000012,-0.001,-0.00071,-0.27,-0.11),
	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+
	(c1*AZP+c2*AZMP)*(times-501)+d1*dose*AZP+d2*dose*AZMP),
	psh=c(4,0.00048,-0.000001,-0.000026,0.00023,0.35,-0.14),pdep=0.99,
	iter=200)
#gar(reps,mu=~exp(b0+b1*times+b2*times^2+c1*(AZP+AZMP)*times
#	+d1*dose*AZP+d2*dose*AZMP),dist="negative bin",
#	preg=c(5.8,-0.0016,0.0000012,-0.00091,-0.31,-0.057),
#	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+d1*dose*AZP+
#	d2*dose*AZMP),psh=c(-4.1,0.00049,-0.0000011,0.33,-0.12),pdep=0.99,
#	stepmax=1)
gar(reps,mu=~exp(b0+b1*times+b2*times^2+c1*(AZP+AZMP)*times
	+d1*dose*AZP+d2*dose*AZMP),dist="negative bin",
	preg=c(5.8,-0.0016,0.0000012,-0.00091,-0.31,-0.057),
	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+d1*dose*AZP+
	d2*dose*AZMP),psh=c(4.1,0.00049,-0.0000011,0.33,-0.12),pdep=0.99)
#print(z2 <- gar(reps,mu=~exp(b0+b1*times+b2*times^2+c1*(AZP+AZMP)*times
#	+d1*dose*AZP),dist="negative bin",
#	preg=c(5.8,-0.0016,0.0000012,-0.00091,-0.31),
#	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+d1*dose*AZP+
#	d2*dose*AZMP),psh=c(-4.1,0.00049,-0.0000011,0.33,-0.12),pdep=0.99,
#	stepmax=1))
print(z2 <- gar(reps,mu=~exp(b0+b1*times+b2*times^2+c1*(AZP+AZMP)*times
	+d1*dose*AZP),dist="negative bin",
	preg=c(5.8,-0.0016,0.0000012,-0.00091,-0.31),
	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+d1*dose*AZP+
	d2*dose*AZMP),psh=c(4.1,0.00049,-0.0000011,0.33,-0.12),pdep=0.99))
#gar(reps,mu=~b0+b1*times+b2*times^2+c1*(AZP+AZMP)*times+d1*dose*AZP,
#	dist="negative bin",preg=c(232,0.046,-0.00000013,-0.11,-17.5),
#	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+d1*dose*AZP+
#	d2*dose*AZMP),psh=c(-4.1,0.00045,-0.00000065,0.024,-0.28),pdep=0.99,
#	stepmax=1)
gar(reps,mu=~b0+b1*times+b2*times^2+c1*(AZP+AZMP)*times+d1*dose*AZP,
	dist="negative bin",preg=c(232,0.046,-0.00000013,-0.11,-17.5),
	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+d1*dose*AZP+
	d2*dose*AZMP),psh=c(4.1,0.00045,-0.00000065,0.024,-0.28),pdep=0.99,
	iter=200)

if(interactive()){
postscript(file="azamspr4.eps",width=5,height=7)
par(mfrow=c(3,1),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(mprofile(z2),ylim=c(0,1200),main="P + P: Subject 1",
	xlab="",ylab="AFCR level",yaxt="n")
axis(2,at=c(0,400,800,1200))
plot(iprofile(z2),add=T,lty=2)
plot(mprofile(z2),nind=18,ylim=c(0,1200),main="AZ + P: Subject 18",
	xlab="",ylab="AFCR level",yaxt="n")
axis(2,at=c(0,400,800,1200))
plot(iprofile(z2),nind=18,add=T,lty=2)
plot(mprofile(z2),nind=35,ylim=c(0,1200),main="AZ + MP: Subject 35",
	xlab="Days from start of treatment",ylab="AFCR level",yaxt="n")
axis(2,at=c(0,400,800,1200))
plot(iprofile(z2),nind=35,add=T,lty=2)
dev.off()
}

# set zeros to NA
# the internals of data object really should not be modified this way!
resp$y[resp$y[,1]==0,1] <- NA
resp2 <- transform(resp,sy=sqrt(y))
reps2 <- rmna(resp2,tvcov=tvc,ccov=tcctomat(treat))

#gar(y,mu=~exp(b0+b1*times+b2*times^2+c1*(AZP+AZMP)*times
#	+d1*dose*AZP),dist="negative bin",
#	preg=c(5.8,-0.0016,0.0000012,-0.00091,-0.31),
#	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+d1*dose*AZP+
#	d2*dose*AZMP),psh=c(-4.1,0.00049,-0.0000011,0.33,-0.12),pdep=0.99,
#	envir=reps2,stepmax=1)
gar(y,mu=~exp(b0+b1*times+b2*times^2+c1*(AZP+AZMP)*times
	+d1*dose*AZP),dist="negative bin",
	preg=c(5.8,-0.0016,0.0000012,-0.00091,-0.31),
	shape=~exp(b0+b1*(times-501)+b2*(times-501)^2+d1*dose*AZP+
	d2*dose*AZMP),psh=c(4.1,0.00049,-0.0000011,0.33,-0.12),pdep=0.99,
	envir=reps2)

mu <- function(p)
	p[1]+p[2]*(times-501.4581)/100+p[3]*((times-501.4581)/100)^2+
	(p[4]+p[5]*(times-501.4581)/100+p[6]*((times-501.4581)/100)^2)*AZP+
	(p[7]+p[8]*(times-501.4581)/100+p[9]*((times-501.4581)/100)^2)*AZMP+
	dose*(p[10]+p[11]*AZP+p[12]*AZMP)
print(r1radi <- elliptic(sy,preg=c(13.5,-0.45,0.057,-4.1,-0.41,0.057,-3.4,
	-0.44,0.0067,0.51,-2,-1.4),pvar=13.1,pre=6.4,par=0.81,
	model=mu,envir=reps2))

print(k2artd <- kalseries(sy,intensity="normal",dep="serial",
	mu=~a+b1*AZP+b2*AZMP+c*dose+d1*(times-501.4581)/100+
	d2*(times-501.4581)^2/10000+(e1*AZP+e2*AZMP)*(times-501.4581)/100+
	(f1*AZP+f2*AZMP)*(times-501.4581)^2/10000
	+(g1*AZP+g2*AZMP)*dose,pinit=0.478,pdep=0.999,psh=8.81,
	ptvc=c(11.4,-2.4,-2.86,0.77,-0.42,0.065,-0.38,
	-0.45,0.036,0.071,-2.37,-1.7),envir=reps2))
