library(gnlm)

data <- read.table("lungcancer.dat",skip=5,header=T)
attach(data)
Years <- Years+0.5

cig <- rep(c(0,5.2,11.2,15.9,20.4,27.4,40.8),9)

print(z <- glm(Cases~as.factor(Cig)+as.factor(Years)+offset(log(Risk)),
	family=poisson))
exp(c(z$coef[1],z$coef[1]+z$coef[8:15]))
exp(z$coef[2:7])

gnlr(Cases,dist="Poisson",mu=~exp(linear)*Risk,
	linear=~as.factor(Cig)+as.factor(Years),pmu=c(-13,rep(3,14)),iter=200)

glm(Cases[Cig!=0]~log(cig[Cig!=0])+log(Years[Cig!=0])+
	offset(log(Risk[Cig!=0])),family=poisson)

gnlr(Cases[Cig!=0],dist="Poisson",mu=~exp(linear)*Risk[Cig!=0],
	linear=~log(cig[Cig!=0])+log(Years[Cig!=0]),pmu=c(-26,1,4),iter=200)

gnlr(Cases,dist="Poisson",pmu=c(-25,-25,1,4),
	mu=~(exp(lgamma)+exp(lalpha)*cig^theta)*Years^beta*Risk)
