library(gnlm)
library(growth)
library(repeated)

id <- gl(10,1)
cov <- tcctomat(id,dataframe=F)
reps <- rmna(restovec(read.list("women.dat",skip=3),name="y"),ccov=cov)
reps <- transform(reps,ly=log(y))

mu1 <- ~d0+alpha/(1+exp(-b0-b1*times))
mu2 <- function(p,linear) linear+p[1]/(1+exp(-p[2]-p[3]*times))
mu3 <- ~d0+alpha*(1+exp(-b0-b1*times))^(-1/d)
mu4 <- function(p,linear) linear+p[1]*(1+exp(-p[2]-p[3]*times))^(-1/exp(p[4]))

gnlr(y,dist="normal",mu=~1,pmu=134,psh=6,env=reps)
print(zn1 <- gnlr(y,dist="normal",mu=mu1,pmu=c(110,45,-3,0.1),psh=6,env=reps))
print(zn2 <- gnlr(y,dist="normal",mu=mu2,linear=~individuals,iter=200,env=reps,
	pmu=c(34,-3.2,0.13,139,-19,-41,-46,-31,-6,-32,-1,-39,-41),psh=2.6))
gnlr(y,dist="normal",mu=mu3,pmu=c(114.5,45,-3.3,0.11,1),psh=5.75,env=reps)
print(zn4 <- gnlr(y,dist="normal",mu=mu4,linear=~individuals,iter=200,env=reps,
	pmu=c(34,-3.2,0.13,0,139,-19,-41,-46,-31,-6,-32,-1,-39,-41),psh=2.6))

lmu2 <- function(p,linear) log(linear+p[1]/(1+exp(-p[2]-p[3]*times)))
print(zln2 <- gnlr(ly,dist="normal",mu=lmu2,linear=~individuals,iter=200,
	pmu=c(34,-3.2,0.13,139,-19,-41,-46,-31,-6,-32,-1,-39,-41),psh=0.02,
	env=reps))

mu1i <- ~d0+d2*id2+d3*id3+d4*id4+d5*id5+d6*id6+d7*id7+d8*id8+d9*id9+d10*id10+
	alpha/(1+exp(-b0-b1*times))
print(zgn1 <- gar(y,dist="normal",mu=mu1,preg=c(110,45,-3,0.1),
	psh=6,pdep=0.5,env=reps))
print(zgn1i <- gar(y,dist="normal",mu=mu1i,psh=6,pdep=0.5,env=reps,
	preg=c(139,-19,-41,-46,-31,-6,-32,-1,-39,-41,34,-3.2,0.13),iter=200))
print(zgg1i <- gar(y,dist="gamma",mu=mu1i,psh=1,pdep=0.5,
	preg=c(139,-19,-41,-46,-31,-6,-32,-1,-39,-41,34,-3.2,0.13),env=reps))
print(zgw1i <- gar(y,dist="Weibull",mu=mu1i,psh=1,pdep=0.5,
	preg=c(139,-19,-41,-46,-31,-6,-32,-1,-39,-41,34,-3.2,0.13),env=reps))
print(zgln1i <- gar(y,dist="normal",mu=mu1i,psh=0.03,pdep=0.5,
	preg=c(139,-19,-41,-46,-31,-6,-32,-1,-39,-41,34,-3.2,0.13),
	transform="log",link="exp",env=reps,iter=200))

if(interactive()){
#postscript(file="womenln.eps")
par(mfrow=c(3,3),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(iprofile(zgln1i),nind=1,xlab="Weeks",ylab="Pounds",
	xlim=c(0,45),ylim=c(90,180),lty=3)
plot(mprofile(zgln1i),nind=1,add=T)
for(i in 2:9){
	plot(iprofile(zgln1i),nind=i,xlab="Weeks",ylab="Pounds",
		xlim=c(0,45),ylim=c(90,180),lty=3)
	plot(mprofile(zgln1i),nind=i,add=T)}
dev.off()
#postscript(file="womenn.eps")
par(mfrow=c(3,3),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(iprofile(zgn1i),nind=1,xlab="Weeks",ylab="Pounds",
	xlim=c(0,45),ylim=c(90,180),lty=3)
plot(mprofile(zgn1i),nind=1,add=T)
for(i in 2:9){
	plot(iprofile(zgn1i),nind=i,xlab="Weeks",ylab="Pounds",
		xlim=c(0,45),ylim=c(90,180),lty=3)
	plot(mprofile(zgn1i),nind=i,add=T)}
dev.off()
}

print(zen1i <- elliptic(y,model=mu1i,pvar=17,
	preg=c(139,-19,-41,-46,-31,-6,-32,-1,-39,-41,34,-3.2,0.13),env=reps))
print(zen1iar <- elliptic(y,model=mu1i,pvar=17,par=0.95,
	preg=c(139,-19,-41,-46,-31,-6,-32,-1,-39,-41,34,-3.2,0.13),env=reps))
print(zen1 <- elliptic(y,model=mu1,pvar=200,preg=c(139,34,-3.2,0.13),env=reps))
print(zen1ar <- elliptic(y,model=mu1,pvar=17,par=0.95,
	preg=c(139,34,-3.2,0.13),env=reps))
print(zen1re <- elliptic(y,model=mu1,pvar=100,pre=300,
	preg=c(139,34,-3.2,0.13),env=reps))
print(zen1arre <- elliptic(y,model=mu1,pvar=307,par=0.95,pre=10,
	preg=c(139,34,-3.2,0.13),env=reps))

print(zeln1i <- elliptic(y,model=mu1i,pvar=0.001,
	preg=c(139,-19,-41,-46,-31,-6,-32,-1,-39,-41,34,-3.2,0.13),
	transform="log",link="exp",env=reps))
print(zeln1iar <- elliptic(y,model=mu1i,pvar=0.001,par=0.5,
	preg=c(139,-19,-41,-46,-31,-6,-32,-1,-39,-41,34,-3.2,0.13),
	transform="log",link="exp",env=reps))
print(zeln1 <- elliptic(y,model=mu1,pvar=0.017,
	preg=c(112,50,-3,0.095),transform="log",link="exp",env=reps))
print(zeln1re <- elliptic(y,model=mu1,pvar=0.0006,pre=0.015,
	preg=c(112,32,-3.2,0.13),transform="log",link="exp",env=reps))
print(zeln1ar <- elliptic(y,model=mu1,pvar=0.017,par=0.95,
	preg=c(139,34,-3.2,0.13),transform="log",link="exp",env=reps))
print(zeln1arre <- elliptic(y,model=mu1,pvar=0.017,par=0.95,pre=0.0005,
	preg=c(139,34,-3.2,0.13),transform="log",link="exp",env=reps))

if(interactive()){
postscript(file="womenln.eps")
par(mfrow=c(3,3),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(iprofile(zeln1iar),nind=1,xlab="Weeks",ylab="Pounds",
	xlim=c(0,45),ylim=c(90,180),lty=3)
plot(mprofile(zeln1iar),nind=1,add=T)
for(i in 2:9){
	plot(iprofile(zeln1iar),nind=i,xlab=if(i>6)"Weeks"else"",
		ylab=if(i==4||i==7)"Pounds"else"",
		xlim=c(0,45),ylim=c(90,180),lty=3)
	plot(mprofile(zeln1iar),nind=i,add=T)}
dev.off()
#postscript(file="womenn.eps")
par(mfrow=c(3,3),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(iprofile(zen1iar),nind=1,xlab="Weeks",ylab="Pounds",
	xlim=c(0,45),ylim=c(90,180),lty=3)
plot(mprofile(zen1iar),nind=1,add=T)
for(i in 2:9){
	plot(iprofile(zen1iar),nind=i,xlab="Weeks",ylab="Pounds",
		xlim=c(0,45),ylim=c(90,180),lty=3)
	plot(mprofile(zen1iar),nind=i,add=T)}
dev.off()
}

lmu1 <- ~log(d0*d1+alpha/(1+exp(-b0-b1*times)))
gnlmix(ly,dist="normal",mixture="gamma",random="d1",mu=lmu1,
	pmu=c(114.45,31.15,-3.38,0.14),psh=-7.17,pmix=3.8,envir=reps)
lmu2 <- ~log(d0+alpha/(1+exp(-b0-b1*times)))+d1
gnlmix(ly,dist="normal",mixture="Cauchy",random="d1",mu=lmu2,
	pmu=c(109.15,31.05,-3.3,0.14),psh=-7.4,pmix=-2.4,envir=reps)
