library(gnlm)

percent <- matrix(scan("neoplasm.dat",skip=7,nlines=10),ncol=9,byrow=T)
rates <- matrix(scan("neoplasm.dat",skip=19,nlines=10),ncol=5,byrow=T)
rates <- rates[,-1]

age <- percent[,1]
percent <- percent[,-1]
percent[,seq(1,7,by=2)] <- percent[,seq(1,7,by=2)]*10766632/100
percent[,seq(2,8,by=2)] <- percent[,seq(2,8,by=2)]*7347712/100

totals <- percent[,seq(1,7,by=2)]+percent[,seq(2,8,by=2)]
deaths <- round(as.vector(rates*totals/100000))
totals <- round(as.vector(totals))
xx <- cbind(codes(gl(2,10,40))-1,codes(gl(2,20))-1,rep(age,4),totals)
colnames(xx) <- c("sex","race","age","totals")
xx <- tcctomat(xx)
resp <- restovec(deaths)
reps <- rmna(resp,xx)

mu <- ~exp(b0+b1*age)*totals
print(z0 <- gnlr(reps,dist="Poisson",mu=mu,pmu=c(-10,0.001)))
mu1 <- ~exp(b0+b1*age+b2*sex)*totals
print(z1 <- gnlr(reps,dist="Poisson",mu=mu1,pmu=c(-10,0.07,0)))
mu2 <- ~exp(b0+b1*age+b2*sex+b3*race)*totals
print(z2 <- gnlr(reps,dist="Poisson",mu=mu2,pmu=c(-10,0.07,-0.1,0)))
mu3 <- ~exp(b0+b1*age+b2*sex+b3*race+b4*sex*race)*totals
print(z3 <- gnlr(reps,dist="Poisson",mu=mu3,pmu=c(-9.9,0.07,-0.1,0.06,0)))

print(znb3 <- gnlr(reps,dist="negative bin",mu=mu3,
	pmu=c(-9.9,0.07,-0.1,0.06,0),psh=1.7))
print(znb2 <- gnlr(reps,dist="negative bin",mu=mu2,
	pmu=c(-9.9,0.07,-0.1,0.06),psh=1.7))
print(znb <- gnlr(reps,dist="negative bin",mu=mu,
	pmu=c(-9.9,0.07),psh=1.7))

mui <- ~a+exp(b0+b1*age)*totals
print(znbi <- gnlr(reps,dist="negative bin",mu=mui,
	pmu=c(0,-9.9,0.07),psh=1.7))
mus <- ~(d1*exp(b0+b1*age)+(1-d1)*exp(c0+c1*age))*totals
print(znbi <- gnlr(reps,dist="negative bin",mu=mus,
	pmu=c(0.4,-9,0.07,-10,0.07),psh=1.7))
mulog <- ~b2/(1+exp(b0+b1*age))*totals
print(znblog <- gnlr(reps,dist="negative bin",mu=mulog,
	pmu=c(0.3,-1,0.07),psh=1.7))
mucll <- ~b2*(1-exp(-exp(b0+b1*age)))*totals
print(znbcll <- gnlr(reps,dist="negative bin",mu=mucll,
	pmu=c(0.01,-5.8,0.07),psh=1.7))
mull <- ~b2*(exp(-exp(b0+b1*age)))*totals
print(znbll <- gnlr(reps,dist="negative bin",mu=mull,
	pmu=c(0.036,-5,-1.4),psh=-0.7))

mucll2 <- ~b3*(1-exp(-exp(b0+b1*age+b2*age^2)))*totals
print(znbcll2 <- gnlr(reps,dist="negative bin",mu=mucll2,
	pmu=c(0.01,-5.8,0.076,0.0001),psh=1.68))
mucllm <- ~(b3*(1-exp(-exp(b0+b1*age)))*(age<60)+(c0+c1*age)*(age>=60))*totals
print(znbcllm <- gnlr(reps,dist="negative bin",mu=mucllm,
	pmu=c(0.01,-5.8,0.076,-0.013,0.0003),psh=1.68))
muclli <- ~b3*(1-exp(-exp(b0+b1*age+b2*race*(age>60))))*totals
print(znbclli <- gnlr(reps,dist="negative bin",mu=muclli,
	pmu=c(0.01,-5.8,0.07,0),psh=1.7))
muclli2 <- ~(b3+b4*race*(age>60))*(1-exp(-exp(b0+b1*age)))*totals
print(znbclli2 <- gnlr(reps,dist="negative bin",mu=muclli2,
	pmu=c(0.017,-0.0055,-6,0.077),psh=1.76))
muclli3 <- ~(b3+b4*race*(age>60))*
	(1-exp(-exp(b0+b1*age+b2*race*(age>60))))*totals
print(znbclli3 <- gnlr(reps,dist="negative bin",mu=muclli3,
	pmu=c(0.017,-0.0055,-6,0.077,0),psh=1.76))

if(interactive()){
postscript("neoplasm.eps",height=5,width=5)
par(mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(age[1:10],(znbcll$fit/totals)[1:10],type="l",xlab="Age",
	ylab="Death rate",ylim=c(0,0.02))
lines(age[1:10],(znb$fit/totals)[1:10],lty=2)
lines(age[1:10],(znbclli2$fit/totals)[21:30],lty=4)
points(age[1:10],(deaths/totals)[1:10])
#lines(age[1:10],(deaths/totals)[1:10],lty=3)
points(age[1:10],(deaths/totals)[11:20],pch=0)
#lines(age[1:10],(deaths/totals)[11:20],lty=3)
points(age[1:10],(deaths/totals)[21:30],pch=2)
#lines(age[1:10],(deaths/totals)[21:30],lty=3)
points(age[1:10],(deaths/totals)[31:40],pch=6)
#lines(age[1:10],(deaths/totals)[31:40],lty=3)
legend(0,0.018,legend=c("White male","White female","Black male",
	"Black female","Exponential","Gompertz","Gompertz (Blacks over 60)"),
	pch=c(1,0,2,6,-1,-1,-1),lty=c(0,0,0,0,2,1,4),bty="n")
dev.off()
}
