library(gnlm)
library(repeated)
library(event)

y <- scan("hus.dat",skip=3)
resp <- restovec(matrix(y,nrow=2,byrow=T))
ccov <- tcctomat(0:1,name="centre")
reps <- rmna(resp,ccov=ccov)

mu <- function(p,linear) exp(linear)
gnlr(reps,dist="Poisson",mu=~exp(a),pmu=1.6)
gnlr(reps,dist="Poisson",mu=mu,linear=~centre,pmu=c(1.6,0))
gnlr(reps,dist="Poisson",mu=mu,linear=~times,pmu=c(0.1,0))
gnlr(reps,dist="Poisson",mu=mu,linear=~times+centre,pmu=c(-0.1,0.14,0))
gnlr(reps,dist="Poisson",mu=mu,linear=~times*centre,pmu=c(-0.1,0.14,0,0))

if(interactive()){
postscript(file="hus0.eps",height=5,width=5)
par(mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
cprocess(list(rep(1,20),rep(1,20)),list(y[21:40],y[1:20]),xlab="Year",
	ylab="Cumulative count",xlim=c(0,21),ylim=c(0,120),xaxt="n")
axis(1,c(1,6,11,16,21),c(1970,1975,1980,1985,1990))
legend(1,100,legend=c("Birmingham","Newcastle-upon-Tyne"),lty=1:2,bty="n")
dev.off()
}

u <- 1:40
x <- rep(1970:1989,2)

like <- function(p) sum(mu(p)-y*log(mu(p)))
mu <- function(p) exp(p[1]+p[2]*(x>i))
z <- est <- ll <- NULL
z$est  <- c(1.2,0.5)
for(i in 1970:1988){
	z <- nlm(like,z$est)
	ll <- c(ll,-z$min-sum(lgamma(y+1)))
	est <- rbind(est,z$est)}
-max(ll)
tmp <- est[ll==max(ll),]
c(exp(tmp[1]),exp(tmp[1]+tmp[2]))
c(mean(y[c(1:15,21:35)]),mean(y[c(16:20,36:40)]))

like2 <- function(p) sum(mu2(p)-y*log(mu2(p)))
mu2 <- function(p) (exp(p[1])*(x<=i)+exp(p[2])*(x>i))*(u<=20)+
	(u>20)*(exp(p[3])*(x<=i)+exp(p[4])*(x>i))
z2 <- est2 <- ll2 <- NULL
z2$est  <- c(1.2,2.5,1.2,2.5)
for(i in 1970:1988){
	z2 <- nlm(like2,z2$est)
	ll2 <- c(ll2,-z2$min-sum(lgamma(y+1)))
	est2 <- rbind(est2,z2$est)}
-max(ll2)
exp(est2[ll2==max(ll2),])
c(mean(y[1:15]),mean(y[16:20]),mean(y[21:35]),mean(y[36:40]))

if(interactive()){
postscript(file="hus1.eps",width=5,height=5)
par(mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(1970.5:1988.5,ll2-max(ll2),type="l",xlab="Year",
	ylab="Log normed profile likelihood")
dev.off()
}

like3 <- function(p) sum(mu3(p)-y*log(mu3(p)))
mu3 <- function(p) (exp(p[1])*(x<=i)+exp(p[2])*(x>i))*(u<=20)+
	(u>20)*(exp(p[1])*(x<=j)+exp(p[2])*(x>j))
xx <- yy <- 1970:1988
z3 <- est3 <- ll3 <- NULL
for(j in yy){
	z3$est  <- c(1.2,2.5)
	for(i in xx){
		z3 <- nlm(like3,z3$est)
		ll3 <- c(ll3,-z3$min-sum(lgamma(y+1)))
		est3 <- rbind(est3,z3$est)}}
-max(ll3)
print(means <- exp(est3[ll3==max(ll3),]))
c(mean(y[1:15]),mean(y[16:20]),mean(y[21:31]),mean(y[32:40]))
ll3 <- matrix(ll3,ncol=19)
dimnames(ll3) <- list(xx,yy)

if(interactive()){
postscript(file="hus2.eps",height=10)
par(mfrow=c(2,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
contour(xx+0.5,yy+0.5,ll3-max(ll3),levels=seq(-70,0,by=5),labcex=0.6)
title(ylab="Birmingham",xlab="Newcastle-upon-Tyne")
points(1980.5,1984.5,pch=3)
par(mar=c(0,0,0,2))
persp(xx+0.5,yy+0.5,ll3-max(ll3),phi=25,theta=-45,r=20,
	xlab="Newcastle-upon-Tyne",ylab="Birmingham",
	zlab="Log normed profile likelihood",tick="detail",cex=0.7)
par(mar=c(3.5,3.5,3,1))
contour(xx+0.5,yy+0.5,exp(ll3-max(ll3)),
	levels=seq(0.1,0.9,by=0.1))
title(ylab="Birmingham",xlab="Newcastle-upon-Tyne")
points(1980.5,1984.5,pch=3)
par(mar=c(0,0,0,2))
persp(xx+0.5,yy+0.5,exp(ll3-max(ll3)),phi=25,theta=-45,r=20,
	zlab="Normed profile likelihood",xlab="Newcastle-upon-Tyne",
	ylab="Birmingham",tick="detail",cex=0.7)
dev.off()

postscript(file="hus3.eps",height=5,width=5)
par(mfrow=c(1,1),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(1970:1989,y[1:20],xlab="Year",ylab="Count")
points(1970:1989,y[21:40],pch=2)
lines(c(1970,1984),rep(means[1],2)-0.1,lty=2)
lines(c(1985,1989),rep(means[2],2)-0.1,lty=2)
lines(c(1970,1980),rep(means[1],2)+0.1,lty=1)
lines(c(1981,1989),rep(means[2],2)+0.1,lty=1)
legend(1970,18,legend=c("Birmingham","Newcastle-upon-Tyne"),
	pch=2:1,lty=1:2,bty="n")
dev.off()
}

like4 <- function(p) sum(mu4(p)-y*log(mu4(p)))
mu4 <- function(p) (exp(p[1])*(x<=i)+exp(p[2])*(x>i))*(u<=20)+
	(u>20)*(exp(p[3])*(x<=j)+exp(p[4])*(x>j))
z4 <- est4 <- ll4 <- NULL
for(i in 1970:1988){
	z4$est  <- c(1.2,2.5,1.2,2.5)
	for(j in 1970:1988){
		z4 <- nlm(like4,z4$est)
		ll4 <- c(ll4,-z4$min-sum(lgamma(y+1)))
		est4 <- rbind(est4,z4$est)}}
-max(ll4)
exp(est4[ll4==max(ll4),])
c(mean(y[1:15]),mean(y[16:20]),mean(y[21:31]),mean(y[32:40]))
ll4 <- matrix(ll4,ncol=19)
dimnames(ll4) <- list(1970:1988,1970:1988)

if(interactive()){
#postscript(file="hus2.eps",height=5,width=5)
par(mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
contour(1970.5:1988.5,1970.5:1988.5,ll4-max(ll4),levels=seq(-70,0,by=5))
title(xlab="Birmingham",ylab="Newcastle-upon-Tyne")
points(1980.5,1984.5,pch=3)
dev.off()
}

# change times for plotting
resp <- restovec(matrix(y,nrow=2,byrow=T),times=1970:1989)
reps <- rmna(resp,ccov=ccov)

print(z <- hidden(reps,dist="Poisson",pgamma=matrix(c(0.8,0.1,0.2,0.9),ncol=2),
	mu=~1,pmu=c(1,6)))
print(z3 <- hidden(reps,dist="Poisson",
	pgamma=matrix(c(0.6,0.1,0.1,0.2,0.7,0.1,0.2,0.2,0.8),ncol=3),
	mu=~1,pmu=c(1,6,7)))

if(interactive()){
postscript(file="hus4.eps",height=5)
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(z,nind=2,xlim=c(1970,1990),xlab="Year",main="Birmingham")
plot(z,xlim=c(1970,1990),ylab="",xlab="Year",main="Newcastle-upon-Tyne")
dev.off()
}

if(interactive()){
postscript(file="hus5.eps",height=5)
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(iprofile(z),nind=2,pch=20,xlim=c(1970,1990),ylab="Count",
	xlab="Year",main="Birmingham")
plot(iprofile(z),pch=20,xlim=c(1970,1990),ylab="",xlab="Year",
	main="Newcastle-upon-Tyne")
dev.off()
}
