library(gnlm)

data <- read.table("epidemic.dat",skip=2,header=T)
attach(data)
times <- 1:36

gnlr(Measles,dist="Poisson",mu=~m*(1+m0*exp(-times/(s*2))*cos(e*(times-3))),
	pmu=c(1500,0.7,10,0.3))
print(z0 <- gnlr(Measles,dist="negative binomial",psh=0,
	mu=~m*(1+m0*exp(-times/(s*2))*cos(e*(times-3))),
	pmu=c(930,1.,4000,0.3)))
1/(z0$coef[1]*z0$coef[3])
gnlr(Measles,dist="Poisson",mu=~m*(1+m0*cos(e*(times-3))),pmu=c(1500,0.7,0.3))
gnlr(Measles,dist="negative binomial",mu=~m*(1+m0*cos(e*(times-3))),
	pmu=c(836,1,0.3),psh=-0.6)
print(zmp <- gnlr(Measles,dist="Poisson",mu=~m*exp(1+m0*cos(e*(times-3))),
	pmu=c(41.6,3.8,0.28)))
print(zmnb <- gnlr(Measles,dist="negative binomial",
	mu=~m*exp(1+m0*cos(e*(times-3))),pmu=c(41.6,3.8,0.28),psh=0))
2*pi/zmnb$coef[3]
print(zmp2 <- gnlr(Measles,dist="Poisson",
	mu=~m*(1+exp(m0*cos(e*(times-3)))),pmu=c(41.6,3.8,0.28)))
print(zmnb2 <- gnlr(Measles,dist="negative binomial",
	mu=~m*(1+exp(m0*cos(e*(times-3)))),pmu=c(41.6,3.8,0.28),psh=0))
2*pi/zmnb2$coef[3]
print(zmc <- gnlr(Measles,dist="Consul",
	mu=~m*exp(1+m0*cos(e*(times-3))),pmu=c(143,2.2,0.29),psh=0))

gnlr(Chickenpox,dist="Poisson",mu=~m*(1+m0*exp(-times/(s*2))*cos(e*(times-3))),
	pmu=c(500,3.7,4.9,0.22))
print(z1 <- gnlr(Chickenpox,dist="negative binomial",psh=0,
	mu=~m*(1+m0*exp(-times/(s*2))*cos(e*(times-3))),
	pmu=c(480,0.6,10,0.5)))
1/(z1$coef[1]*z1$coef[3])
print(zcp <- gnlr(Chickenpox,dist="Poisson",mu=~m*(1+m0*cos(e*(times-3))),
	pmu=c(480,0.6,0.5)))
print(zcnb <- gnlr(Chickenpox,dist="negative binomial",
	mu=~m*(1+m0*cos(e*(times-3))),pmu=c(480,0.6,0.5),psh=0))
2*pi/zcnb$coef[3]
print(zcc <- gnlr(Chickenpox,dist="Consul",
	mu=~m*(1+m0*cos(e*(times-3))),pmu=c(480,0.6,0.5),psh=0))
gnlr(Chickenpox,dist="Poisson",mu=~m*exp(1+m0*cos(e*(times-3))),
	pmu=c(41.6,3.8,0.28))
gnlr(Chickenpox,dist="negative binomial",mu=~m*exp(1+m0*cos(e*(times-3))),
	pmu=c(168,0.02,0.1),psh=0)

if(interactive()){
postscript("epidemic.eps")
par(mfrow=c(2,1),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0),font.main=1)
plot(times,Chickenpox,xlab="",ylab="Cases",pch=20,main="Chicken pox")
lines(times,zcnb$fit)
lines(times,zcp$fit,lty=3)
plot(times,Measles,xlab="Month",ylab="Cases",pch=20,main="Measles")
lines(times,zmnb2$fit)
lines(times,zmp2$fit,lty=3)
legend(10,6000,legend=c("Poisson","negative binomial"),lty=c(1,3),bty="n")
dev.off()
}
