y <- scan("cauchy.dat")

likefn <- function(p) -sum(log(dcauchy(y,p[1],p[2])))
print(z <- nlm(likefn,p=c(0,1)))

# joint contours
like <- matrix(0,ncol=21,nrow=21)
for(i in 1:21)for(j in 1:21)
	like[i,j] <- likefn(c(i/10-1.1+z$est[1],j/10-1.1+z$est[2]))
like <- exp(-like+z$min)
contour((1:21)/10-1.1+z$est[1],(1:21)/21-1.1+z$est[2],like)
title(xlab="Location",ylab="Dispersion")

# profile likelihood for location parameter
likefn1 <- function(p) -sum(log(dcauchy(y,i,p[1])))
like1 <- NULL
zz <- list(est=z$est[2])
for(i in (1:21)/10-1.1+z$est[1]){
	zz <- nlm(likefn1,zz$est)
	like1 <- c(like1,zz$min)}
like1 <- exp(-like1+z$min)
plot((1:21)/10-1.1+z$est[1],like1,type="l",xlab="Location",
	ylab="Normed likelihood")

# profile likelihood for dispersion parameter
likefn2 <- function(p) -sum(log(dcauchy(y,p[1],i)))
like2 <- NULL
zz <- list(est=z$est[1])
for(i in (1:21)/10-1.1+z$est[2]){
	zz <- nlm(likefn2,zz$est)
	like2 <- c(like2,zz$min)}
like2 <- exp(-like2+z$min)
plot((1:21)/10-1.1+z$est[2],like2,type="l",xlab="Dispersion",
	ylab="Normed likelihood")
