library(rmutil)

# test data
y <- rbinom(20,5,0.5)
n <- rep(5,20)
x <- rnorm(20)

mu <- finterp(~exp(a+b*x)/(1+exp(a+b*x)))
disp <- finterp(~exp(c+d*x))
lbetabinom <-
	finterp(~-lbeta(y+m*s,n-y+(1-m)*s)+lbeta(m*s,(1-m)*s)-lchoose(n,y),
		.vector=F)
likebb <- function(p){
	n1 <- length(attr(mu,"parameters"))+1
	n2 <- n1+length(attr(disp,"parameters"))-1
	sum(lbetabinom(m=mu(p),s=disp(p[n1:n2])))}
nlm(likebb,p=c(1,0,1,0))

# or

mu <- fnenvir(function(p){
	tmp <- exp(p[1]+p[2]*x)
	tmp/(1+tmp)})
disp <- fnenvir(function(p) exp(p[1]+p[2]*x))
lbetabinom <- fnenvir(function(m, s){
	t <- s*m
	u <- s*(1-m)
	-lbeta(y+t,n-y+u)+lbeta(t,u)-lchoose(n,y)})
likebb <- function(p){
	n1 <- length(attr(mu,"parameters"))+1
	n2 <- n1+length(attr(disp,"parameters"))-1
	sum(lbetabinom(m=mu(p),s=disp(p[n1:n2])))}
nlm(likebb,p=c(1,0,1,0))
