library(repeated)
library(gnlm)

dat <- read.list("urinary.dat",skip=3,nlines=1)

# fill in times
for(i in 1:length(dat))dat[[i]] <- cbind(dat[[i]],1:length(dat[[i]]))
treatment <- c(rep(0,36),rep(1,36))
reps <- rmna(restovec(dat),ccov=tcctomat(treatment))

glm(dat~1,family=binomial,data=reps)
glm(dat~treatment,family=binomial,data=reps)
glm(dat~treatment+times,family=binomial,data=reps)
glm(dat~treatment*times,family=binomial,data=reps)
# fixed effects
glm(dat~treatment+individuals,family=binomial,data=reps)

# same as with glm
gnlr(reps,dist="binomial",pmu=0.3)
gnlr(reps,mu=~treatment,dist="binomial",pmu=c(0.3,0))
gnlr(reps,mu=~treatment+times,dist="binomial",pmu=c(0.44,0.27,0))

# random effects
gnlmm(reps,dist="binomial",pmu=0.6,psd=0.9)
gnlmm(reps,mu=~treatment,dist="binomial",pmu=c(0.44,0.27),psd=0.5)
gnlmm(reps,mu=~treatment+times,dist="binomial",pmu=c(0.44,0.28,-0.0002),
	psd=0.52)

# autoregression
gar(reps,mu=~1,dist="binomial",preg=0.45,pdep=0.1)
print(zar <- gar(reps,mu=~treatment,dist="binomial",preg=c(0.45,0.27),
	pdep=0.14))
gar(reps,mu=~treatment+times,dist="binomial",preg=c(0.58,0.27,-0.0002),
	pdep=0.1)
if(interactive()){
par(mfrow=c(2,3))
for(i in 1:3){
      plot(iprofile(zar),nind=i,lty=3)
      plot(mprofile(zar),nind=i,add=T)}
for(i in 37:39){
      plot(iprofile(zar),nind=i,lty=3)
      plot(mprofile(zar),nind=i,add=T)}
}
