library(growth)                    

dat <- read.table("gastric.dat",skip=7)
y <- as.matrix(dat[,c(2,4,6)])
period <- as.matrix(dat[,c(1,3,5)])
treatment <- matrix(rep(c("A","B","C"),12),ncol=3,byrow=T)

# reorder responses and treatments according to period
treat <- yy <- matrix(0,ncol=3,nrow=12)
yy[cbind(rep(1:12,3),as.vector(period))] <- y
treat[cbind(rep(1:12,3),as.vector(period))] <- treatment

carryover <- cbind(rep("N",12),treat[,1:2])

resp <- restovec(yy)
tvc <- tvctomat(treat)
tvc <- tvctomat(carryover,old=tvc)
reps <- rmna(resp,tvc=tvc)
reps <- transform(reps,lyy=log(yy))

# times are the periods
summary(z <- glm(yy~treat+as.factor(times)+carryover+individuals,data=reps))
z$aic/2
summary(glm(yy~treat+carryover+individuals,data=reps))
summary(glm(yy~treat+individuals,data=reps))
summary(glm(yy~carryover+individuals,data=reps))

elliptic(yy,tvc=~treat+as.factor(times)+individuals,pvar=300,envir=reps)
elliptic(yy,tvc=~treat+carryover+individuals,pvar=300,envir=reps)
elliptic(yy,tvc=~treat+individuals,pvar=300,envir=reps)
elliptic(yy,tvc=~treat,pvar=300,pre=10,envir=reps)
elliptic(lyy,tvc=~treat+as.factor(times)+individuals,pvar=1,envir=reps)
elliptic(lyy,tvc=~treat+carryover+individuals,pvar=1,envir=reps)
elliptic(lyy,tvc=~treat+individuals,pvar=0.1,envir=reps)
elliptic(lyy,tvc=~treat,pvar=6,pre=1,envir=reps)
