library(repeated)

y <- scan("vigilant.etal",what=character(0),skip=11)
# skip chimpanzee: 378 instead of 380
yy <- NULL
for(i in seq(2,378,by=2))yy <- rbind(yy,strsplit(y[[i]],split=NULL)[[1]])
yyy <- apply(yy,2,table)
yyyy <- matrix(0,ncol=6,nrow=length(yyy))
colnames(yyyy) <- c("-","N","A","C","G","T")
j <- 0
for(i in yyy){
	j <- j+1
	col <- match(dimnames(i)[[1]],c("-","N","A","C","G","T"))
	yyyy[j,col] <- as.vector(i)}
# position 152 is always - (chimpanzee has C)
yyyy <- yyyy[-152,]
# combine N and -
yyyy <- cbind(yyyy[,1]+yyyy[,2],yyyy[,3:6])
colnames(yyyy) <- c("N","A","C","G","T")
reps <- rmna(restovec(yyyy,type=rep("nominal",5),times=1:dim(yyyy)[1]))

print(z1 <- hidden(reps,pgamma=1,mu=~1,dist="mult",pmu=rep(2,4)))
print(z2 <- hidden(reps,pgamma=matrix(c(0.9,0.05,0.1,0.95),ncol=2),
	mu=~1,dist="mult",pmu=rep(0,8)))

# A,C,G,T only: finds sequences of C (state 2)
reps4 <- rmna(restovec(yyyy[,2:5],type=rep("nominal",4),times=1:dim(yyyy)[1]),
	tvc=tvctomat(list(data.frame(pos=as.factor(rep(1:3,length=763))))))
print(z41 <- hidden(reps4,pgamma=1,mu=~1,dist="mult",pmu=rep(1,3)))
print(z42 <- hidden(reps4,pgamma=matrix(c(0.9,0.05,0.1,0.95),ncol=2),
	mu=~1,dist="mult",pmu=rep(0,6)))

print(z41t <- hidden(reps4,pgamma=1,mu=~pos,dist="mult",pmu=rep(1,9)))
print(z42t <- hidden(reps4,pgamma=matrix(c(0.9,0.05,0.1,0.95),ncol=2),
	mu=~pos,dist="mult",pmu=rep(0,18)))

y5 <- apply(yyyy[,2:5],1,max)
y5 <- cbind(y5,apply(yyyy[,2:5],1,sum)-y5)
colnames(y5) <- c("stable","mutation")
reps2 <- rmna(restovec(y5,type=rep("nominal",2),times=1:dim(yyyy)[1]),
	tvc=tvctomat(list(data.frame(pos=as.factor(rep(1:3,length=763))))))
relfreq <- response(reps2)[,2]/(response(reps2)[,1]+response(reps2)[,2])
# in fact, two segments: 1-376 and 377-763
reps2a <- rmna(restovec(y5[1:376,],type=rep("nominal",2),times=1:376),
	tvc=tvctomat(list(data.frame(pos=as.factor(rep(1:3,length=376))))))
reps2b <- rmna(restovec(y5[377:763,],type=rep("nominal",2),times=1:387),
	tvc=tvctomat(list(data.frame(pos=as.factor(rep(1:3,length=387))))))
relfreqa <- response(reps2a)[,2]/(response(reps2a)[,1]+response(reps2a)[,2])
relfreqb <- response(reps2b)[,2]/(response(reps2b)[,1]+response(reps2b)[,2])

print(u1 <- hidden(reps2,pgamma=1,mu=~1,dist="mult",pmu=-1))
print(u2 <- hidden(reps2,pgamma=matrix(c(0.9,0.05,0.1,0.95),ncol=2),
	mu=~1,dist="mult",pmu=rep(-2,2)))
print(u3 <- hidden(reps2,pgamma=matrix(c(0.9,0.05,0.05,0.05,0.85,
	0.05,0.05,0.1,0.9),ncol=3),mu=~1,dist="mult",pmu=rep(-2,3)))
print(u2p <- hidden(reps2,pgamma=matrix(c(0.9,0.05,0.1,0.95),ncol=2),
	mu=~pos,dist="mult",pmu=rep(0,6)))

relfreq[u2$filt[1,]>0.999]
relfreq[relfreq>0.047]

if(interactive()){
par(mfcol=c(2,1),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(relfreq,type="l",ylab="Probability of mutation",xlab="")
plot(u2,main="",ylab="Probability of State 1",xlab="Position")

par(mfcol=c(3,1),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(relfreq,type="l",ylab="Probability of mutation",xlab="")
plot(u3$filt[1,],type="l",main="",ylab="Probability of State 1",
	xlab="")
plot(u3$filt[2,],type="l",main="",ylab="Probability of State 2",
	xlab="Position")
}

print(u1a <- hidden(reps2a,pgamma=1,mu=~1,dist="mult",pmu=-1))
print(u2a <- hidden(reps2a,pgamma=matrix(c(0.9,0.05,0.1,0.95),ncol=2),
	mu=~1,dist="mult",pmu=rep(-2,2)))
print(u3a <- hidden(reps2a,pgamma=matrix(c(0.9,0.05,0.05,0.05,0.85,
	0.05,0.05,0.1,0.9),ncol=3),mu=~1,dist="mult",pmu=rep(-2,3)))
print(u2ap <- hidden(reps2a,pgamma=matrix(c(0.9,0.05,0.1,0.95),ncol=2),
	mu=~pos,dist="mult",pmu=rep(0,6)))
print(u2ap1 <- hidden(reps2a,pgamma=matrix(c(0.9,0.05,0.1,0.95),ncol=2),
	mu=list(~pos,~1),dist="mult",pmu=rep(0,4)))

print(u1b <- hidden(reps2b,pgamma=1,mu=~1,dist="mult",pmu=-1))
print(u2b <- hidden(reps2b,pgamma=matrix(c(0.9,0.05,0.1,0.95),ncol=2),
	mu=~1,dist="mult",pmu=rep(-2,2)))
print(u3b <- hidden(reps2b,pgamma=matrix(c(0.9,0.05,0.05,0.05,0.85,
	0.05,0.05,0.1,0.9),ncol=3),mu=~1,dist="mult",pmu=rep(-2,3)))
print(u2bp <- hidden(reps2b,pgamma=matrix(c(0.9,0.05,0.1,0.95),ncol=2),
	mu=~pos,dist="mult",pmu=rep(0,6)))
print(u2bp1 <- hidden(reps2b,pgamma=matrix(c(0.9,0.05,0.1,0.95),ncol=2),
	mu=list(~pos,~1),dist="mult",pmu=rep(0,4)))

if(interactive()){
postscript("vigilant.eps",height=5,width=7)
par(mfcol=c(2,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(relfreqa,type="l",ylab="Probability of mutation",xlab="",ylim=c(0,1))
plot(u2a,main="",ylab="Probability of State 1",xlab="Position")
plot(relfreqb,type="l",ylab="",xlab="",ylim=c(0,1))
plot(u2b,main="",ylab="",xlab="Position")
dev.off()

par(mfcol=c(2,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(relfreqa,type="l",ylab="Probability of mutation",xlab="",ylim=c(0,1))
plot(u2ap,main="",ylab="Probability of State 1",xlab="Position")
plot(relfreqb,type="l",ylab="",xlab="",ylim=c(0,1))
plot(u2bp,main="",ylab="",xlab="Position")
}
