library(repeated)

y <- strsplit(scan("betaglobin",what=character(0),skip=17,nlines=1)[2],
	split=NULL)[[1]]

pre <- 1:870
exon1 <- 871:963      #   1:  93
intron1 <- 964:1093   #  94: 223
exon2 <- 1094:1316    # 224: 446
intron2 <- 1317:2166  # 447:1296
exon3 <- 2167:2294    #1297:1424
post <- 2295:3007
intron <- c(intron1,intron2)
exon <- c(exon1,exon2,exon3)
gene <- c(exon1,intron1,exon2,intron2,exon3)

rep <- rmna(restovec(codes(as.factor(y[y!="."]))-1,times=1:length(y[y!="."])),
	tvcov=tvctomat(list(as.factor(rep(1:3,length=length(y[y!="."])))),
	name="pos"))
repm <- rmna(restovec(codes(as.factor(y[y!="."]))-1,times=1:length(y[y!="."])),
	tvcov=tvctomat(list(data.frame(
	pos=as.factor(rep(1:3,length=length(y[y!="."]))),
	lag=as.factor(c(0,(codes(as.factor(y[y!="."]))-1)[-3000]))))))
repg <- rmna(restovec(codes(as.factor(y[gene]))-1,times=1:length(gene)),
	tvcov=tvctomat(list(as.factor(rep(1:3,length=length(gene)))),
	name="pos"))
repe <- rmna(restovec(codes(as.factor(y[exon]))-1,times=1:length(exon)),
	tvcov=tvctomat(list(as.factor(rep(1:3,length=length(exon)))),
	name="pos"))
repi <- rmna(restovec(codes(as.factor(y[intron]))-1,times=1:length(intron)),
	tvcov=tvctomat(list(as.factor(rep(1:3,length=length(intron)))),
	name="pos"))

print(z1 <- hidden(rep,mu=~1,pgamma=1,pmu=rep(1,3),dist="multinomial"))
print(z1a <- hidden(rep,mu=~pos,pgamma=1,pmu=rep(1,9),dist="multinomial"))
print(z2 <- hidden(rep,mu=~1,pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,6),dist="multinomial"))
print(z2a <- hidden(rep,mu=~pos,pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,18),dist="multinomial"))
print(z2b <- hidden(rep,mu=list(~pos,~1,~pos,~1,~pos,~1),
	pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,12),dist="multinomial"))
print(z3 <- hidden(rep,mu=~1,
	pgamma=matrix(c(0.9,0.2,0.1,0.05,0.7,0.05,0.05,0.1,0.85),ncol=3),
	pmu=rep(1,9),dist="multinomial"))
if(interactive()){
par(font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(z2,xlab="Position",ylab="Probability",main="")
lines(c(871,963),rep(0.5,2))
lines(c(1094,1316),rep(0.5,2))
lines(c(2167,2294),rep(0.5,2))
dev.off()
}

print(zg1 <- hidden(repg,mu=~1,pgamma=1,pmu=rep(1,3),dist="multinomial"))
print(zg1a <- hidden(repg,mu=~pos,pgamma=1,pmu=rep(1,9),dist="multinomial"))
print(zg2 <- hidden(repg,mu=~1,pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,6),dist="multinomial"))
# finds most of intron 2
print(zg2a <- hidden(repg,mu=~pos,pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,18),dist="multinomial"))
c(1,exp(zg2a$coef[seq(1,18,by=6)]))/sum(c(1,exp(zg2a$coef[seq(1,18,by=6)])))
c(1,exp(zg2a$coef[seq(1,18,by=6)]+zg2a$coef[seq(2,18,by=6)]))/
	sum(c(1,exp(zg2a$coef[seq(1,18,by=6)]+zg2a$coef[seq(2,18,by=6)])))
c(1,exp(zg2a$coef[seq(1,18,by=6)]+zg2a$coef[seq(3,18,by=6)]))/
	sum(c(1,exp(zg2a$coef[seq(1,18,by=6)]+zg2a$coef[seq(3,18,by=6)])))

c(1,exp(zg2a$coef[seq(4,18,by=6)]))/sum(c(1,exp(zg2a$coef[seq(4,18,by=6)])))
c(1,exp(zg2a$coef[seq(4,18,by=6)]+zg2a$coef[seq(5,18,by=6)]))/
	sum(c(1,exp(zg2a$coef[seq(4,18,by=6)]+zg2a$coef[seq(5,18,by=6)])))
c(1,exp(zg2a$coef[seq(4,18,by=6)]+zg2a$coef[seq(6,18,by=6)]))/
	sum(c(1,exp(zg2a$coef[seq(4,18,by=6)]+zg2a$coef[seq(6,18,by=6)])))
print(zg2b <- hidden(repg,mu=list(~pos,~1,~pos,~1,~pos,~1),
	pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,12),dist="multinomial"))
print(zg3 <- hidden(repg,mu=~1,
	pgamma=matrix(c(0.9,0.2,0.1,0.05,0.7,0.05,0.05,0.1,0.85),ncol=3),
	pmu=rep(1,9),dist="multinomial"))

if(interactive()){
postscript("betaglobin2.eps",height=6,width=7)
par(mfcol=c(2,1),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(1:length(gene)+870,zg2$filt[1,],type="l",xlab="",ylab="Probability")
lines(c(1,93)+870,rep(0.5,2))
lines(c(224,446)+870,rep(0.5,2))
lines(c(1297,1424)+870,rep(0.5,2))
plot(1:length(gene)+870,zg2a$filt[2,],type="l",xlab="Position",
	ylab="Probability")
lines(c(1,93)+870,rep(0.5,2))
lines(c(224,446)+870,rep(0.5,2))
lines(c(1297,1424)+870,rep(0.5,2))
dev.off()
par(mfcol=c(3,1),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(1:length(gene)+870,zg3$filt[1,],type="l",xlab="Position",
	ylab="Probability")
lines(c(1,93)+870,rep(0.5,2))
lines(c(224,446)+870,rep(0.5,2))
lines(c(1297,1424)+870,rep(0.5,2))
plot(1:length(gene)+870,zg3$filt[2,],type="l",xlab="Position",
	ylab="Probability")
lines(c(1,93)+870,rep(0.5,2))
lines(c(224,446)+870,rep(0.5,2))
lines(c(1297,1424)+870,rep(0.5,2))
plot(1:length(gene)+870,zg3$filt[3,],type="l",xlab="Position",
	ylab="Probability")
lines(c(1,93)+870,rep(0.5,2))
lines(c(224,446)+870,rep(0.5,2))
lines(c(1297,1424)+870,rep(0.5,2))
}

print(ze1 <- hidden(repe,mu=~1,pgamma=1,pmu=rep(1,3),dist="multinomial"))
print(ze1a <- hidden(repe,mu=~pos,pgamma=1,pmu=rep(1,9),dist="multinomial"))
print(ze2 <- hidden(repe,mu=~1,pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,6),dist="multinomial"))
print(ze2a <- hidden(repe,mu=~pos,pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,18),dist="multinomial"))
print(ze2b <- hidden(repe,mu=list(~pos,~1,~pos,~1,~pos,~1),
	pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,12),dist="multinomial"))

print(zi1 <- hidden(repi,mu=~1,pgamma=1,pmu=rep(1,3),dist="multinomial"))
print(zi1a <- hidden(repi,mu=~pos,pgamma=1,pmu=rep(1,9),dist="multinomial"))
print(zi2 <- hidden(repi,mu=~1,pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,6),dist="multinomial"))
print(zi2a <- hidden(repi,mu=~pos,pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,18),dist="multinomial"))

print(zm1 <- hidden(repm,mu=~lag,pgamma=1,pmu=rep(1,12),dist="multinomial"))
print(zm2 <- hidden(repm,mu=~lag,pgamma=matrix(c(0.9,0.2,0.1,0.8),ncol=2),
	pmu=rep(1,24),dist="multinomial"))
c(1,exp(zm2$coef[seq(1,24,by=8)]))/sum(c(1,exp(zm2$coef[seq(1,24,by=8)])))
c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(2,24,by=8)]))/
	sum(c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(2,24,by=8)])))
c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(3,24,by=8)]))/
	sum(c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(3,24,by=8)])))
c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(4,24,by=8)]))/
	sum(c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(4,24,by=8)])))

c(1,exp(zm2$coef[seq(5,24,by=8)]))/sum(c(1,exp(zm2$coef[seq(5,24,by=8)])))
c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(6,24,by=8)]))/
	sum(c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(6,24,by=8)])))
c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(7,24,by=8)]))/
	sum(c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(7,24,by=8)])))
c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(8,24,by=8)]))/
	sum(c(1,exp(zm2$coef[seq(1,24,by=8)]+zm2$coef[seq(8,24,by=8)])))
print(zm3 <- hidden(repm,mu=~lag,
	pgamma=matrix(c(0.9,0.2,0.1,0.05,0.7,0.05,0.05,0.1,0.85),ncol=3),
	pmu=rep(1,36),dist="multinomial"))
c(1,exp(zm3$coef[seq(1,36,by=12)]))/sum(c(1,exp(zm3$coef[seq(1,36,by=12)])))
c(1,exp(zm3$coef[seq(1,36,by=12)]+zm3$coef[seq(2,36,by=12)]))/
	sum(c(1,exp(zm3$coef[seq(1,36,by=12)]+zm3$coef[seq(2,36,by=12)])))
c(1,exp(zm3$coef[seq(1,36,by=12)]+zm3$coef[seq(3,36,by=12)]))/
	sum(c(1,exp(zm3$coef[seq(1,36,by=12)]+zm3$coef[seq(3,36,by=12)])))
c(1,exp(zm3$coef[seq(1,36,by=12)]+zm3$coef[seq(4,36,by=12)]))/
	sum(c(1,exp(zm3$coef[seq(1,36,by=12)]+zm3$coef[seq(4,36,by=12)])))

c(1,exp(zm3$coef[seq(5,36,by=12)]))/sum(c(1,exp(zm3$coef[seq(5,36,by=12)])))
c(1,exp(zm3$coef[seq(5,36,by=12)]+zm3$coef[seq(6,36,by=12)]))/
	sum(c(1,exp(zm3$coef[seq(5,36,by=12)]+zm3$coef[seq(6,36,by=12)])))
c(1,exp(zm3$coef[seq(5,36,by=12)]+zm3$coef[seq(7,36,by=12)]))/
	sum(c(1,exp(zm3$coef[seq(5,36,by=12)]+zm3$coef[seq(7,36,by=12)])))
c(1,exp(zm3$coef[seq(5,36,by=12)]+zm3$coef[seq(8,36,by=12)]))/
	sum(c(1,exp(zm3$coef[seq(5,36,by=12)]+zm3$coef[seq(8,36,by=12)])))

c(1,exp(zm3$coef[seq(9,36,by=12)]))/sum(c(1,exp(zm3$coef[seq(9,36,by=12)])))
c(1,exp(zm3$coef[seq(9,36,by=12)]+zm3$coef[seq(10,36,by=12)]))/
	sum(c(1,exp(zm3$coef[seq(9,36,by=12)]+zm3$coef[seq(10,36,by=12)])))
c(1,exp(zm3$coef[seq(9,36,by=12)]+zm3$coef[seq(11,36,by=12)]))/
	sum(c(1,exp(zm3$coef[seq(9,36,by=12)]+zm3$coef[seq(11,36,by=12)])))
c(1,exp(zm3$coef[seq(9,36,by=12)]+zm3$coef[seq(12,36,by=12)]))/
	sum(c(1,exp(zm3$coef[seq(9,36,by=12)]+zm3$coef[seq(12,36,by=12)])))

if(interactive()){
postscript("betaglobin1.eps",height=6,width=7)
par(mfcol=c(2,1),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(z2,xlab="",ylab="Probability",main="")
lines(c(871,963),rep(0.5,2))
lines(c(1094,1316),rep(0.5,2))
lines(c(2167,2294),rep(0.5,2))
plot(zm2,state=2,xlab="Position",ylab="Probability",main="")
lines(c(871,963),rep(0.5,2))
lines(c(1094,1316),rep(0.5,2))
lines(c(2167,2294),rep(0.5,2))
dev.off()
}
