# normal regression model
x <- 1:10
y <- c(2+3*x+rnorm(10,0,3),2+3*x+rnorm(10,0,3))
x <- c(x,x)
z <- lm(y~x)
n <- dnorm(seq(-6,6,by=0.5),0,sqrt(sum(z$resi^2)/18))
postscript("normreg.eps",width=5,height=5)
par(mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(x,y,pch=20,ylim=c(0,40),xlim=c(1,11),xlab=expression(x),
	ylab=expression(y))
lines(c(1,10),c(z$coef[1]+z$coef[2],z$coef[1]+10*z$coef[2]))
plotn <- function(a) {
	lines(10*n+a,z$coef[1]+a*z$coef[2]+seq(-6,6,by=0.5))
	lines(rep(a,25),z$coef[1]+a*z$coef[2]+seq(-6,6,by=0.5))}
plotn(1.5)
plotn(3.5)
plotn(5.5)
plotn(7.5)
plotn(9.5)
dev.off()
