library(repeated)

data <- read.table("fluvox2.dat",skip=3,head=T)
attach(data)
resp <- cbind(rep(V1,Freq),rep(V2,Freq),rep(V3,Freq))
resp[269:299,3] <- NA
resp <- as.vector(t(resp))
id <- as.numeric(gl(299,3,897))[!is.na(resp)]
times <- rep(1:3,299)[!is.na(resp)]-2
#times <- rep(c(-1,0,4),299)[!is.na(resp)]
resp <- resp[!is.na(resp)]

-sum(Freq*log(Freq/299))
-sum(Freq*log(Freq/299))+length(Freq)-1

logitord(resp,id,pout=c(1,3,5),pdrop=0.1)
logitord(resp,id,pout=c(0,4,6),pdrop=0.1,random.drop.int=F)
logitord(resp,id,pout=c(0,3,5),pdrop=0.1,random.out.int=F)
logitord(resp,id,pout=c(0,3,5),pdrop=0.1,random.out.int=F,
	random.drop.int=F)

logitord(resp,id,tvcov=times,pout=c(0,3,5,2),pdrop=c(-1),drop.tvcov=F)
logitord(resp,id,tvcov=times,pout=c(0,3,5,2),pdrop=c(-1),
	drop.tvcov=F,random.drop.sl=F)
logitord(resp,id,tvcov=times,pout=c(0,3,5,2),pdrop=c(-1),
	drop.tvcov=F,random.drop.sl=F,random.drop.int=F)
logitord(resp,id,tvcov=times,pout=c(0,3,5),pdrop=c(2,0),
	out.tvcov=F)
logitord(resp,id,tvcov=times,pout=c(0,4,6,0),pdrop=c(3,-1.4))
logitord(resp,id,tvcov=times,pout=c(0,5,7,2),pdrop=c(-1.4,1),
	random.drop.sl=F)
logitord(resp,id,tvcov=times,pout=c(0,5,7,2),pdrop=c(-1.4,1),
	random.drop.sl=F,random.drop.int=F)
logitord(resp,id,tvcov=times,pout=c(0,5,7,2),pdrop=c(-1.4,1),
	random.out.sl=F)
logitord(resp,id,tvcov=times,pout=c(0,5,7,2),pdrop=c(-1.4,1),
	random.out.sl=F,random.drop.sl=F)

resp <- ifelse(resp>0,5-resp,0)
logitord(resp,id,tvcov=times,pout=c(0,1,2,0),pdrop=c(1,-1))
