library(repeated)

y <- read.table("continen.dat",skip=3,head=T)
attach(y)
freq <- as.vector(as.matrix(y[,4:5]))
response <- cbind(y1,y2,y3)

catmiss(response,freq,ccov=c("M","F"))

sx <- gl(2,18,36)
resp <- ifelse(is.na(response),"Z",response)
y1 <- as.factor(rep(resp[,1],2))
y2 <- as.factor(rep(resp[,2],2))
y3 <- as.factor(rep(resp[,3],2))
tmp <- tmp2 <- NULL
resp <- response
attributes(resp)$levels <- NULL
for(i in 1:nrow(response)){
      tmp <- c(tmp,sum(as.numeric(resp[i,1]),as.numeric(resp[i,2]),as.numeric(resp[i,3]),na.rm=T))
      tmp2 <- c(tmp2,sum(is.na(resp[i,1]),is.na(resp[i,2]),is.na(resp[i,3])))}
latent <- as.factor(rep(tmp-2+5*tmp2,2))

glm(freq~y1+y2+y3+sx,family=poisson)
glm(freq~y1+y2+y3+sx+latent,family=poisson)
glm(freq~y1+y2+y3+sx+latent+(y1+y2+y3):sx,family=poisson)
print(summary(z <- glm(freq~y1+y2+y3+sx+latent+(y1+y2+y3):sx
	+y1:y2+y2:y3,family=poisson)))

catmiss(response,z$fit,ccov=c("M","F"))
n1 <- y1=="Y"
o1 <- y1=="N"
n2 <- y2=="Y"
o2 <- y2=="N"
m2 <- y2=="Z"
n3 <- y3=="Y"
o3 <- y3=="N"
m3 <- y3=="Z"
print(summary(z1 <- update(z,.~.-y2:sx+n2:sx)))
catmiss(response,z1$fit,ccov=c("M","F"))
