library(event)

tumour <- read.table("tumourvol.dat",skip=6)
tumour <- as.matrix(tumour)
miss <- tumour>-1
drop <- matrix(0,nrow=30,ncol=11)
drop[,1:10] <- ifelse(miss[,1:10]&!miss[,2:11],1,0)
miss <- as.vector(t(miss))
time <- rep(c(7,11:15,17:21),30)-15
time2 <- (time^2)[miss]
ftime <- as.factor(time+15)[miss]
time <- time[miss]
off <- rep(c(4,rep(1,5),2,rep(1,4)),30)[miss]
group <- gl(3,110,330)[miss]
gp2 <- as.factor(gl(3,110,330)==3)[miss]
drop <- as.vector(t(drop))[miss]
tumour <- as.vector(t(tumour))[miss]

ehr(drop,plambda=-2,delta=off)
ehr(drop,plambda=c(-4,0,-1),delta=off,lambda=~group)
ehr(drop,plambda=c(-4,-1),delta=off,lambda=~gp2)
ehr(drop,plambda=c(-5.4,0.001),delta=off,lambda=~tumour)
ehr(drop,plambda=c(-5.5,0.21),delta=off,lambda=~time)
ehr(drop,plambda=c(-8,1.7,-0.22),delta=off,lambda=~time+time2)
ehr(drop,plambda=c(-8,rep(0,10)),delta=off,lambda=~ftime)
ehr(drop,plambda=c(-11,0,-0.3,0.001),delta=off,lambda=~time+time2+tumour)
ehr(drop,plambda=c(-11,0,-0.3,0.001),delta=off,lambda=~time+time2+gp2)
ehr(drop,plambda=c(-11,0,-0.3,0.001,0),delta=off,lambda=~time*gp2+time2)
