library(event)

tumour <- as.matrix(read.table("tumour.dat",skip=5))
drop <- matrix(0,nrow=45,ncol=19)
miss <- tumour>-1
drop[,1:18] <- ifelse(miss[,1:18]&!miss[,2:19],1,0)
miss <- as.vector(t(miss))
time <- rep(c(10:15,17:22,24:29,31),45)-20
time2 <- (time^2)[miss]
ftime <- as.factor(time+20)[miss]
time <- time[miss]
off <- rep(c(1,rep(c(rep(1,5),2),3)),45)[miss]
group <- gl(3,285,855)[miss]
gp2 <- as.factor(gl(3,285,855)==3)[miss]
drop <- as.vector(t(drop))[miss]
tumour <- as.vector(t(tumour))[miss]

ehr(drop,plambda=-4,delta=off)
ehr(drop,plambda=c(-4,0,-1),delta=off,lambda=~group)
ehr(drop,plambda=c(-4,-1),delta=off,lambda=~gp2)
ehr(drop,plambda=c(-5.4,0.001),delta=off,lambda=~tumour)
ehr(drop,plambda=c(-5.5,0.21),delta=off,lambda=~time)
ehr(drop,plambda=c(-5.5,0.1,0.002),delta=off,lambda=~time+time2)
ehr(drop,plambda=c(-8,rep(0,18)),delta=off,lambda=~ftime)
ehr(drop,plambda=c(-16,0,-0.3,0.001),delta=off,lambda=~time+time2+tumour)
print(z <- ehr(drop,plambda=c(-16,0,-0.3,0.001),delta=off,
	lambda=~time+time2+gp2))
ehr(drop,plambda=c(-16,0,-0.3,0.001,0),delta=off,lambda=~time*gp2+time2)

if(interactive()){
postscript("tumour.eps",height=5.7)
par(mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
tt <- seq(7,21,by=0.2)
risk <- function(t,tr) -12.4425+5.5818*(t-15)-0.7049*(t-15)^2+7.9819*tr-
	3.1894*(t-15)*tr
par(mfrow=c(1,2))
plot(tt,exp(risk(tt,0)),type="l",ylab="Risk of dropout",xlab="Days",
	ylim=c(0,0.3),lty=1,xaxt="n",yaxt="n")
axis(1,c(8,12,16,20))
axis(2,c(0,0.1,0.2,0.3))
lines(tt,exp(risk(tt,1)),lty=2)
legend(8,0.25,legend=c("A & B","C"),lty=c(1,2),bty="n")
tt <- seq(10,31,by=0.2)
risk <- function(t,tr) z$coef[1]+z$coef[2]*(t-20)+z$coef[3]*(t-20)^2+
	z$coef[4]*tr
plot(tt,exp(risk(tt,0)),type="l",lty=1,ylab="",xlab="Days",ylim=c(0,0.3),
	yaxt="n")
axis(2,c(0,0.1,0.2,0.3))
lines(tt,exp(risk(tt,1)),lty=2)
dev.off()
}
