tumour <- read.table("tumour.dat",skip=5)
tumour <- as.matrix(tumour)
miss <- tumour>-1
drop <- matrix(0,nrow=45,ncol=19)
drop[,1:18] <- ifelse(miss[,1:18]&!miss[,2:19],1,0)
time <- rep(c(10:15,17:22,24:29,31),45)
time2 <- time^2
ltime <- log(time)
ltime2 <- ltime^2
rtime <- 1/time
rtime2 <- rtime^2
ftime <- as.factor(time)
off <- log(rep(c(1,rep(c(rep(1,5),2),3)),45))
group <- gl(3,285,855)
gp2 <- as.factor(group==3)

miss <- as.vector(t(miss))
drop <- as.vector(t(drop))
tumour <- as.vector(t(tumour))
glm(drop~1, family=poisson,weights=miss,offset=off)
summary(glm(drop~tumour, family=poisson,weights=miss,offset=off))
summary(glm(drop~group, family=poisson,weights=miss,offset=off))
summary(glm(drop~gp2, family=poisson,weights=miss,offset=off))
summary(glm(drop~group+tumour, family=poisson,weights=miss,offset=off))
summary(glm(drop~gp2+tumour, family=poisson,weights=miss,offset=off))
summary(glm(drop~group*tumour, family=poisson,weights=miss,offset=off))
summary(glm(drop~gp2*tumour, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime, family=poisson,weights=miss,offset=off))
summary(glm(drop~time, family=poisson,weights=miss,offset=off))
summary(glm(drop~rtime, family=poisson,weights=miss,offset=off))
summary(glm(drop~rtime+ltime, family=poisson,weights=miss,offset=off))
summary(glm(drop~time+ltime, family=poisson,weights=miss,offset=off))
summary(glm(drop~time+time2, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+rtime, family=poisson,weights=miss,offset=off))
summary(glm(drop~time+rtime, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+ltime2, family=poisson,weights=miss,offset=off))
summary(glm(drop~ftime, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+tumour, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime*tumour, family=poisson,weights=miss,offset=off))
summary(glm(drop~time+time2+tumour, family=poisson,weights=miss,offset=off))
summary(glm(drop~(time+time2)*tumour, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+group, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+gp2, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime*group, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime*gp2, family=poisson,weights=miss,offset=off))
summary(glm(drop~time+time2+tumour+gp2, family=poisson,weights=miss,offset=off))
summary(glm(drop~time+time2+gp2, family=poisson,weights=miss,offset=off))
summary(glm(drop~time+ltime+gp2, family=poisson,weights=miss,offset=off))
summary(glm(drop~time+rtime+gp2, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+ltime2+gp2, family=poisson,weights=miss,offset=off))
summary(glm(drop~gp2+ltime*tumour, family=poisson,weights=miss,offset=off))
summary(glm(drop~(time+time2)*gp2, family=poisson,weights=miss,offset=off))
summary(glm(drop~time*gp2+time2, family=poisson,weights=miss,offset=off))
summary(glm(drop~time*gp2*tumour+time2, family=poisson,weights=miss,offset=off))

if(interactive()){
tt <- seq(7,21,by=0.2)
risk <- function(t,tr) -226.9265+25.1416*t-0.7051*t*t-27.9214*tr+1.5953*t*tr
#postscript("tumour.eps",height=5.7)
par(mfrow=c(1,2))
plot(tt,exp(risk(tt,-1)),type="l",ylab="Risk of dropout",xlab="Days",
	ylim=c(0,0.3),lty=2)
lines(tt,exp(risk(tt,1)),lty=1)
legend(8,0.25,legend=c("A & B","C"),lty=c(1,2),bty="n")

tt <- seq(10,31,by=0.2)
risk <- function(t,tr) -170.1825+13.4520*t-0.2816*t*t-41.0144*tr+1.9086*tr*t
plot(tt,exp(risk(tt,-1)),type="l",lty=2,ylab="",
	xlab="Days",ylim=c(0,0.3))
lines(tt,exp(risk(tt,1)),lty=1)
legend(12,0.25,legend=c("A & B","C"),lty=c(1,2),bty="n")

#postscript("tumour2.eps",height=5.7)
plot(time[21*19+(13:19)],exp(risk(time[21*19+(13:19)],1,tumour[21*19+(13:19)])),
	type="l",lty=3,ylab="Risk of dropout",
	xlab="Days",ylim=c(0,0.6))
lines(time[6*19+(13:19)],exp(risk(time[6*19+(13:19)],1,tumour[6*19+(13:19)])),lty=2)
lines(time[12*19+(13:19)],exp(risk(time[12*19+(13:19)],1,tumour[12*19+(13:19)])),lty=4)
lines(time[25*19+(13:19)],exp(risk(time[25*19+(13:19)],1,tumour[25*19+(13:19)])),lty=1)
legend(25,0.55,legend=c("Mouse A7","Mouse A13","Mouse B7","Mouse B11"),
	lty=c(2,4,3,1))
}
