options(contrasts = c("contr.sum", "contr.poly"))

library(repeated)

y <- read.table("obese.dat",skip=7,head=T)
attach(y)
freq <- as.matrix(y[,1:5])
rr <- c(freq[seq(1,51,by=2),4],freq[seq(2,52,by=2),4])
response <- as.matrix(y[sex==1,6:8])
response <- ifelse(response==9,NA,response)
ccov <- cbind(c(rep("M",5),rep("F",5)),rep(c("a6","a8","a10","a12","a14"),2))
rr2 <- as.vector(c(freq[seq(1,51,by=2),],freq[seq(2,52,by=2),]))

sx <- gl(2,130,260)
cohort <- gl(5,26,260)
resp <- ifelse(is.na(response),3,response)
y77 <- as.factor(rep(resp[,1],10))
y79 <- as.factor(rep(resp[,2],10))
y81 <- as.factor(rep(resp[,3],10))
tmp <- tmp2 <- NULL
for(i in 1:nrow(response)){
      tmp <- c(tmp,sum(response[i,],na.rm=T))
      tmp2 <- c(tmp2,abs(sum(is.na(response[i,]))))}
# abs required for bug in R64.0
latent <- as.factor(rep(tmp-2+5*tmp2,10))
n77 <- y77==1
o77 <- y77==2
m77 <- y77==3
n79 <- y79==1
o79 <- y79==2
m79 <- y79==3
n81 <- y81==1
o81 <- y81==2
m81 <- y81==3
cohortl <- as.numeric(cohort)
cohortq <- cohortl^2
ageobese <- (o77+2*o79+3*o81)*cohortl>2
age6obese <- o77*(cohortl==1)
age12obese <- o77*(cohortl==4)|o79*(cohortl==3)|o81*(cohortl==2)

print(z <- glm(rr2~y77+y79+y81+sx*cohort,family=poisson))
z$aic/2

print(summary(z16 <- glm(rr2~y77+y79+y81+sx*cohort+latent+o77:y79
	+m77:m79+cohort:(m77+m79+m81)+ageobese+sx*ageobese
	+sx:m77:m79+sx:n79:o77+n79:n81+o79:o81+m79:m81+age12obese
	+age6obese,family=poisson)))
z16$aic/2

sum(rr2-rr2*log(rr2+(rr2==0))+lgamma(rr2+1))+260
print(z <- glm(rr2~y77+y79+y81+sx*cohort+latent,family=poisson))
z$aic/2

print(u0 <- catmiss(response,rr2,ccov=ccov))
print(u16 <- catmiss(response,z16$fit,ccov=ccov))

if(interactive()){
postscript("obese.eps")
par(mfrow=c(2,2),font.main=1,mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(c(6,8,10),u0[seq(2,6,by=2),3],xlim=c(6,18),ylim=c(0,0.3),type="l",
	ylab="Pr(obese)",xlab="",main="Boys")
points(c(6,8,10),u0[seq(2,6,by=2),3])
lines(c(8,10,12),u0[seq(8,12,by=2),3])
points(c(8,10,12),u0[seq(8,12,by=2),3],pch=2)
lines(c(10,12,14),u0[seq(14,18,by=2),3])
points(c(10,12,14),u0[seq(14,18,by=2),3],pch=6)
lines(c(12,14,16),u0[seq(20,24,by=2),3])
points(c(12,14,16),u0[seq(20,24,by=2),3],pch=7)
lines(c(14,16,18),u0[seq(26,30,by=2),3])
points(c(14,16,18),u0[seq(26,30,by=2),3],pch=5)
plot(c(6,8,10),u0[seq(32,36,by=2),3],xlim=c(6,18),ylim=c(0,0.3),type="l",
	ylab="",xlab="",main="Girls")
points(c(6,8,10),u0[seq(32,36,by=2),3])
lines(c(8,10,12),u0[seq(38,42,by=2),3])
points(c(8,10,12),u0[seq(38,42,by=2),3],pch=2)
lines(c(10,12,14),u0[seq(44,48,by=2),3])
points(c(10,12,14),u0[seq(44,48,by=2),3],pch=6)
lines(c(12,14,16),u0[seq(50,54,by=2),3])
points(c(12,14,16),u0[seq(50,54,by=2),3],pch=7)
lines(c(14,16,18),u0[seq(56,60,by=2),3])
points(c(14,16,18),u0[seq(56,60,by=2),3],pch=5)
plot(c(6,8,10),u16[seq(2,6,by=2),3],xlim=c(6,18),ylim=c(0,0.3),type="l",
	ylab="Pr(obese)",xlab="Age",main="")
points(c(6,8,10),u16[seq(2,6,by=2),3])
lines(c(8,10,12),u16[seq(8,12,by=2),3])
points(c(8,10,12),u16[seq(8,12,by=2),3],pch=2)
lines(c(10,12,14),u16[seq(14,18,by=2),3])
points(c(10,12,14),u16[seq(14,18,by=2),3],pch=6)
lines(c(12,14,16),u16[seq(20,24,by=2),3])
points(c(12,14,16),u16[seq(20,24,by=2),3],pch=7)
lines(c(14,16,18),u16[seq(26,30,by=2),3])
points(c(14,16,18),u16[seq(26,30,by=2),3],pch=5)
plot(c(6,8,10),u16[seq(32,36,by=2),3],xlim=c(6,18),ylim=c(0,0.3),type="l",
	ylab="",xlab="Age",main="")
points(c(6,8,10),u16[seq(32,36,by=2),3])
lines(c(8,10,12),u16[seq(38,42,by=2),3])
points(c(8,10,12),u16[seq(38,42,by=2),3],pch=2)
lines(c(10,12,14),u16[seq(44,48,by=2),3])
points(c(10,12,14),u16[seq(44,48,by=2),3],pch=6)
lines(c(12,14,16),u16[seq(50,54,by=2),3])
points(c(12,14,16),u16[seq(50,54,by=2),3],pch=7)
lines(c(14,16,18),u16[seq(56,60,by=2),3])
points(c(14,16,18),u16[seq(56,60,by=2),3],pch=5)
legend(15,0.15,c("5-7","7-9","9-11","11-13","13-15"),
	pch=c(1,2,3,6,7,5),bty="n")
dev.off()
}
