library(event)

nausea <- read.table("nausea.dat",skip=8)
attach(nausea)
count <- cbind(V3,V5,V7,V9,V11,V13,V15,V17,V19,V21)[-(58:59),]
time <- cbind(V2,V4,V6,V8,V10,V12,V14,V16,V18,V20)[-(58:59),]
delta <- cbind(V2[-(58:59)],time[,2:10]-time[,1:9])
miss <- time>-1
drop <- matrix(0,nrow=111,ncol=10)
drop[58:63,1:9] <- ifelse(miss[58:63,1:9]&!miss[58:63,2:10],1,0)
drop[102:111,1:9] <- ifelse(miss[102:111,1:9]&!miss[102:111,2:10],1,0)
miss <- as.vector(t(miss))
group <- gl(2,630,1110)[miss]
drop <- as.vector(t(drop))[miss]
count <- as.vector(t(count))[miss]
delta <- as.vector(t(delta))[miss]
time <- as.vector(t(time))
time2 <- (time^2)[miss]/100
time <- time[miss]

ehr(drop,plambda=-2,delta=delta)
ehr(drop,plambda=c(-6,0),delta=delta,lambda=~group)
ehr(drop,plambda=c(-6,0),delta=delta,lambda=~count)
ehr(drop,plambda=c(-6.8,-0.04),delta=delta,lambda=~time)
ehr(drop,plambda=c(-4,-0.05,-0.1),delta=delta,lambda=~time+time2)
print(z <- ehr(drop,plambda=c(-4,-0.05,-0.003,1,0,0),delta=delta,
	lambda=~(time+time2)*group))
ehr(drop,plambda=c(-7.5,-0.16,-0.003,0.017,0,0),delta=delta,
	lambda=~(time+time2)*count)

if(interactive()){
tt <- 1:80
#risk <- function(t,tr) -9.697299+0.352495*t-0.006992*t*t-5.344918*tr+
#	0.352245*tr*t-0.005464*tr*t*t
risk <- function(t,tr) z$coef[1]+z$coef[2]*t+z$coef[3]*t*t/100+z$coef[4]*tr+
	(z$coef[5]*t+z$coef[6]*t*t/100)*tr
postscript("nausea.eps",width=6,height=5.7)
par(mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(tt,exp(risk(tt,1)),type="l",lty=3,yaxt="n",
	ylab="Risk of dropout",xlab="Weeks")
axis(2,c(0,0.004,0.008,0.012))
lines(tt,exp(risk(tt,0)),lty=1)
legend(50,0.01,legend=c("High dose","Placebo"),lty=c(1,3),bty="n")
dev.off()
}
