nausea <- read.table("nausea.dat",skip=8)
attach(nausea)
count <- cbind(V3,V5,V7,V9,V11,V13,V15,V17,V19,V21)[-(58:59),]
time <- cbind(V2,V4,V6,V8,V10,V12,V14,V16,V18,V20)[-(58:59),]
delta <- cbind(V2[-(58:59)],time[,2:10]-time[,1:9])
miss <- time>-1
drop <- matrix(0,nrow=111,ncol=10)
drop[58:63,1:9] <- ifelse(miss[58:63,1:9]&!miss[58:63,2:10],1,0)
drop[102:111,1:9] <- ifelse(miss[102:111,1:9]&!miss[102:111,2:10],1,0)
group <- gl(2,630,1110)

miss <- as.vector(t(miss))
drop <- as.vector(t(drop))
time <- as.vector(t(time))
count <- as.vector(t(count))
delta <- as.vector(t(delta))
off <- ifelse(delta>0,log(delta),0)
time2 <- time^2
ltime <- ifelse(time>0,log(time),0)
ltime2 <- ltime^2
rtime <- 1/time
rtime2 <- rtime^2

glm(drop~1, family=poisson,weights=miss,offset=off)
summary(glm(drop~group, family=poisson,weights=miss,offset=off))
summary(glm(drop~count, family=poisson,weights=miss,offset=off))
summary(glm(drop~time, family=poisson,weights=miss,offset=off))
summary(glm(drop~time2, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime2, family=poisson,weights=miss,offset=off))
summary(glm(drop~rtime, family=poisson,weights=miss,offset=off))
summary(glm(drop~rtime2, family=poisson,weights=miss,offset=off))
summary(glm(drop~time+time2, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+ltime2, family=poisson,weights=miss,offset=off))
summary(glm(drop~time+ltime, family=poisson,weights=miss,offset=off))
summary(glm(drop~time+rtime, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+rtime, family=poisson,weights=miss,offset=off))
summary(glm(drop~time*count, family=poisson,weights=miss,offset=off))
summary(glm(drop~time*group, family=poisson,weights=miss,offset=off))
summary(glm(drop~time*(count+group), family=poisson,weights=miss,offset=off))
summary(glm(drop~(time+time2)*count, family=poisson,weights=miss,offset=off))
summary(glm(drop~(time+time2)*group, family=poisson,weights=miss,offset=off))
summary(glm(drop~(time+rtime)*group, family=poisson,weights=miss,offset=off))
summary(glm(drop~time2*group, family=poisson,weights=miss,offset=off))
summary(glm(drop~(time+time2)*(group+count), family=poisson,weights=miss,offset=off))
summary(glm(drop~(time+time2)*count+group, family=poisson,weights=miss,offset=off))

if(interactive()){
tt <- 1:80
risk <- function(t,tr) -9.697299+0.352495*t-0.006992*t*t-5.344918*tr+
	0.352245*tr*t-0.005464*tr*t*t
#postscript("nausea.eps",width=6,height=5.7)
plot(tt,exp(risk(tt,-1)),type="l",lty=3,
	ylab="Risk of dropout",xlab="Weeks")
lines(tt,exp(risk(tt,1)),lty=1)
legend(50,0.01,legend=c("High dose","Placebo"),lty=c(1,3),bty="n")
}
