halt <- hal <- as.matrix(read.table("halothane.dat",skip=6))
miss <- hal>-1
drop <- matrix(0,nrow=54,ncol=9)
drop[,1:8] <- ifelse(miss[,1:8]&!miss[,2:9],1,0)
time <- rep(c(1,5,10,15,30,60,120,180,240),54)
time2 <- time^2
ltime <- log(time)
ltime2 <- ltime^2
rtime <- 1/time
rtime2 <- rtime^2
ftime <- as.factor(time)
off <- log(rep(c(1,4,5,5,15,30,60,60,60),54))
group <- as.factor(c(rep(1,99),rep(2,90),rep(3,99),rep(4,99),rep(5,99)))
gp2 <- as.factor(group==5)

miss <- as.vector(t(miss))
drop <- as.vector(t(drop))
hal <- as.vector(t(hal))
glm(drop~1, family=poisson,weights=miss,offset=off)
summary(glm(drop~hal, family=poisson,weights=miss,offset=off))
summary(glm(drop~group, family=poisson,weights=miss,offset=off))
summary(glm(drop~gp2, family=poisson,weights=miss,offset=off))
summary(glm(drop~group+hal, family=poisson,weights=miss,offset=off))
summary(glm(drop~group*hal, family=poisson,weights=miss,offset=off))
summary(glm(drop~time, family=poisson,weights=miss,offset=off))
summary(glm(drop~time2, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime2, family=poisson,weights=miss,offset=off))
summary(glm(drop~rtime, family=poisson,weights=miss,offset=off))
summary(glm(drop~rtime2, family=poisson,weights=miss,offset=off))
summary(glm(drop~ftime, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+time, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime2+time, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+rtime, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+rtime+ltime2, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+time+hal, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+rtime+hal, family=poisson,weights=miss,offset=off))
summary(glm(drop~(ltime+time)*hal, family=poisson,weights=miss,offset=off))
summary(glm(drop~(rtime+ltime)*hal, family=poisson,weights=miss,offset=off))
summary(glm(drop~ftime*hal, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+time+group, family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+rtime+group, family=poisson,weights=miss,offset=off))
summary(glm(drop~(ltime+time)*group, family=poisson,weights=miss,offset=off))
summary(glm(drop~(ltime+rtime)*group, family=poisson,weights=miss,offset=off))
summary(glm(drop~(ltime+time)*(group+hal), family=poisson,weights=miss,offset=off))
summary(glm(drop~(ltime+rtime)*(group+hal), family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+time*(group+hal), family=poisson,weights=miss,offset=off))
summary(glm(drop~ltime+time*hal+group, family=poisson,weights=miss,offset=off))
summary(glm(drop~(ltime+rtime)*hal+group, family=poisson,weights=miss,offset=off))
summary(glm(drop~(ltime+time)*(group+hal)+group:hal, family=poisson,weights=miss,offset=off))
summary(glm(drop~(ltime+rtime)*hal+group+group:hal, family=poisson,weights=miss,offset=off))
summary(glm(drop~(ltime+time)*gp2, family=poisson,weights=miss,offset=off))
glm(drop~ftime*gp2, family=poisson,weights=miss,offset=off)

if(interactive()){
tt <- 1:240
risk <- function(t,hal) 9.98438-25.44882/t-3.76162*log(t)-0.11284*hal+
	0.22242*hal/t+0.02565*hal*log(t)
#postscript("haloth.eps",width=6,height=5.7)
par(mfrow=c(1,2))
plot(tt,exp(risk(tt,120)),type="l",lty=3,ylim=c(0,0.33),
	ylab="Risk of dropout",xlab="Minutes")
lines(tt,exp(risk(tt,70)),lty=2)
lines(tt,exp(risk(tt,20)),lty=1)
legend(50,0.20,legend=c("20 mm Hg","70 mm Hg","120 mm Hg"),
	lty=c(1,2,3),bty="n")

plot(time[10*9+(1:9)],exp(risk(time[10*9+(1:9)],hal[10*9+(1:9)])),
	type="l",lty=3,ylim=c(0,0.33),
	ylab="",xlab="Minutes")
lines(time[20*9+(1:9)],exp(risk(time[20*9+(1:9)],hal[20*9+(1:9)])),lty=2)
lines(time[29*9+(1:9)],exp(risk(time[29*9+(1:9)],hal[29*9+(1:9)])),lty=4)
lines(time[33*9+(1:9)],exp(risk(time[33*9+(1:9)],hal[33*9+(1:9)])),lty=1)
legend(20,0.20,legend=c("Rat 11 (0%)","Rat 10 (0.25%)","Rat 9 (0.5%)",
	"Rat 2 (1%)"),lty=c(3,2,4,1),bty="n")
}

resp <- cbind(halt[,1:4],halt[,5],halt[,5],halt[,5])
for(i in 1:6) resp <- cbind(resp,halt[,6])
for(i in 1:12) resp <- cbind(resp,halt[,7])
for(i in 1:12) resp <- cbind(resp,halt[,8])
for(i in 1:12) resp <- cbind(resp,halt[,9])
miss <- resp>-1
drop <- matrix(0,nrow=54,ncol=49)
drop[,1:48] <- ifelse(miss[,1:48]&!miss[,2:49],1,0)
time <- rep(1:49,54)
ftime <- as.factor(time)
ltime <- log(time)
group <- as.factor(c(rep(1,539),rep(2,490),rep(3,539),rep(4,539),rep(5,539)))

miss <- as.vector(t(miss))
drop <- as.vector(t(drop))
resp <- as.vector(t(resp))
glm(drop~1, family=poisson,weights=miss)
summary(glm(drop~resp, family=poisson,weights=miss))
summary(glm(drop~group, family=poisson,weights=miss))
summary(glm(drop~group+resp, family=poisson,weights=miss))
summary(glm(drop~group*resp, family=poisson,weights=miss))
summary(glm(drop~ltime, family=poisson,weights=miss))
summary(glm(drop~time, family=poisson,weights=miss))
#summary(glm(drop~ftime, family=poisson,weights=miss))
summary(glm(drop~time*resp, family=poisson,weights=miss))
summary(glm(drop~time*group, family=poisson,weights=miss))
summary(glm(drop~time*group+group*resp, family=poisson,weights=miss))
