library(event)

hal <- as.matrix(read.table("halothane.dat",skip=6))
miss <- hal>-1
drop <- matrix(0,nrow=54,ncol=9)
drop[,1:8] <- ifelse(miss[,1:8]&!miss[,2:9],1,0)
miss <- as.vector(t(miss))
group <- as.factor(c(rep(1,99),rep(2,90),rep(3,99),rep(4,99),rep(5,99)))
gp2 <- as.factor(group==5)[miss]
group <- group[miss]
time <- rep(c(1,5,10,15,30,60,120,180,240),54)
ltime <- log(time)[miss]
rtime <- 1/time[miss]
ftime <- as.factor(time)[miss]
off <- rep(c(1,4,5,5,15,30,60,60,60),54)[miss]
drop <- as.vector(t(drop))[miss]
halp <- t(hal)/10
hal <- as.vector(t(hal))[miss]/10

ehr(drop,plambda=-2,delta=off)
ehr(drop,plambda=c(-5,0,0,0,0),delta=off,lambda=~group)
ehr(drop,plambda=c(-5,0),delta=off,lambda=~gp2)
ehr(drop,plambda=c(-4,0),delta=off,lambda=~hal)
ehr(drop,plambda=c(-2,-1),delta=off,lambda=~ltime)
ehr(drop,plambda=c(-2,-1,0),delta=off,lambda=~ltime+rtime)
ehr(drop,plambda=c(-2,rep(0,8)),delta=off,lambda=~ftime)
print(z <- ehr(drop,plambda=c(-2,-1,0,0,0,0),delta=off,
	lambda=~(ltime+rtime)*hal))
ehr(drop,plambda=c(-6,rep(0,17)),delta=off,lambda=~ftime*hal,iter=200)
ehr(drop,plambda=c(-2,-1,0,0,0,0),delta=off,lambda=~(ltime+rtime)*gp2)
ehr(drop,plambda=c(-4,rep(0,17)),delta=off,lambda=~ftime*gp2)


if(interactive()){
tt <- 1:240
risk <- function(t,hal) z$coef[1]+z$coef[2]*log(t)+z$coef[3]/t+
	z$coef[4]*hal+(z$coef[5]*log(t)+z$coef[6]/t)*hal
postscript("haloth.eps",height=5.7)
par(mfrow=c(1,2),mar=c(3.5,3.5,3,1),mgp=c(2.5,1,0))
plot(tt,exp(risk(tt,120/10)),type="l",lty=3,ylim=c(0,0.2),
	ylab="Risk of dropout",xlab="Minutes")
lines(tt,exp(risk(tt,70/10)),lty=2)
lines(tt,exp(risk(tt,20/10)),lty=1)
legend(100,0.20,legend=c("  20 mmHg","  70 mmHg","120 mmHg"),
	lty=c(1,2,3),bty="n")
plot(time[10*9+(1:9)],exp(risk(time[10*9+(1:9)],halp[10*9+(1:9)])),
	type="l",lty=3,ylim=c(0,0.2),ylab="",xlab="Minutes")
lines(time[20*9+(1:9)],exp(risk(time[20*9+(1:9)],halp[20*9+(1:9)])),lty=2)
lines(time[29*9+(1:9)],exp(risk(time[29*9+(1:9)],halp[29*9+(1:9)])),lty=4)
lines(time[33*9+(1:9)],exp(risk(time[33*9+(1:9)],halp[33*9+(1:9)])),lty=1)
legend(100,0.20,legend=c("Rat 11 (0%)","Rat 10 (0.25%)","Rat   9 (0.5%)",
	"Rat   2 (1%)"),lty=c(3,2,4,1),bty="n")
dev.off()
}
