library(repeated)
library(gnlm)

data <- read.table("fluvox1.dat",skip=3,head=T)
attach(data)
resp <- cbind(rep(V1,Freq),rep(V2,Freq),rep(V3,Freq))
resp[269:299,3] <- NA
resp <- as.vector(t(resp))
id <- as.numeric(gl(299,3,897))[!is.na(resp)]
times <- rep(c(-1,0,1),299)[!is.na(resp)]
resp <- resp[!is.na(resp)]

logitord(resp,id,tvcov=times,pout=c(-1.4,0.5,2,0),pdrop=c(4.6,-1.4))
logitord(resp,id,tvcov=times,pout=c(-2.3,1.8,5,5),pdrop=c(3,1),
	random.drop.sl=F,random.drop.int=F)
logitord(resp,id,tvcov=times,pout=c(-2.3,1.8,5,5),pdrop=c(3),
	drop.tvcov=F,random.drop.sl=F)
logitord(resp,id,tvcov=times,pout=c(-1.4,0.5,2),pdrop=c(4.6,-1.4),out.tvcov=F)
logitord(resp,id,tvcov=times,pout=c(-2.3,1.8,5,5),pdrop=c(3,1),
	random.drop.sl=F,random.drop.int=F)
logitord(resp,id,tvcov=times,pout=c(-2.3,1.8,5,5),pdrop=3,
	drop.tvcov=F,random.drop.sl=F,random.drop.int=F)

resp <- ifelse(resp>0,5-resp,0)
logitord(resp,id,tvcov=times,pout=c(-1,0.5,1,0),pdrop=c(2,-1))
